/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.validator.jsonschema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Joiner;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.character.Character;
import org.mockserver.file.FileReader;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.mockserver.model.RequestDefinition;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.validator.Validator;
import org.mockserver.version.Version;
import org.slf4j.event.Level;

public class JsonSchemaValidator
extends ObjectWithReflectiveEqualsHashCodeToString
implements Validator<String> {
    public static final String OPEN_API_SPECIFICATION_URL = "OpenAPI Specification: https://app.swaggerhub.com/apis/jamesdbloom/mock-server-openapi/" + Version.getMajorMinorVersion() + ".x" + Character.NEW_LINE + "Documentation: https://mock-server.com/mock_server/creating_expectations.html";
    private static final Map<String, String> schemaCache = new ConcurrentHashMap<String, String>();
    private static final SpecVersion.VersionFlag DEFAULT_JSON_SCHEMA_VERSION = SpecVersion.VersionFlag.V7;
    private final MockServerLogger mockServerLogger;
    private final Class<?> type;
    private final String schema;
    private final JsonNode schemaJsonNode;
    private JsonSchema validator;
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.createObjectMapper();

    public JsonSchemaValidator(MockServerLogger mockServerLogger, String schema) {
        this.mockServerLogger = mockServerLogger;
        this.type = null;
        if (schema.trim().endsWith(".json")) {
            this.schema = FileReader.readFileFromClassPathOrPath(schema);
        } else if (schema.trim().endsWith("}")) {
            this.schema = schema;
        } else {
            throw new IllegalArgumentException("Schema must either be a path reference to a *.json file or a json string");
        }
        this.schemaJsonNode = this.getSchemaJsonNode();
        this.validator = this.getJsonSchemaFactory(this.schemaJsonNode).getSchema(this.schemaJsonNode);
    }

    public JsonSchemaValidator(MockServerLogger mockServerLogger, String schema, JsonNode schemaJsonNode) {
        this.mockServerLogger = mockServerLogger;
        this.type = null;
        this.schema = schema;
        this.schemaJsonNode = schemaJsonNode;
        this.validator = this.getJsonSchemaFactory(this.schemaJsonNode).getSchema(this.schemaJsonNode);
    }

    public JsonSchemaValidator(MockServerLogger mockServerLogger, Class<?> type, String routePath, String mainSchemeFile, String ... referenceFiles) {
        this.mockServerLogger = mockServerLogger;
        this.type = type;
        if (!schemaCache.containsKey(mainSchemeFile)) {
            schemaCache.put(mainSchemeFile, this.addReferencesIntoSchema(routePath, mainSchemeFile, referenceFiles));
        }
        this.schema = schemaCache.get(mainSchemeFile);
        this.schemaJsonNode = this.getSchemaJsonNode();
        this.validator = this.getJsonSchemaFactory(this.schemaJsonNode).getSchema(this.schemaJsonNode);
    }

    private JsonSchemaFactory getJsonSchemaFactory(JsonNode schema) {
        String metaSchemaValue;
        JsonNode metaSchema;
        if (schema != null && (metaSchema = schema.get("$schema")) != null && StringUtils.isNotBlank((CharSequence)(metaSchemaValue = metaSchema.textValue()))) {
            return this.getJsonSchemaFactory(metaSchemaValue);
        }
        return JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)DEFAULT_JSON_SCHEMA_VERSION);
    }

    private JsonSchemaFactory getJsonSchemaFactory(String metaSchemaValue) {
        if (metaSchemaValue.contains("draft-03") || metaSchemaValue.contains("draft-04")) {
            return JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V4);
        }
        if (metaSchemaValue.contains("draft-05") || metaSchemaValue.contains("draft-06")) {
            return JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V6);
        }
        if (metaSchemaValue.contains("draft-07")) {
            return JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V7);
        }
        if (metaSchemaValue.contains("draft/2019-09")) {
            return JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V201909);
        }
        return JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)DEFAULT_JSON_SCHEMA_VERSION);
    }

    private JsonNode getSchemaJsonNode() {
        try {
            return OBJECT_MAPPER.readTree(this.schema);
        }
        catch (Throwable throwable) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception loading JSON Schema " + throwable.getMessage()).setThrowable(throwable));
            throw new RuntimeException("Unable to parse JSON schema", throwable);
        }
    }

    public String getSchema() {
        return this.schema;
    }

    private String addReferencesIntoSchema(String routePath, String mainSchemeFile, String ... referenceFiles) {
        String combinedSchema = "";
        try {
            ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();
            JsonNode jsonSchema = objectMapper.readTree(FileReader.readFileFromClassPathOrPath(routePath + mainSchemeFile + ".json"));
            JsonNode definitions = jsonSchema.get("definitions");
            if (definitions instanceof ObjectNode) {
                for (String definitionName : referenceFiles) {
                    JsonNode definition = objectMapper.readTree(FileReader.readFileFromClassPathOrPath(routePath + definitionName + ".json"));
                    ((ObjectNode)definitions).set(definitionName, definition);
                    if (definition == null || definition.get("definitions") == null) continue;
                    StreamSupport.stream(Spliterators.spliteratorUnknownSize(definition.get("definitions").fields(), 16), false).forEach(stringJsonNodeEntry -> ((ObjectNode)definitions).set((String)stringJsonNodeEntry.getKey(), (JsonNode)stringJsonNodeEntry.getValue()));
                }
            }
            combinedSchema = ObjectMapperFactory.createObjectMapper(true, false, new JsonSerializer[0]).writeValueAsString((Object)jsonSchema);
        }
        catch (Throwable throwable) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception loading JSON Schema " + throwable.getMessage()).setThrowable(throwable));
        }
        return combinedSchema;
    }

    @Override
    public String isValid(String json) {
        return this.isValid(json, true);
    }

    public String isValid(String json, boolean addOpenAPISpecificationMessage) {
        String validationResult = "";
        if (StringUtils.isNotBlank((CharSequence)json)) {
            try {
                validationResult = this.formatProcessingReport(this.validator.validate(OBJECT_MAPPER.readTree(json)), addOpenAPISpecificationMessage);
            }
            catch (Throwable throwable) {
                if (StringUtils.isNotBlank((CharSequence)throwable.getMessage()) && throwable.getMessage().contains("Unknown MetaSchema")) {
                    this.validator = this.getJsonSchemaFactory(throwable.getMessage()).getSchema(this.schemaJsonNode);
                    return this.isValid(json, addOpenAPISpecificationMessage);
                }
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception validating JSON").setThrowable(throwable));
                return throwable.getClass().getSimpleName() + " - " + throwable.getMessage();
            }
        }
        return validationResult;
    }

    private String formatProcessingReport(Set<ValidationMessage> validationMessages, boolean addOpenAPISpecificationMessage) {
        if (validationMessages.isEmpty()) {
            return "";
        }
        HashSet extraMessages = new HashSet();
        Set formattedMessages = validationMessages.stream().map(validationMessage -> {
            String validationMessageText = String.valueOf(validationMessage);
            if (validationMessageText.startsWith("$.httpRequest") && validationMessageText.contains(".body: should be valid to any of the schemas") || validationMessageText.contains("$.body: should be valid to any of the schemas")) {
                return StringUtils.substringBefore((String)validationMessageText, (String)":") + ": should match one of its valid types: " + FileReader.readFileFromClassPathOrPath("org/mockserver/model/schema/body.json").replaceAll("#/definitions/draft-07", "http://json-schema.org/draft-07/schema").replaceAll(Character.NEW_LINE, Character.NEW_LINE + "   ");
            }
            if (validationMessageText.contains(".specUrlOrPayload: is missing but it is required")) {
                return StringUtils.substringBefore((String)validationMessageText, (String)":") + ": is missing, but is required, if specifying OpenAPI request matcher";
            }
            if (validationMessageText.startsWith("$.httpResponse.body: should be valid to any of the schemas")) {
                return "$.httpResponse.body: should match one of its valid types: " + FileReader.readFileFromClassPathOrPath("org/mockserver/model/schema/bodyWithContentType.json").replaceAll(Character.NEW_LINE, Character.NEW_LINE + "   ");
            }
            if ((validationMessageText.contains(".httpRequest") || RequestDefinition.class.equals(this.type)) && (validationMessageText.contains(".secure: is not defined in the schema and the schema does not allow additional properties") || validationMessageText.contains(".keepAlive: is not defined in the schema and the schema does not allow additional properties") || validationMessageText.contains(".method: is not defined in the schema and the schema does not allow additional properties") || validationMessageText.contains(".path: is not defined in the schema and the schema does not allow additional properties") || validationMessageText.contains(".pathParameters: is not defined in the schema and the schema does not allow additional properties") || validationMessageText.contains(".queryStringParameters: is not defined in the schema and the schema does not allow additional properties") || validationMessageText.contains(".body: is not defined in the schema and the schema does not allow additional properties") || validationMessageText.contains(".headers: is not defined in the schema and the schema does not allow additional properties") || validationMessageText.contains(".cookies: is not defined in the schema and the schema does not allow additional properties") || validationMessageText.contains(".socketAddress: is not defined in the schema and the schema does not allow additional properties") || validationMessageText.contains(".localAddress: is not defined in the schema and the schema does not allow additional properties") || validationMessageText.contains(".remoteAddress: is not defined in the schema and the schema does not allow additional properties") || validationMessageText.contains(".specUrlOrPayload: is not defined in the schema and the schema does not allow additional properties") || validationMessageText.contains(".operationId: is not defined in the schema and the schema does not allow additional properties"))) {
                return null;
            }
            if (validationMessageText.endsWith("cookies: object found, array expected")) {
                return StringUtils.substringBefore((String)validationMessageText, (String)":") + ": invalid cookie format, the following are valid examples: " + Character.NEW_LINE + "  " + Character.NEW_LINE + "     {" + Character.NEW_LINE + "         \"exampleRegexCookie\": \"^some +regex$\", " + Character.NEW_LINE + "         \"exampleNottedRegexCookie\": \"!notThisValue\", " + Character.NEW_LINE + "         \"exampleSimpleStringCookie\": \"simpleStringMatch\"" + Character.NEW_LINE + "     }" + Character.NEW_LINE + "  " + Character.NEW_LINE + "  or:" + Character.NEW_LINE + "  " + Character.NEW_LINE + "     {" + Character.NEW_LINE + "         \"exampleNumberSchemaCookie\": {" + Character.NEW_LINE + "             \"type\": \"number\"" + Character.NEW_LINE + "         }, " + Character.NEW_LINE + "         \"examplePatternSchemaCookie\": {" + Character.NEW_LINE + "             \"type\": \"string\", " + Character.NEW_LINE + "             \"pattern\": \"^some regex$\"" + Character.NEW_LINE + "         }, " + Character.NEW_LINE + "         \"exampleFormatSchemaCookie\": {" + Character.NEW_LINE + "             \"type\": \"string\", " + Character.NEW_LINE + "             \"format\": \"ipv4\"" + Character.NEW_LINE + "         }" + Character.NEW_LINE + "     }";
            }
            if (validationMessageText.endsWith("headers: object found, array expected")) {
                return StringUtils.substringBefore((String)validationMessageText, (String)":") + ": invalid header format, the following are valid examples: " + Character.NEW_LINE + "  " + Character.NEW_LINE + "     {" + Character.NEW_LINE + "         \"exampleRegexHeader\": [" + Character.NEW_LINE + "             \"^some +regex$\"" + Character.NEW_LINE + "         ], " + Character.NEW_LINE + "         \"exampleNottedAndSimpleStringHeader\": [" + Character.NEW_LINE + "             \"!notThisValue\", " + Character.NEW_LINE + "             \"simpleStringMatch\"" + Character.NEW_LINE + "         ]" + Character.NEW_LINE + "     }" + Character.NEW_LINE + "  " + Character.NEW_LINE + "  or:" + Character.NEW_LINE + "  " + Character.NEW_LINE + "     {" + Character.NEW_LINE + "         \"exampleSchemaHeader\": [" + Character.NEW_LINE + "             {" + Character.NEW_LINE + "                 \"type\": \"number\"" + Character.NEW_LINE + "             }" + Character.NEW_LINE + "         ], " + Character.NEW_LINE + "         \"exampleMultiSchemaHeader\": [" + Character.NEW_LINE + "             {" + Character.NEW_LINE + "                 \"type\": \"string\", " + Character.NEW_LINE + "                 \"pattern\": \"^some +regex$\"" + Character.NEW_LINE + "             }, " + Character.NEW_LINE + "             {" + Character.NEW_LINE + "                 \"type\": \"string\", " + Character.NEW_LINE + "                 \"format\": \"ipv4\"" + Character.NEW_LINE + "             }" + Character.NEW_LINE + "         ]" + Character.NEW_LINE + "     }";
            }
            if (validationMessageText.endsWith("pathParameters: object found, array expected") || validationMessageText.endsWith("queryStringParameters: object found, array expected")) {
                return StringUtils.substringBefore((String)validationMessageText, (String)":") + ": invalid parameter format, the following are valid examples: " + Character.NEW_LINE + "  " + Character.NEW_LINE + "     {" + Character.NEW_LINE + "         \"exampleRegexParameter\": [" + Character.NEW_LINE + "             \"^some +regex$\"" + Character.NEW_LINE + "         ], " + Character.NEW_LINE + "         \"exampleNottedAndSimpleStringParameter\": [" + Character.NEW_LINE + "             \"!notThisValue\", " + Character.NEW_LINE + "             \"simpleStringMatch\"" + Character.NEW_LINE + "         ]" + Character.NEW_LINE + "     }" + Character.NEW_LINE + "  " + Character.NEW_LINE + "  or:" + Character.NEW_LINE + "  " + Character.NEW_LINE + "     {" + Character.NEW_LINE + "         \"exampleSchemaParameter\": [" + Character.NEW_LINE + "             {" + Character.NEW_LINE + "                 \"type\": \"number\"" + Character.NEW_LINE + "             }" + Character.NEW_LINE + "         ], " + Character.NEW_LINE + "         \"exampleMultiSchemaParameter\": [" + Character.NEW_LINE + "             {" + Character.NEW_LINE + "                 \"type\": \"string\", " + Character.NEW_LINE + "                 \"pattern\": \"^some +regex$\"" + Character.NEW_LINE + "             }, " + Character.NEW_LINE + "             {" + Character.NEW_LINE + "                 \"type\": \"string\", " + Character.NEW_LINE + "                 \"format\": \"ipv4\"" + Character.NEW_LINE + "             }" + Character.NEW_LINE + "         ]" + Character.NEW_LINE + "     }";
            }
            if (validationMessageText.startsWith("$.http") && validationMessageText.endsWith(": is missing but it is required")) {
                extraMessages.add("oneOf of the following must be specified [httpError, httpForward, httpForwardClassCallback, httpForwardObjectCallback, httpForwardTemplate, httpOverrideForwardedRequest, httpResponse, httpResponseClassCallback, httpResponseObjectCallback, httpResponseTemplate]");
                return StringUtils.substringBefore((String)validationMessageText, (String)":") + ": is missing, but is required, if specifying action of type " + StringUtils.substringBefore((String)StringUtils.substringAfter((String)validationMessageText, (String)"$.http"), (String)":");
            }
            return validationMessageText;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        formattedMessages.addAll(extraMessages);
        List validationMessageTexts = formattedMessages.stream().filter(formattedMessage -> !formattedMessage.endsWith("object expected") || !formattedMessages.contains(formattedMessage.replace("object expected", "string expected"))).sorted().collect(Collectors.toList());
        return validationMessageTexts.size() + " error" + (validationMessageTexts.size() > 1 ? "s" : "") + ":" + Character.NEW_LINE + " - " + Joiner.on((String)(Character.NEW_LINE + " - ")).join(validationMessageTexts) + (addOpenAPISpecificationMessage ? Character.NEW_LINE + Character.NEW_LINE + OPEN_API_SPECIFICATION_URL : "");
    }
}

