/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.serializers.certificate;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CertificateSerializer
extends StdSerializer<Certificate> {
    public CertificateSerializer() {
        super(Certificate.class);
    }

    public void serialize(Certificate certificate, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        if (certificate instanceof X509Certificate) {
            String subjectDN;
            String issuerDN22;
            X509Certificate x509Certificate = (X509Certificate)certificate;
            jgen.writeObjectField("version", (Object)x509Certificate.getVersion());
            if (x509Certificate.getSerialNumber() != null) {
                jgen.writeObjectField("serialNumber", (Object)x509Certificate.getSerialNumber().toString());
            }
            if (x509Certificate.getIssuerX500Principal() != null && StringUtils.isNotBlank((CharSequence)(issuerDN22 = x509Certificate.getIssuerX500Principal().getName("RFC2253")))) {
                jgen.writeObjectField("issuerDN", (Object)issuerDN22);
            }
            try {
                if (x509Certificate.getIssuerAlternativeNames() != null && !x509Certificate.getIssuerAlternativeNames().isEmpty()) {
                    this.writeCollectionOfLists("issuerAlternativeNames", x509Certificate.getIssuerAlternativeNames(), jgen);
                }
            }
            catch (CertificateParsingException issuerDN22) {
                // empty catch block
            }
            if (x509Certificate.getSubjectX500Principal() != null && StringUtils.isNotBlank((CharSequence)(subjectDN = x509Certificate.getSubjectX500Principal().getName("RFC2253")))) {
                jgen.writeObjectField("subjectDN", (Object)subjectDN);
            }
            try {
                if (x509Certificate.getSubjectAlternativeNames() != null && !x509Certificate.getSubjectAlternativeNames().isEmpty()) {
                    this.writeCollectionOfLists("subjectAlternativeNames", x509Certificate.getSubjectAlternativeNames(), jgen);
                }
            }
            catch (CertificateParsingException certificateParsingException) {
                // empty catch block
            }
            if (StringUtils.isNotBlank((CharSequence)x509Certificate.getSigAlgOID())) {
                jgen.writeObjectField("sigAlgOID", (Object)x509Certificate.getSigAlgOID());
            }
            if (StringUtils.isNotBlank((CharSequence)x509Certificate.getSigAlgName())) {
                jgen.writeObjectField("sigAlgName", (Object)x509Certificate.getSigAlgName());
            }
            if (StringUtils.isNotBlank((CharSequence)x509Certificate.getSigAlgName())) {
                jgen.writeObjectField("sigAlgName", (Object)x509Certificate.getSigAlgName());
            }
            try {
                if (x509Certificate.getExtendedKeyUsage() != null && !x509Certificate.getExtendedKeyUsage().isEmpty()) {
                    this.writeCollection("extendedKeyUsage", x509Certificate.getExtendedKeyUsage(), jgen);
                }
            }
            catch (CertificateParsingException certificateParsingException) {
                // empty catch block
            }
            if (x509Certificate.getNotBefore() != null) {
                jgen.writeObjectField("notBefore", (Object)x509Certificate.getNotBefore().toString());
            }
            if (x509Certificate.getNotAfter() != null) {
                jgen.writeObjectField("notAfter", (Object)x509Certificate.getNotAfter().toString());
            }
        }
        jgen.writeEndObject();
    }

    private void writeCollection(String name, Collection<?> collection, JsonGenerator jgen) throws IOException {
        jgen.writeArrayFieldStart(name);
        for (Object item : collection) {
            jgen.writeObject(item);
        }
        jgen.writeEndArray();
    }

    private void writeCollectionOfLists(String name, Collection<List<?>> collection, JsonGenerator jgen) throws IOException {
        jgen.writeArrayFieldStart(name);
        for (Object item : collection.stream().flatMap(objects -> objects.stream().filter(item -> item instanceof String)).collect(Collectors.toList())) {
            jgen.writeObject(item);
        }
        jgen.writeEndArray();
    }
}

