/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.serializers.body;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.JsonBody;
import org.mockserver.serialization.ObjectMapperFactory;

public class JsonBodySerializer
extends StdSerializer<JsonBody> {
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.createObjectMapper();
    private final boolean serialiseDefaultValues;

    public JsonBodySerializer(boolean serialiseDefaultValues) {
        super(JsonBody.class);
        this.serialiseDefaultValues = serialiseDefaultValues;
    }

    public void serialize(JsonBody jsonBody, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        boolean matchTypeNonDefault;
        boolean notNonDefault = jsonBody.getNot() != null && jsonBody.getNot() != false;
        boolean optionalNonDefault = jsonBody.getOptional() != null && jsonBody.getOptional() != false;
        boolean contentTypeNonDefault = jsonBody.getContentType() != null && !jsonBody.getContentType().equals(JsonBody.DEFAULT_JSON_CONTENT_TYPE.toString());
        boolean bl = matchTypeNonDefault = jsonBody.getMatchType() != JsonBody.DEFAULT_MATCH_TYPE;
        if (this.serialiseDefaultValues || notNonDefault || optionalNonDefault || contentTypeNonDefault || matchTypeNonDefault) {
            jgen.writeStartObject();
            if (notNonDefault) {
                jgen.writeBooleanField("not", jsonBody.getNot().booleanValue());
            }
            if (optionalNonDefault) {
                jgen.writeBooleanField("optional", jsonBody.getOptional().booleanValue());
            }
            if (contentTypeNonDefault) {
                jgen.writeStringField("contentType", jsonBody.getContentType());
            }
            jgen.writeStringField("type", jsonBody.getType().name());
            try {
                jgen.writeObjectField("json", (Object)OBJECT_MAPPER.readTree(jsonBody.getValue()));
            }
            catch (Throwable throwable) {
                new MockServerLogger().logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setMessageFormat("exception:{} while deserialising jsonBody with json:{}").setArguments(throwable.getMessage(), jsonBody.getValue()).setThrowable(throwable));
            }
            if (matchTypeNonDefault) {
                jgen.writeStringField("matchType", jsonBody.getMatchType().name());
            }
            jgen.writeEndObject();
        } else {
            jgen.writeObject((Object)OBJECT_MAPPER.readTree(jsonBody.getValue()));
        }
    }
}

