/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.model;

import org.mockserver.model.ExpectationId;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.ObjectWithJsonToString;
import org.mockserver.model.OpenAPIDefinition;
import org.mockserver.serialization.model.DTO;
import org.mockserver.serialization.model.HttpRequestDTO;
import org.mockserver.serialization.model.OpenAPIDefinitionDTO;
import org.mockserver.serialization.model.RequestDefinitionDTO;
import org.mockserver.serialization.model.VerificationTimesDTO;
import org.mockserver.verify.Verification;
import org.mockserver.verify.VerificationTimes;

public class VerificationDTO
extends ObjectWithJsonToString
implements DTO<Verification> {
    private RequestDefinitionDTO httpRequest;
    private ExpectationId expectationId;
    private VerificationTimesDTO times;
    private Integer maximumNumberOfRequestToReturnInVerificationFailure;

    public VerificationDTO(Verification verification) {
        if (verification != null) {
            if (verification.getHttpRequest() instanceof HttpRequest) {
                this.httpRequest = new HttpRequestDTO((HttpRequest)verification.getHttpRequest());
            } else if (verification.getHttpRequest() instanceof OpenAPIDefinition) {
                this.httpRequest = new OpenAPIDefinitionDTO((OpenAPIDefinition)verification.getHttpRequest());
            }
            this.expectationId = verification.getExpectationId();
            this.times = new VerificationTimesDTO(verification.getTimes());
            this.maximumNumberOfRequestToReturnInVerificationFailure = verification.getMaximumNumberOfRequestToReturnInVerificationFailure();
        }
    }

    public VerificationDTO() {
    }

    @Override
    public Verification buildObject() {
        return Verification.verification().withRequest(this.httpRequest != null ? this.httpRequest.buildObject() : null).withExpectationId(this.expectationId).withTimes(this.times != null ? this.times.buildObject() : VerificationTimes.once()).withMaximumNumberOfRequestToReturnInVerificationFailure(this.maximumNumberOfRequestToReturnInVerificationFailure);
    }

    public RequestDefinitionDTO getHttpRequest() {
        return this.httpRequest;
    }

    public VerificationDTO setHttpRequest(HttpRequestDTO httpRequest) {
        this.httpRequest = httpRequest;
        return this;
    }

    public ExpectationId getExpectationId() {
        return this.expectationId;
    }

    public VerificationDTO setExpectationId(ExpectationId expectationId) {
        this.expectationId = expectationId;
        return this;
    }

    public VerificationTimesDTO getTimes() {
        return this.times;
    }

    public VerificationDTO setTimes(VerificationTimesDTO times) {
        this.times = times;
        return this;
    }

    public Integer getMaximumNumberOfRequestToReturnInVerificationFailure() {
        return this.maximumNumberOfRequestToReturnInVerificationFailure;
    }

    public VerificationDTO setMaximumNumberOfRequestToReturnInVerificationFailure(Integer maximumNumberOfRequestToReturnInVerificationFailure) {
        this.maximumNumberOfRequestToReturnInVerificationFailure = maximumNumberOfRequestToReturnInVerificationFailure;
        return this;
    }
}

