/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.model;

import org.mockserver.model.Delay;
import org.mockserver.model.HttpForward;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.mockserver.serialization.model.DTO;
import org.mockserver.serialization.model.DelayDTO;

public class HttpForwardDTO
extends ObjectWithReflectiveEqualsHashCodeToString
implements DTO<HttpForward> {
    private String host;
    private Integer port;
    private HttpForward.Scheme scheme;
    private DelayDTO delay;

    public HttpForwardDTO(HttpForward httpForward) {
        if (httpForward != null) {
            this.host = httpForward.getHost();
            this.port = httpForward.getPort();
            this.scheme = httpForward.getScheme();
            if (httpForward.getDelay() != null) {
                this.delay = new DelayDTO(httpForward.getDelay());
            }
        }
    }

    public HttpForwardDTO() {
    }

    @Override
    public HttpForward buildObject() {
        Delay delay = null;
        if (this.delay != null) {
            delay = this.delay.buildObject();
        }
        return (HttpForward)new HttpForward().withHost(this.host).withPort(this.port != null ? this.port : 80).withScheme(this.scheme != null ? this.scheme : HttpForward.Scheme.HTTP).withDelay(delay);
    }

    public String getHost() {
        return this.host;
    }

    public HttpForwardDTO setHost(String host) {
        this.host = host;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public HttpForwardDTO setPort(Integer port) {
        this.port = port;
        return this;
    }

    public HttpForward.Scheme getScheme() {
        return this.scheme;
    }

    public HttpForwardDTO setScheme(HttpForward.Scheme scheme) {
        this.scheme = scheme;
        return this;
    }

    public DelayDTO getDelay() {
        return this.delay;
    }

    public void setDelay(DelayDTO delay) {
        this.delay = delay;
    }
}

