/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.openapi.examples.models;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.mockserver.openapi.examples.JsonExampleDeserializer;
import org.mockserver.openapi.examples.models.AbstractExample;
import org.mockserver.openapi.examples.models.Example;

@JsonDeserialize(using=JsonExampleDeserializer.class)
public class ObjectExample
extends AbstractExample {
    private Map<String, Example> values;

    public ObjectExample() {
        super.setTypeName("object");
    }

    public void put(String key, Example value) {
        if (this.values == null) {
            this.values = new LinkedHashMap<String, Example>();
        }
        this.values.put(key, value);
    }

    public void putAll(Map<String, Example> values) {
        for (String key : values.keySet()) {
            this.put(key, values.get(key));
        }
    }

    public Set<String> keySet() {
        if (this.values == null) {
            return new HashSet<String>();
        }
        return this.values.keySet();
    }

    public Object get(String key) {
        if (this.values != null) {
            return this.values.get(key);
        }
        return null;
    }

    @Override
    public String asString() {
        if (this.values == null) {
            return null;
        }
        return "NOT IMPLEMENTED";
    }

    public Map<String, Example> getValues() {
        return this.values;
    }

    public void setValues(Map<String, Example> values) {
        this.values = values;
    }
}

