/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mock.action.http;

import org.mockserver.httpclient.NettyHttpClient;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.action.http.HttpForwardAction;
import org.mockserver.mock.action.http.HttpForwardActionResult;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpTemplate;
import org.mockserver.serialization.model.HttpRequestDTO;
import org.mockserver.templates.engine.TemplateEngine;
import org.mockserver.templates.engine.javascript.JavaScriptTemplateEngine;
import org.mockserver.templates.engine.mustache.MustacheTemplateEngine;
import org.mockserver.templates.engine.velocity.VelocityTemplateEngine;

public class HttpForwardTemplateActionHandler
extends HttpForwardAction {
    private VelocityTemplateEngine velocityTemplateEngine;
    private JavaScriptTemplateEngine javaScriptTemplateEngine;
    private MustacheTemplateEngine mustacheTemplateEngine;

    public HttpForwardTemplateActionHandler(MockServerLogger mockServerLogger, NettyHttpClient httpClient) {
        super(mockServerLogger, httpClient);
    }

    public HttpForwardActionResult handle(HttpTemplate httpTemplate, HttpRequest originalRequest) {
        HttpRequest templatedRequest;
        TemplateEngine templateEngine;
        switch (httpTemplate.getTemplateType()) {
            case VELOCITY: {
                templateEngine = this.getVelocityTemplateEngine();
                break;
            }
            case JAVASCRIPT: {
                templateEngine = this.getJavaScriptTemplateEngine();
                break;
            }
            case MUSTACHE: {
                templateEngine = this.getMustacheTemplateEngine();
                break;
            }
            default: {
                throw new RuntimeException("Unknown no template engine available for " + (Object)((Object)httpTemplate.getTemplateType()));
            }
        }
        if (templateEngine != null && (templatedRequest = (HttpRequest)templateEngine.executeTemplate(httpTemplate.getTemplate(), originalRequest, HttpRequestDTO.class)) != null) {
            return this.sendRequest(templatedRequest, null, null);
        }
        return this.notFoundFuture(originalRequest);
    }

    private VelocityTemplateEngine getVelocityTemplateEngine() {
        if (this.velocityTemplateEngine == null) {
            this.velocityTemplateEngine = new VelocityTemplateEngine(this.mockServerLogger);
        }
        return this.velocityTemplateEngine;
    }

    private JavaScriptTemplateEngine getJavaScriptTemplateEngine() {
        if (this.javaScriptTemplateEngine == null) {
            this.javaScriptTemplateEngine = new JavaScriptTemplateEngine(this.mockServerLogger);
        }
        return this.javaScriptTemplateEngine;
    }

    private MustacheTemplateEngine getMustacheTemplateEngine() {
        if (this.mustacheTemplateEngine == null) {
            this.mustacheTemplateEngine = new MustacheTemplateEngine(this.mockServerLogger);
        }
        return this.mustacheTemplateEngine;
    }
}

