/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mappers;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringEncoder;
import io.netty.handler.codec.http.cookie.ClientCookieEncoder;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.codec.BodyDecoderEncoder;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.Cookie;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.NottableString;
import org.mockserver.model.Parameter;
import org.mockserver.proxyconfiguration.ProxyConfiguration;
import org.slf4j.event.Level;

public class MockServerHttpRequestToFullHttpRequest {
    private final MockServerLogger mockServerLogger;
    private final Map<ProxyConfiguration.Type, ProxyConfiguration> proxyConfigurations;
    private final BodyDecoderEncoder bodyDecoderEncoder;

    public MockServerHttpRequestToFullHttpRequest(MockServerLogger mockServerLogger, Map<ProxyConfiguration.Type, ProxyConfiguration> proxyConfigurations) {
        this.mockServerLogger = mockServerLogger;
        this.proxyConfigurations = proxyConfigurations;
        this.bodyDecoderEncoder = new BodyDecoderEncoder();
    }

    public FullHttpRequest mapMockServerRequestToNettyRequest(HttpRequest httpRequest) {
        HttpMethod httpMethod = HttpMethod.valueOf((String)httpRequest.getMethod("GET"));
        try {
            DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, httpMethod, this.getURI(httpRequest, this.proxyConfigurations), this.getBody(httpRequest));
            this.setHeader(httpRequest, (FullHttpRequest)request);
            this.setCookies(httpRequest, (FullHttpRequest)request);
            return request;
        }
        catch (Throwable throwable) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception encoding request{}").setArguments(httpRequest).setThrowable(throwable));
            return new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, httpMethod, this.getURI(httpRequest, this.proxyConfigurations));
        }
    }

    public String getURI(HttpRequest httpRequest, Map<ProxyConfiguration.Type, ProxyConfiguration> proxyConfigurations) {
        String uri = "";
        if (httpRequest.getPath() != null) {
            if (httpRequest.getQueryStringParameters() != null && StringUtils.isNotBlank((CharSequence)httpRequest.getQueryStringParameters().getRawParameterString())) {
                uri = httpRequest.getPath().getValue() + "?" + httpRequest.getQueryStringParameters().getRawParameterString();
            } else {
                QueryStringEncoder queryStringEncoder = new QueryStringEncoder(httpRequest.getPath().getValue());
                for (Parameter parameter : httpRequest.getQueryStringParameterList()) {
                    for (NottableString value : parameter.getValues()) {
                        queryStringEncoder.addParam(parameter.getName().getValue(), value.getValue());
                    }
                }
                uri = queryStringEncoder.toString();
            }
        }
        if (proxyConfigurations != null && proxyConfigurations.get((Object)ProxyConfiguration.Type.HTTP) != null && !Boolean.TRUE.equals(httpRequest.isSecure())) {
            if (StringUtils.isNotBlank((CharSequence)httpRequest.getFirstHeader(HttpHeaderNames.HOST.toString()))) {
                uri = "http://" + httpRequest.getFirstHeader(HttpHeaderNames.HOST.toString()) + uri;
            } else if (httpRequest.getRemoteAddress() != null) {
                uri = "http://" + httpRequest.getRemoteAddress() + uri;
            }
        }
        return uri;
    }

    private ByteBuf getBody(HttpRequest httpRequest) {
        return this.bodyDecoderEncoder.bodyToByteBuf(httpRequest.getBody(), httpRequest.getFirstHeader(HttpHeaderNames.CONTENT_TYPE.toString()));
    }

    private void setCookies(HttpRequest httpRequest, FullHttpRequest request) {
        if (!httpRequest.getCookieList().isEmpty()) {
            ArrayList<DefaultCookie> cookies = new ArrayList<DefaultCookie>();
            for (Cookie cookie : httpRequest.getCookieList()) {
                cookies.add(new DefaultCookie(cookie.getName().getValue(), cookie.getValue().getValue()));
            }
            request.headers().set(HttpHeaderNames.COOKIE.toString(), (Object)ClientCookieEncoder.LAX.encode(cookies));
        }
    }

    private void setHeader(HttpRequest httpRequest, FullHttpRequest request) {
        for (Header header : httpRequest.getHeaderList()) {
            String headerName = header.getName().getValue();
            if (headerName.equalsIgnoreCase(HttpHeaderNames.CONTENT_LENGTH.toString()) || headerName.equalsIgnoreCase(HttpHeaderNames.TRANSFER_ENCODING.toString()) || headerName.equalsIgnoreCase(HttpHeaderNames.HOST.toString()) || headerName.equalsIgnoreCase(HttpHeaderNames.ACCEPT_ENCODING.toString())) continue;
            if (!header.getValues().isEmpty()) {
                for (NottableString headerValue : header.getValues()) {
                    request.headers().add(headerName, (Object)headerValue.getValue());
                }
                continue;
            }
            request.headers().add(headerName, (Object)"");
        }
        if (StringUtils.isNotBlank((CharSequence)httpRequest.getFirstHeader(HttpHeaderNames.HOST.toString()))) {
            request.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)httpRequest.getFirstHeader(HttpHeaderNames.HOST.toString()));
        }
        request.headers().set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)(HttpHeaderValues.GZIP + "," + HttpHeaderValues.DEFLATE));
        request.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)request.content().readableBytes());
        if (HttpUtil.isKeepAlive((HttpMessage)request)) {
            request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        } else {
            request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        }
        if (!request.headers().contains((CharSequence)HttpHeaderNames.CONTENT_TYPE) && httpRequest.getBody() != null && httpRequest.getBody().getContentType() != null) {
            request.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)httpRequest.getBody().getContentType());
        }
    }
}

