/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.socket.tls.jdk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CertificateSigningRequest {
    public static final String DEFAULT_SIGNING_ALGORITHM = "SHA256withRSA";
    public static final String DEFAULT_KEY_GENERATION_ALGORITHM = "RSA";
    public static final int DEFAULT_KEY_PAIR_LENGTH = 2048;
    public static final int DEFAULT_VALIDITY = 90;
    public static final int ROOT_KEY_SIZE = 2048;
    public static final int MOCK_KEY_SIZE = 2048;
    public static final Date NOT_BEFORE = new Date(System.currentTimeMillis() - 31536000000L);
    public static final Date NOT_AFTER = new Date(System.currentTimeMillis() + 3153600000000L);
    public static final String ROOT_COMMON_NAME = "www.mockserver.com";
    public static final String ORGANISATION = "MockServer";
    public static final String LOCALITY = "London";
    public static final String STATE = "England";
    public static final String COUNTRY = "UK";
    public static final String CERTIFICATE_DOMAIN = "localhost";
    private String commonName;
    private int keyPairSize;
    private List<String> subjectAlternativeNames;
    private String signingAlgorithm = "SHA256withRSA";
    private String keyPairAlgorithm = "RSA";
    private Long validityInMillis = TimeUnit.DAYS.toMillis(90L);

    public static String buildDistinguishedName(String commonName) {
        return String.format("C=%s, ST=%s, L=%s, O=%s, CN=%s", COUNTRY, STATE, LOCALITY, ORGANISATION, commonName);
    }

    public String getCommonName() {
        return this.commonName;
    }

    public CertificateSigningRequest setCommonName(String commonName) {
        this.commonName = commonName;
        return this;
    }

    public int getKeyPairSize() {
        return this.keyPairSize;
    }

    public CertificateSigningRequest setKeyPairSize(int keyPairSize) {
        this.keyPairSize = keyPairSize;
        return this;
    }

    public List<String> getSubjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public CertificateSigningRequest addSubjectAlternativeNames(String ... subjectAlternativeNames) {
        if (this.subjectAlternativeNames == null) {
            this.subjectAlternativeNames = new ArrayList<String>();
        }
        this.subjectAlternativeNames.addAll(Arrays.asList(subjectAlternativeNames));
        return this;
    }

    public String getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public CertificateSigningRequest setSigningAlgorithm(String signingAlgorithm) {
        this.signingAlgorithm = signingAlgorithm;
        return this;
    }

    public String getKeyPairAlgorithm() {
        return this.keyPairAlgorithm;
    }

    public CertificateSigningRequest setKeyPairAlgorithm(String keyPairAlgorithm) {
        this.keyPairAlgorithm = keyPairAlgorithm;
        return this;
    }

    public Long getValidityInMillis() {
        return this.validityInMillis;
    }

    public CertificateSigningRequest setValidityInMillis(Long validityInMillis) {
        this.validityInMillis = validityInMillis;
        return this;
    }
}

