/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.deserializers.body;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Body;
import org.mockserver.model.JsonBody;
import org.mockserver.model.MediaType;
import org.mockserver.model.StringBody;
import org.mockserver.model.XmlBody;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.model.BinaryBodyDTO;
import org.mockserver.serialization.model.BodyWithContentTypeDTO;
import org.mockserver.serialization.model.JsonBodyDTO;
import org.mockserver.serialization.model.StringBodyDTO;
import org.mockserver.serialization.model.XmlBodyDTO;
import org.slf4j.event.Level;

public class BodyWithContentTypeDTODeserializer
extends StdDeserializer<BodyWithContentTypeDTO> {
    private static final Map<String, Body.Type> fieldNameToType = new HashMap<String, Body.Type>();
    private static final Base64.Decoder BASE64_DECODER = Base64.getDecoder();
    private static ObjectMapper objectMapper;
    private static ObjectMapper jsonBodyObjectMapper;
    private static final MockServerLogger MOCK_SERVER_LOGGER;

    public BodyWithContentTypeDTODeserializer() {
        super(BodyWithContentTypeDTO.class);
    }

    public BodyWithContentTypeDTO deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
        JsonToken currentToken = jsonParser.getCurrentToken();
        String valueJsonValue = "";
        byte[] rawBytes = null;
        Enum type = null;
        boolean not = false;
        MediaType contentType = null;
        Charset charset = null;
        if (currentToken == JsonToken.START_OBJECT) {
            Map body = (Map)ctxt.readValue(jsonParser, Map.class);
            for (Map.Entry entry : body.entrySet()) {
                if (!(entry.getKey() instanceof String)) continue;
                String key = (String)entry.getKey();
                if (key.equalsIgnoreCase("type")) {
                    try {
                        type = Body.Type.valueOf(String.valueOf(entry.getValue()));
                    }
                    catch (IllegalArgumentException iae) {
                        MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("ignoring invalid value for \"type\" field of \"" + entry.getValue() + "\""));
                    }
                }
                if (this.containsIgnoreCase(key, "string", "regex", "json", "jsonSchema", "jsonPath", "xml", "xmlSchema", "xpath", "base64Bytes") && type != Body.Type.PARAMETERS) {
                    String fieldName = String.valueOf(entry.getKey()).toLowerCase();
                    if (fieldNameToType.containsKey(fieldName)) {
                        type = fieldNameToType.get(fieldName);
                    }
                    if (Map.class.isAssignableFrom(entry.getValue().getClass()) || this.containsIgnoreCase(key, "json", "jsonSchema") && !String.class.isAssignableFrom(entry.getValue().getClass())) {
                        if (objectMapper == null) {
                            objectMapper = ObjectMapperFactory.createObjectMapper(new JsonSerializer[0]);
                        }
                        valueJsonValue = objectMapper.writeValueAsString(entry.getValue());
                    } else {
                        valueJsonValue = String.valueOf(entry.getValue());
                    }
                }
                if (this.containsIgnoreCase(key, "rawBytes", "base64Bytes") && entry.getValue() instanceof String) {
                    try {
                        rawBytes = BASE64_DECODER.decode((String)entry.getValue());
                    }
                    catch (Throwable throwable) {
                        MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("invalid base64 encoded rawBytes with value \"" + entry.getValue() + "\""));
                    }
                }
                if (key.equalsIgnoreCase("not")) {
                    not = Boolean.parseBoolean(String.valueOf(entry.getValue()));
                }
                if (key.equalsIgnoreCase("contentType")) {
                    try {
                        String mediaTypeHeader = String.valueOf(entry.getValue());
                        if (StringUtils.isNotBlank((CharSequence)mediaTypeHeader)) {
                            contentType = MediaType.parse(mediaTypeHeader);
                        }
                    }
                    catch (IllegalArgumentException uce) {
                        MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("ignoring unsupported MediaType with value \"" + entry.getValue() + "\""));
                    }
                }
                if (!key.equalsIgnoreCase("charset")) continue;
                try {
                    charset = Charset.forName(String.valueOf(entry.getValue()));
                }
                catch (UnsupportedCharsetException uce) {
                    MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("ignoring unsupported Charset with value \"" + entry.getValue() + "\""));
                }
                catch (IllegalCharsetNameException icne) {
                    MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("ignoring invalid Charset with value \"" + entry.getValue() + "\""));
                }
            }
            if (type != null) {
                switch (1.$SwitchMap$org$mockserver$model$Body$Type[type.ordinal()]) {
                    case 1: {
                        if (contentType != null) {
                            return new BinaryBodyDTO(new BinaryBody(rawBytes, contentType), (Boolean)not);
                        }
                        return new BinaryBodyDTO(new BinaryBody(rawBytes), (Boolean)not);
                    }
                    case 2: {
                        if (contentType != null) {
                            return new JsonBodyDTO(new JsonBody(valueJsonValue, rawBytes, contentType, JsonBody.DEFAULT_MATCH_TYPE), (Boolean)not);
                        }
                        if (charset != null) {
                            return new JsonBodyDTO(new JsonBody(valueJsonValue, rawBytes, JsonBody.DEFAULT_CONTENT_TYPE.withCharset(charset), JsonBody.DEFAULT_MATCH_TYPE), (Boolean)not);
                        }
                        return new JsonBodyDTO(new JsonBody(valueJsonValue, rawBytes, JsonBody.DEFAULT_CONTENT_TYPE, JsonBody.DEFAULT_MATCH_TYPE), (Boolean)not);
                    }
                    case 3: {
                        if (contentType != null) {
                            return new StringBodyDTO(new StringBody(valueJsonValue, rawBytes, false, contentType), (Boolean)not);
                        }
                        if (charset != null) {
                            return new StringBodyDTO(new StringBody(valueJsonValue, rawBytes, false, StringBody.DEFAULT_CONTENT_TYPE.withCharset(charset)), (Boolean)not);
                        }
                        return new StringBodyDTO(new StringBody(valueJsonValue, rawBytes, false, null), (Boolean)not);
                    }
                    case 4: {
                        if (contentType != null) {
                            return new XmlBodyDTO(new XmlBody(valueJsonValue, rawBytes, contentType), (Boolean)not);
                        }
                        if (charset != null) {
                            return new XmlBodyDTO(new XmlBody(valueJsonValue, rawBytes, XmlBody.DEFAULT_CONTENT_TYPE.withCharset(charset)), (Boolean)not);
                        }
                        return new XmlBodyDTO(new XmlBody(valueJsonValue, rawBytes, XmlBody.DEFAULT_CONTENT_TYPE), (Boolean)not);
                    }
                }
            } else if (body.size() > 0) {
                if (jsonBodyObjectMapper == null) {
                    jsonBodyObjectMapper = new ObjectMapper();
                }
                return new JsonBodyDTO(new JsonBody(jsonBodyObjectMapper.writeValueAsString((Object)body), JsonBody.DEFAULT_MATCH_TYPE), (Boolean)false);
            }
        } else {
            if (currentToken == JsonToken.START_ARRAY) {
                if (jsonBodyObjectMapper == null) {
                    jsonBodyObjectMapper = new ObjectMapper();
                }
                return new JsonBodyDTO(new JsonBody(jsonBodyObjectMapper.writeValueAsString(ctxt.readValue(jsonParser, List.class)), JsonBody.DEFAULT_MATCH_TYPE), (Boolean)false);
            }
            if (currentToken == JsonToken.VALUE_STRING) {
                return new StringBodyDTO(new StringBody(jsonParser.getText()));
            }
        }
        return null;
    }

    private boolean containsIgnoreCase(String valueToMatch, String ... listOfValues) {
        for (String item : listOfValues) {
            if (!item.equalsIgnoreCase(valueToMatch)) continue;
            return true;
        }
        return false;
    }

    static {
        fieldNameToType.put("base64Bytes".toLowerCase(), Body.Type.BINARY);
        fieldNameToType.put("json".toLowerCase(), Body.Type.JSON);
        fieldNameToType.put("parameters".toLowerCase(), Body.Type.PARAMETERS);
        fieldNameToType.put("string".toLowerCase(), Body.Type.STRING);
        fieldNameToType.put("xml".toLowerCase(), Body.Type.XML);
        MOCK_SERVER_LOGGER = new MockServerLogger(BodyWithContentTypeDTODeserializer.class);
    }
}

