/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.model;

import java.nio.charset.Charset;
import org.mockserver.model.Body;
import org.mockserver.model.BodyWithContentType;
import org.mockserver.model.MediaType;

public class XmlBody
extends BodyWithContentType<String> {
    public static final MediaType DEFAULT_CONTENT_TYPE = MediaType.create("application", "xml");
    private final String xml;
    private final byte[] rawBytes;

    public XmlBody(String xml) {
        this(xml, DEFAULT_CONTENT_TYPE);
    }

    public XmlBody(String xml, Charset charset) {
        this(xml, null, charset != null ? DEFAULT_CONTENT_TYPE.withCharset(charset) : null);
    }

    public XmlBody(String xml, MediaType contentType) {
        this(xml, null, contentType);
    }

    public XmlBody(String xml, byte[] rawBytes, MediaType contentType) {
        super(Body.Type.XML, contentType);
        this.xml = xml;
        this.rawBytes = rawBytes == null && xml != null ? xml.getBytes(this.determineCharacterSet(contentType, MediaType.DEFAULT_HTTP_CHARACTER_SET)) : rawBytes;
    }

    public static XmlBody xml(String xml) {
        return new XmlBody(xml);
    }

    public static XmlBody xml(String xml, Charset charset) {
        return new XmlBody(xml, charset);
    }

    public static XmlBody xml(String xml, MediaType contentType) {
        return new XmlBody(xml, contentType);
    }

    @Override
    public String getValue() {
        return this.xml;
    }

    @Override
    public byte[] getRawBytes() {
        return this.rawBytes;
    }

    @Override
    public String toString() {
        return this.xml;
    }
}

