/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import net.javacrumbs.jsonunit.core.Configuration;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.core.internal.Diff;
import net.javacrumbs.jsonunit.core.internal.Options;
import net.javacrumbs.jsonunit.core.listener.DifferenceContext;
import net.javacrumbs.jsonunit.core.listener.DifferenceListener;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.character.Character;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.MatchDifference;
import org.mockserver.matchers.MatchType;
import org.mockserver.serialization.ObjectMapperFactory;
import org.slf4j.event.Level;

public class JsonStringMatcher
extends BodyMatcher<String> {
    private static final String[] EXCLUDED_FIELDS = new String[]{"mockServerLogger"};
    private static final ObjectWriter PRETTY_PRINTER = ObjectMapperFactory.createObjectMapper(new JsonSerializer[0]).writerWithDefaultPrettyPrinter();
    private final MockServerLogger mockServerLogger;
    private final String matcher;
    private JsonNode matcherJsonNode;
    private final MatchType matchType;

    JsonStringMatcher(MockServerLogger mockServerLogger, String matcher, MatchType matchType) {
        this.mockServerLogger = mockServerLogger;
        this.matcher = matcher;
        this.matchType = matchType;
    }

    @Override
    public boolean matches(MatchDifference context, String matched) {
        boolean result;
        block13: {
            result = false;
            try {
                if (StringUtils.isBlank((CharSequence)this.matcher)) {
                    result = true;
                    break block13;
                }
                Options options = Options.empty();
                switch (this.matchType) {
                    case STRICT: {
                        break;
                    }
                    case ONLY_MATCHING_FIELDS: {
                        options = options.with(Option.IGNORING_ARRAY_ORDER, new Option[]{Option.IGNORING_EXTRA_ARRAY_ITEMS, Option.IGNORING_EXTRA_FIELDS});
                    }
                }
                Difference diffListener = new Difference();
                Configuration diffConfig = Configuration.empty().withDifferenceListener((DifferenceListener)diffListener).withOptions(options);
                try {
                    if (this.matcherJsonNode == null) {
                        this.matcherJsonNode = ObjectMapperFactory.createObjectMapper(new JsonSerializer[0]).readTree(this.matcher);
                    }
                    result = Diff.create((Object)this.matcherJsonNode, (Object)ObjectMapperFactory.createObjectMapper(new JsonSerializer[0]).readTree(matched), (String)"", (String)"", (Configuration)diffConfig).similar();
                }
                catch (Throwable throwable) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMatchDifference(context).setMessageFormat("exception while perform json  match failed expected:{}found:{}").setArguments(this.matcher, matched).setThrowable(throwable));
                }
                if (!result) {
                    if (diffListener.differences.isEmpty()) {
                        this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMatchDifference(context).setMessageFormat("json match failed expected:{}found:{}").setArguments(this.matcher, matched));
                    } else {
                        this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMatchDifference(context).setMessageFormat("json match failed expected:{}found:{}failed because:{}").setArguments(this.matcher, matched, Joiner.on((String)("," + Character.NEW_LINE)).join(diffListener.differences)));
                    }
                }
            }
            catch (Exception e) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMatchDifference(context).setMessageFormat("json match failed expected:{}found:{}failed because:{}").setArguments(this.matcher, matched, e.getMessage()).setThrowable(e));
            }
        }
        return this.not != result;
    }

    @Override
    public boolean isBlank() {
        return StringUtils.isBlank((CharSequence)this.matcher);
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }

    private static class Difference
    implements DifferenceListener {
        public List<String> differences = new ArrayList<String>();

        private Difference() {
        }

        public void diff(net.javacrumbs.jsonunit.core.listener.Difference difference, DifferenceContext context) {
            switch (difference.getType()) {
                case EXTRA: {
                    this.differences.add("additional element at \"" + difference.getActualPath() + "\" with value: " + this.prettyPrint(difference.getActual()));
                    break;
                }
                case MISSING: {
                    this.differences.add("missing element at \"" + difference.getActualPath() + "\"");
                    break;
                }
                case DIFFERENT: {
                    this.differences.add("wrong value at \"" + difference.getActualPath() + "\", expected: " + this.prettyPrint(difference.getExpected()) + " but was: " + this.prettyPrint(difference.getActual()));
                }
            }
        }

        private String prettyPrint(Object value) {
            try {
                return PRETTY_PRINTER.writeValueAsString(value);
            }
            catch (JsonProcessingException e) {
                return String.valueOf(value);
            }
        }
    }
}

