/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import org.mockserver.collections.CaseInsensitiveRegexHashMap;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.MatchDifference;
import org.mockserver.matchers.NotMatcher;
import org.mockserver.model.KeysAndValues;
import org.slf4j.event.Level;

public class HashMapMatcher
extends NotMatcher<KeysAndValues> {
    private final MockServerLogger mockServerLogger;
    private final KeysAndValues keysAndValues;
    private final boolean controlPlaneMatcher;
    private final CaseInsensitiveRegexHashMap matcher;

    HashMapMatcher(MockServerLogger mockServerLogger, KeysAndValues keysAndValues, boolean controlPlaneMatcher) {
        this.mockServerLogger = mockServerLogger;
        this.keysAndValues = keysAndValues;
        this.controlPlaneMatcher = controlPlaneMatcher;
        this.matcher = keysAndValues != null ? keysAndValues.toCaseInsensitiveRegexMultiMap(mockServerLogger, controlPlaneMatcher) : null;
    }

    @Override
    public boolean matches(MatchDifference context, KeysAndValues values) {
        boolean result;
        if (this.matcher == null || this.matcher.isEmpty()) {
            result = true;
        } else if (values == null || values.isEmpty()) {
            result = this.matcher.allKeysNotted();
        } else if (values.toCaseInsensitiveRegexMultiMap(this.mockServerLogger, this.controlPlaneMatcher).containsAll(this.matcher)) {
            result = true;
        } else {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMatchDifference(context).setMessageFormat("map subset match failed expected:{}found:{}failed because:{}").setArguments(this.keysAndValues, values, "map is not a subset"));
            result = false;
        }
        return this.not != result;
    }

    @Override
    public boolean isBlank() {
        return this.matcher == null || this.matcher.isEmpty();
    }
}

