/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.mockserver.client.HttpClientInitializer;
import org.mockserver.client.SocketCommunicationException;
import org.mockserver.client.SocketConnectionException;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.proxyconfiguration.ProxyConfiguration;
import org.mockserver.socket.tls.NettySslContextFactory;

public class NettyHttpClient {
    static final AttributeKey<Boolean> SECURE = AttributeKey.valueOf((String)"SECURE");
    static final AttributeKey<InetSocketAddress> REMOTE_SOCKET = AttributeKey.valueOf((String)"REMOTE_SOCKET");
    static final AttributeKey<CompletableFuture<HttpResponse>> RESPONSE_FUTURE = AttributeKey.valueOf((String)"RESPONSE_FUTURE");
    private final MockServerLogger mockServerLogger;
    private final EventLoopGroup eventLoopGroup;
    private final ProxyConfiguration proxyConfiguration;
    private final boolean forwardProxyClient;
    private final NettySslContextFactory nettySslContextFactory;

    public NettyHttpClient(MockServerLogger mockServerLogger, EventLoopGroup eventLoopGroup, ProxyConfiguration proxyConfiguration, boolean forwardProxyClient) {
        this(mockServerLogger, eventLoopGroup, proxyConfiguration, forwardProxyClient, new NettySslContextFactory(mockServerLogger));
    }

    public NettyHttpClient(MockServerLogger mockServerLogger, EventLoopGroup eventLoopGroup, ProxyConfiguration proxyConfiguration, boolean forwardProxyClient, NettySslContextFactory nettySslContextFactory) {
        this.mockServerLogger = mockServerLogger;
        this.eventLoopGroup = eventLoopGroup;
        this.proxyConfiguration = proxyConfiguration;
        this.forwardProxyClient = forwardProxyClient;
        this.nettySslContextFactory = nettySslContextFactory;
    }

    public CompletableFuture<HttpResponse> sendRequest(HttpRequest httpRequest) throws SocketConnectionException {
        return this.sendRequest(httpRequest, httpRequest.socketAddressFromHostHeader());
    }

    public CompletableFuture<HttpResponse> sendRequest(HttpRequest httpRequest, @Nullable InetSocketAddress remoteAddress) throws SocketConnectionException {
        return this.sendRequest(httpRequest, remoteAddress, ConfigurationProperties.socketConnectionTimeout());
    }

    public CompletableFuture<HttpResponse> sendRequest(HttpRequest httpRequest, @Nullable InetSocketAddress remoteAddress, Integer connectionTimeoutMillis) throws SocketConnectionException {
        if (!this.eventLoopGroup.isShuttingDown()) {
            if (this.proxyConfiguration != null && this.proxyConfiguration.getType() == ProxyConfiguration.Type.HTTP) {
                remoteAddress = this.proxyConfiguration.getProxyAddress();
            } else if (remoteAddress == null) {
                remoteAddress = httpRequest.socketAddressFromHostHeader();
            }
            CompletableFuture<HttpResponse> httpResponseFuture = new CompletableFuture<HttpResponse>();
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.AUTO_READ, (Object)true)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(8192, 32768))).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectionTimeoutMillis)).attr(SECURE, (Object)(httpRequest.isSecure() != null && httpRequest.isSecure() != false ? 1 : 0))).attr(REMOTE_SOCKET, (Object)remoteAddress)).attr(RESPONSE_FUTURE, httpResponseFuture)).handler((ChannelHandler)new HttpClientInitializer(this.proxyConfiguration, this.mockServerLogger, this.forwardProxyClient, this.nettySslContextFactory))).connect((SocketAddress)remoteAddress).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (future.isSuccess()) {
                    future.channel().writeAndFlush((Object)httpRequest);
                } else {
                    httpResponseFuture.completeExceptionally(future.cause());
                }
            }));
            return httpResponseFuture;
        }
        throw new IllegalStateException("Request sent after client has been stopped - the event loop has been shutdown so it is not possible to send a request");
    }

    public HttpResponse sendRequest(HttpRequest httpRequest, long timeout, TimeUnit unit) {
        try {
            return this.sendRequest(httpRequest).get(timeout, unit);
        }
        catch (TimeoutException e) {
            throw new SocketCommunicationException("Response was not received from MockServer after " + ConfigurationProperties.maxSocketTimeout() + " milliseconds, to wait longer please use \"mockserver.maxSocketTimeout\" system property or ConfigurationProperties.maxSocketTimeout(long milliseconds)", e.getCause());
        }
        catch (InterruptedException | ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof SocketConnectionException) {
                throw (SocketConnectionException)cause;
            }
            if (cause instanceof ConnectException) {
                throw new SocketConnectionException("Unable to connect to socket " + httpRequest.socketAddressFromHostHeader(), cause);
            }
            if (cause instanceof UnknownHostException) {
                throw new SocketConnectionException("Unable to resolve host " + httpRequest.socketAddressFromHostHeader(), cause);
            }
            if (cause instanceof IOException) {
                throw new SocketConnectionException(cause.getMessage(), cause);
            }
            throw new RuntimeException("Exception while sending request - " + ex.getMessage(), ex);
        }
    }
}

