/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.startup;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletContextEvent;
import javax.servlet.sip.SipServletListener;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipSessionsUtil;
import javax.servlet.sip.TimerService;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Service;
import org.apache.catalina.Valve;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.deploy.NamingResourcesImpl;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.util.ExtensionValidator;
import org.apache.catalina.webresources.StandardRoot;
import org.apache.log4j.Logger;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.util.descriptor.web.ContextLocalEjb;
import org.apache.tomcat.util.descriptor.web.Injectable;
import org.apache.tomcat.util.descriptor.web.InjectionTarget;
import org.apache.tomcat.util.descriptor.web.LoginConfig;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;
import org.mobicents.servlet.sip.SipConnector;
import org.mobicents.servlet.sip.annotation.ConcurrencyControlMode;
import org.mobicents.servlet.sip.annotations.DefaultSipInstanceManager;
import org.mobicents.servlet.sip.catalina.CatalinaSipContext;
import org.mobicents.servlet.sip.catalina.CatalinaSipListenersHolder;
import org.mobicents.servlet.sip.catalina.CatalinaSipManager;
import org.mobicents.servlet.sip.catalina.ContextGracefulStopTask;
import org.mobicents.servlet.sip.catalina.SipSecurityConstraint;
import org.mobicents.servlet.sip.catalina.SipServletImpl;
import org.mobicents.servlet.sip.catalina.SipStandardManager;
import org.mobicents.servlet.sip.catalina.annotations.SipInstanceManager;
import org.mobicents.servlet.sip.catalina.security.SipSecurityUtils;
import org.mobicents.servlet.sip.catalina.security.authentication.DigestAuthenticator;
import org.mobicents.servlet.sip.core.MobicentsSipServlet;
import org.mobicents.servlet.sip.core.SipApplicationDispatcher;
import org.mobicents.servlet.sip.core.SipContext;
import org.mobicents.servlet.sip.core.SipContextEvent;
import org.mobicents.servlet.sip.core.SipContextEventType;
import org.mobicents.servlet.sip.core.SipListeners;
import org.mobicents.servlet.sip.core.SipManager;
import org.mobicents.servlet.sip.core.SipService;
import org.mobicents.servlet.sip.core.descriptor.MobicentsSipServletMapping;
import org.mobicents.servlet.sip.core.message.MobicentsSipServletRequest;
import org.mobicents.servlet.sip.core.message.MobicentsSipServletResponse;
import org.mobicents.servlet.sip.core.security.MobicentsSipLoginConfig;
import org.mobicents.servlet.sip.core.security.SipDigestAuthenticator;
import org.mobicents.servlet.sip.core.session.DistributableSipManager;
import org.mobicents.servlet.sip.core.session.MobicentsSipApplicationSession;
import org.mobicents.servlet.sip.core.session.MobicentsSipSession;
import org.mobicents.servlet.sip.core.session.SipApplicationSessionCreationThreadLocal;
import org.mobicents.servlet.sip.core.session.SipSessionsUtilImpl;
import org.mobicents.servlet.sip.core.timers.DefaultProxyTimerService;
import org.mobicents.servlet.sip.core.timers.DefaultSipApplicationSessionTimerService;
import org.mobicents.servlet.sip.core.timers.ProxyTimerService;
import org.mobicents.servlet.sip.core.timers.ProxyTimerServiceImpl;
import org.mobicents.servlet.sip.core.timers.SipApplicationSessionTimerService;
import org.mobicents.servlet.sip.core.timers.SipServletTimerService;
import org.mobicents.servlet.sip.core.timers.StandardSipApplicationSessionTimerService;
import org.mobicents.servlet.sip.core.timers.TimerServiceImpl;
import org.mobicents.servlet.sip.listener.SipConnectorListener;
import org.mobicents.servlet.sip.message.SipFactoryFacade;
import org.mobicents.servlet.sip.message.SipFactoryImpl;
import org.mobicents.servlet.sip.ruby.SipRubyController;
import org.mobicents.servlet.sip.startup.ConvergedApplicationContext;
import org.mobicents.servlet.sip.startup.SipNamingContextListener;
import org.mobicents.servlet.sip.startup.SipStandardContextValve;

public class SipStandardContext
extends StandardContext
implements CatalinaSipContext {
    private static final long serialVersionUID = 1L;
    private static final transient Logger logger = Logger.getLogger(SipStandardContext.class);
    private static final String info = "org.mobicents.servlet.sip.startup.SipStandardContext/1.0";
    private static int DEFAULT_LIFETIME = 3;
    protected String applicationName;
    protected String smallIcon;
    protected String largeIcon;
    protected String description;
    protected int proxyTimeout;
    protected int sipApplicationSessionTimeout;
    protected transient SipListeners sipListeners;
    protected transient SipFactoryFacade sipFactoryFacade;
    protected transient SipSessionsUtilImpl sipSessionsUtil;
    protected transient MobicentsSipLoginConfig sipLoginConfig;
    protected transient SipSecurityUtils sipSecurityUtils;
    protected transient SipDigestAuthenticator sipDigestAuthenticator;
    protected boolean hasDistributableManager;
    protected String namingContextName;
    protected transient Method sipApplicationKeyMethod;
    protected ConcurrencyControlMode concurrencyControlMode;
    protected transient List<String> sipApplicationListeners = new CopyOnWriteArrayList<String>();
    private String servletHandler;
    private boolean isMainServlet;
    private String mainServlet;
    protected transient List<MobicentsSipServletMapping> sipServletMappings = new ArrayList<MobicentsSipServletMapping>();
    protected transient SipApplicationDispatcher sipApplicationDispatcher = null;
    protected transient Map<String, MobicentsSipServlet> childrenMap;
    protected transient Map<String, MobicentsSipServlet> childrenMapByClassName;
    protected boolean sipJNDIContextLoaded = false;
    protected transient SipApplicationSessionTimerService sasTimerService = null;
    protected transient SipServletTimerService timerService = null;
    protected transient ProxyTimerService proxyTimerService = null;
    private transient ThreadLocal<SipApplicationSessionCreationThreadLocal> sipApplicationSessionsAccessedThreadLocal = new ThreadLocal();
    private transient ThreadLocal<Boolean> isManagedThread = new ThreadLocal();
    private ScheduledFuture<?> gracefulStopFuture;

    public SipStandardContext() {
        this.sipApplicationSessionTimeout = DEFAULT_LIFETIME;
        this.pipeline.setBasic((Valve)new SipStandardContextValve());
        this.sipListeners = new CatalinaSipListenersHolder((SipContext)this);
        this.childrenMap = new HashMap<String, MobicentsSipServlet>();
        this.childrenMapByClassName = new HashMap<String, MobicentsSipServlet>();
        int idleTime = this.getSipApplicationSessionTimeout();
        if (idleTime <= 0) {
            idleTime = 1;
        }
        this.hasDistributableManager = false;
    }

    public void initInternal() throws LifecycleException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Initializing the sip context " + this.getName()));
        }
        super.initInternal();
        this.prepareServletContext();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("sip context Initialized " + this.getName()));
        }
    }

    protected void prepareServletContext() throws LifecycleException {
        if (this.sipApplicationDispatcher == null) {
            this.setApplicationDispatcher();
        }
        if (this.sipFactoryFacade == null) {
            this.sipFactoryFacade = new SipFactoryFacade((SipFactoryImpl)this.sipApplicationDispatcher.getSipFactory(), (SipContext)this);
        }
        if (this.sipSessionsUtil == null) {
            this.sipSessionsUtil = new SipSessionsUtilImpl((SipContext)this);
        }
        if (this.timerService == null) {
            this.timerService = new TimerServiceImpl(this.sipApplicationDispatcher.getSipService(), this.applicationName);
        }
        if (this.proxyTimerService == null) {
            String proxyTimerServiceType = this.sipApplicationDispatcher.getSipService().getProxyTimerServiceImplementationType();
            this.proxyTimerService = proxyTimerServiceType != null && proxyTimerServiceType.equalsIgnoreCase("Standard") ? new ProxyTimerServiceImpl(this.applicationName) : (proxyTimerServiceType != null && proxyTimerServiceType.equalsIgnoreCase("Default") ? new DefaultProxyTimerService(this.applicationName) : new ProxyTimerServiceImpl(this.applicationName));
        }
        if (this.sasTimerService == null || !this.sasTimerService.isStarted()) {
            String sasTimerServiceType = this.sipApplicationDispatcher.getSipService().getSasTimerServiceImplementationType();
            this.sasTimerService = sasTimerServiceType != null && sasTimerServiceType.equalsIgnoreCase("Standard") ? new StandardSipApplicationSessionTimerService(this.applicationName) : (sasTimerServiceType != null && sasTimerServiceType.equalsIgnoreCase("Default") ? new DefaultSipApplicationSessionTimerService(this.applicationName) : new StandardSipApplicationSessionTimerService(this.applicationName));
        }
        this.getServletContext().setAttribute("javax.servlet.sip.SipFactory", (Object)this.sipFactoryFacade);
        this.getServletContext().setAttribute("javax.servlet.sip.TimerService", (Object)this.timerService);
        this.getServletContext().setAttribute("javax.servlet.sip.supported", Arrays.asList(this.sipApplicationDispatcher.getExtensionsSupported()));
        this.getServletContext().setAttribute("javax.servlet.sip.100rel", (Object)Boolean.TRUE);
        this.getServletContext().setAttribute("javax.servlet.sip.supportedRfcs", Arrays.asList(this.sipApplicationDispatcher.getRfcSupported()));
        this.getServletContext().setAttribute("javax.servlet.sip.SipSessionsUtil", (Object)this.sipSessionsUtil);
        this.getServletContext().setAttribute("javax.servlet.sip.outboundInterfaces", (Object)this.sipApplicationDispatcher.getOutboundInterfaces());
        this.getServletContext().setAttribute("org.mobicents.servlet.sip.SIP_CONNECTORS", (Object)this.sipApplicationDispatcher.getSipService().findSipConnectors());
        this.getServletContext().setAttribute("org.mobicents.servlet.sip.DNS_RESOLVER", (Object)this.sipApplicationDispatcher.getDNSResolver());
    }

    protected void setApplicationDispatcher() throws LifecycleException {
        Service service;
        Container container = this.getParent().getParent();
        if (container instanceof Engine && (service = ((Engine)container).getService()) instanceof SipService) {
            this.sipApplicationDispatcher = ((SipService)service).getSipApplicationDispatcher();
        }
        if (this.sipApplicationDispatcher == null) {
            throw new LifecycleException("cannot find any application dispatcher for this context " + this.name);
        }
    }

    public synchronized void startInternal() throws LifecycleException {
        Loader loader;
        String useNamingProperty;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Starting the sip context " + this.getName()));
        }
        this.prepareServletContext();
        boolean ok = true;
        if (this.getNamingResources() != null) {
            this.getNamingResources().start();
        }
        if (this.getResources() == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Configuring default Resources");
            }
            try {
                this.setResources((WebResourceRoot)new StandardRoot((Context)this));
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)("Error initializing resources: " + e.getMessage()));
                ok = false;
            }
        }
        if (ok) {
            this.resourcesStart();
        }
        if (this.getLoader() == null) {
            WebappLoader webappLoader = new WebappLoader(this.getParentClassLoader());
            webappLoader.setDelegate(this.getDelegate());
            this.setLoader((Loader)webappLoader);
        }
        this.getCharsetMapper();
        this.postWorkDirectory();
        boolean dependencyCheck = true;
        try {
            dependencyCheck = ExtensionValidator.validateApplication((WebResourceRoot)this.getResources(), (Context)this);
        }
        catch (IOException ioe) {
            logger.error((Object)"Error in dependencyCheck", (Throwable)ioe);
            dependencyCheck = false;
        }
        if (!dependencyCheck) {
            ok = false;
        }
        if ((useNamingProperty = System.getProperty("catalina.useNaming")) != null && useNamingProperty.equals("false")) {
            this.setUseNaming(false);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Processing standard container startup");
        }
        if ((loader = this.getLoader()) != null && loader instanceof Lifecycle) {
            ((Lifecycle)loader).start();
        }
        if (ok && this.isUseNaming()) {
            if (this.getNamingContextListener() == null) {
                SipNamingContextListener namingContextListener = new SipNamingContextListener();
                namingContextListener.setName(this.getNamingContextName());
                namingContextListener.setExceptionOnFailedWrite(this.getJndiExceptionOnFailedWrite());
                this.setNamingContextListener(namingContextListener);
                this.addLifecycleListener((LifecycleListener)namingContextListener);
                this.addContainerListener((ContainerListener)namingContextListener);
            }
            Map<String, Map<String, String>> injectionMap = this.buildInjectionMap(this.getIgnoreAnnotations() ? new NamingResourcesImpl() : this.getNamingResources());
            this.setInstanceManager((InstanceManager)new DefaultSipInstanceManager(this.getNamingContextListener().getEnvContext(), injectionMap, this, this.getLoader().getClassLoader()));
        }
        SipStandardManager contextManager = null;
        Manager manager = this.getManager();
        if (manager == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)sm.getString("standardContext.cluster.noManager", new Object[]{this.getCluster() != null, this.getDistributable()}));
            }
            if (this.getCluster() != null && this.getDistributable()) {
                try {
                    contextManager = this.getCluster().createManager(this.getName());
                }
                catch (Exception ex) {
                    logger.error((Object)"standardContext.clusterFail", (Throwable)ex);
                    ok = false;
                }
            } else {
                contextManager = new SipStandardManager();
            }
        }
        if (contextManager != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)sm.getString("standardContext.manager", new Object[]{contextManager.getClass().getName()}));
            }
            this.setManager((Manager)contextManager);
            manager = this.getManager();
        }
        if (manager != null && this.getCluster() != null && this.getDistributable()) {
            this.getCluster().registerManager(manager);
        }
        super.startInternal();
        if (this.getState().isAvailable()) {
            if ((this.getInstanceManager() == null || !(this.getInstanceManager() instanceof SipInstanceManager)) && this.isUseNaming()) {
                Map<String, Map<String, String>> injectionMap = this.buildInjectionMap(this.getIgnoreAnnotations() ? new NamingResourcesImpl() : this.getNamingResources());
                this.setInstanceManager((InstanceManager)new DefaultSipInstanceManager(this.getNamingContextListener().getEnvContext(), injectionMap, this, this.getLoader().getClassLoader()));
            }
            this.getServletContext().setAttribute(InstanceManager.class.getName(), (Object)this.getInstanceManager());
            if (this.getManager() instanceof SipManager) {
                ((SipManager)this.getManager()).setMobicentsSipFactory(this.sipApplicationDispatcher.getSipFactory());
                ((CatalinaSipManager)manager).setContext((Context)this);
            }
            if ((this.mainServlet == null || this.mainServlet.length() < 1) && this.childrenMap.size() == 1) {
                this.setMainServlet(this.childrenMap.keySet().iterator().next());
            }
            this.sipSecurityUtils = new SipSecurityUtils((SipContext)this);
            this.sipDigestAuthenticator = new DigestAuthenticator(this.sipApplicationDispatcher.getSipFactory().getHeaderFactory());
            this.sipApplicationDispatcher.addSipApplication(this.applicationName, (SipContext)this);
            if (manager instanceof DistributableSipManager) {
                this.hasDistributableManager = true;
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"this context contains a manager that allows applications to work in a distributed environment");
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("sip application session timeout for this context is " + this.sipApplicationSessionTimeout + " minutes"));
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)("sip context started " + this.getName()));
            }
        } else if (logger.isInfoEnabled()) {
            logger.info((Object)("sip context didn't started due to errors " + this.getName()));
        }
    }

    private Map<String, Map<String, String>> buildInjectionMap(NamingResourcesImpl namingResources) {
        HashMap<String, Map<String, String>> injectionMap = new HashMap<String, Map<String, String>>();
        for (ContextLocalEjb contextLocalEjb : namingResources.findLocalEjbs()) {
            this.addInjectionTarget((Injectable)contextLocalEjb, injectionMap);
        }
        for (ContextLocalEjb contextLocalEjb : namingResources.findEjbs()) {
            this.addInjectionTarget((Injectable)contextLocalEjb, injectionMap);
        }
        for (ContextLocalEjb contextLocalEjb : namingResources.findEnvironments()) {
            this.addInjectionTarget((Injectable)contextLocalEjb, injectionMap);
        }
        for (ContextLocalEjb contextLocalEjb : namingResources.findMessageDestinationRefs()) {
            this.addInjectionTarget((Injectable)contextLocalEjb, injectionMap);
        }
        for (ContextLocalEjb contextLocalEjb : namingResources.findResourceEnvRefs()) {
            this.addInjectionTarget((Injectable)contextLocalEjb, injectionMap);
        }
        for (ContextLocalEjb contextLocalEjb : namingResources.findResources()) {
            this.addInjectionTarget((Injectable)contextLocalEjb, injectionMap);
        }
        for (ContextLocalEjb contextLocalEjb : namingResources.findServices()) {
            this.addInjectionTarget((Injectable)contextLocalEjb, injectionMap);
        }
        return injectionMap;
    }

    private void postWorkDirectory() {
        File dir;
        String workDir = this.getWorkDir();
        if (workDir == null || workDir.length() == 0) {
            String temp;
            String hostName = null;
            String engineName = null;
            String hostWorkDir = null;
            Container parentHost = this.getParent();
            if (parentHost != null) {
                Container parentEngine;
                hostName = parentHost.getName();
                if (parentHost instanceof StandardHost) {
                    hostWorkDir = ((StandardHost)parentHost).getWorkDir();
                }
                if ((parentEngine = parentHost.getParent()) != null) {
                    engineName = parentEngine.getName();
                }
            }
            if (hostName == null || hostName.length() < 1) {
                hostName = "_";
            }
            if (engineName == null || engineName.length() < 1) {
                engineName = "_";
            }
            if ((temp = this.getBaseName()).startsWith("/")) {
                temp = temp.substring(1);
            }
            temp = temp.replace('/', '_');
            if ((temp = temp.replace('\\', '_')).length() < 1) {
                temp = "ROOT";
            }
            workDir = hostWorkDir != null ? hostWorkDir + File.separator + temp : "work" + File.separator + engineName + File.separator + hostName + File.separator + temp;
            this.setWorkDir(workDir);
        }
        if (!(dir = new File(workDir)).isAbsolute()) {
            String catalinaHomePath = null;
            try {
                catalinaHomePath = this.getCatalinaBase().getCanonicalPath();
                dir = new File(catalinaHomePath, workDir);
            }
            catch (IOException e) {
                logger.warn((Object)sm.getString("standardContext.workCreateException", new Object[]{workDir, catalinaHomePath, this.getName()}), (Throwable)e);
            }
        }
        if (!dir.mkdirs() && !dir.isDirectory()) {
            logger.warn((Object)sm.getString("standardContext.workCreateFail", new Object[]{dir, this.getName()}));
        }
        if (this.context == null) {
            this.getServletContext();
        }
        this.context.setAttribute("javax.servlet.context.tempdir", (Object)dir);
    }

    public ServletContext getServletContext() {
        if (this.context == null) {
            this.context = new ConvergedApplicationContext(this);
            if (this.getAltDDName() != null) {
                this.context.setAttribute("org.apache.catalina.deploy.alt_dd", (Object)this.getAltDDName());
            }
        }
        return ((ConvergedApplicationContext)this.context).getFacade();
    }

    public boolean listenerStart() {
        boolean ok = super.listenerStart();
        if (!ok) {
            return ok;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Configuring sip listeners");
        }
        if (!this.sipJNDIContextLoaded) {
            this.loadSipJNDIContext();
        }
        ClassLoader loader = this.getLoader().getClassLoader();
        ok = this.sipListeners.loadListeners(this.findSipApplicationListeners(), loader);
        if (!ok) {
            return ok;
        }
        List servletContextListeners = this.sipListeners.getServletContextListeners();
        if (servletContextListeners != null) {
            ServletContextEvent event = new ServletContextEvent(this.getServletContext());
            for (ServletContextListener servletContextListener : servletContextListeners) {
                if (servletContextListener == null) continue;
                try {
                    this.fireContainerEvent("beforeContextInitialized", servletContextListener);
                    servletContextListener.contextInitialized(event);
                    this.fireContainerEvent("afterContextInitialized", servletContextListener);
                }
                catch (Throwable t) {
                    this.fireContainerEvent("afterContextInitialized", servletContextListener);
                    this.getLogger().error((Object)sm.getString("standardContext.listenerStart", new Object[]{servletContextListener.getClass().getName()}), t);
                    ok = false;
                }
            }
        }
        return ok;
    }

    public boolean listenerStop() {
        List servletContextListeners;
        boolean ok = super.listenerStop();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Sending application stop events");
        }
        if ((servletContextListeners = this.sipListeners.getServletContextListeners()) != null) {
            ServletContextEvent event = new ServletContextEvent(this.getServletContext());
            for (ServletContextListener servletContextListener : servletContextListeners) {
                if (servletContextListener == null) continue;
                try {
                    this.fireContainerEvent("beforeContextDestroyed", servletContextListener);
                    servletContextListener.contextDestroyed(event);
                    this.fireContainerEvent("afterContextDestroyed", servletContextListener);
                }
                catch (Throwable t) {
                    this.fireContainerEvent("afterContextDestroyed", servletContextListener);
                    this.getLogger().error((Object)sm.getString("standardContext.listenerStop", new Object[]{servletContextListener.getClass().getName()}), t);
                    ok = false;
                }
            }
        }
        this.sipListeners.clean();
        return ok;
    }

    public synchronized void stopInternal() throws LifecycleException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Stopping the sip context" + this.name));
        }
        if (this.manager instanceof SipManager) {
            ((SipManager)this.manager).dumpSipSessions();
            ((SipManager)this.manager).dumpSipApplicationSessions();
            logger.info((Object)("number of active sip sessions : " + ((SipManager)this.manager).getActiveSipSessions()));
            logger.info((Object)("number of active sip application sessions : " + ((SipManager)this.manager).getActiveSipApplicationSessions()));
        }
        super.stopInternal();
        this.sipListeners.deallocateServletsActingAsListeners();
        this.sipApplicationListeners.clear();
        this.sipServletMappings.clear();
        this.childrenMap.clear();
        this.childrenMapByClassName.clear();
        if (this.sipApplicationDispatcher != null) {
            if (this.applicationName != null) {
                this.sipApplicationDispatcher.removeSipApplication(this.applicationName);
            } else {
                logger.error((Object)("the application name is null for the following context : " + this.name));
            }
        }
        this.sipJNDIContextLoaded = false;
        if (this.sasTimerService != null && this.sasTimerService.isStarted()) {
            this.sasTimerService.stop();
        }
        this.sasTimerService = null;
        if (this.timerService != null) {
            this.timerService.stop();
        }
        if (this.proxyTimerService != null) {
            this.proxyTimerService.stop();
        }
        if (this.gracefulStopFuture != null) {
            this.gracefulStopFuture.cancel(false);
            this.gracefulStopFuture = null;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("context graceful task cancelled " + this.getName()));
            }
        }
        this.timerService = null;
        this.getServletContext().setAttribute("javax.servlet.sip.TimerService", null);
        this.setLoader(null);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("sip context stopped " + this.name));
        }
    }

    public boolean loadOnStartup(Container[] containers) {
        if (!this.sipJNDIContextLoaded) {
            this.loadSipJNDIContext();
        }
        return super.loadOnStartup(containers);
    }

    protected void loadSipJNDIContext() {
        javax.naming.Context envCtx;
        InitialContext iniCtx;
        if (this.getInstanceManager() instanceof SipInstanceManager) {
            if (this.getNamingContextListener() != null) {
                this.getSipInstanceManager().setContext(this.getNamingContextListener().getEnvContext());
            } else {
                try {
                    iniCtx = new InitialContext();
                    envCtx = (javax.naming.Context)iniCtx.lookup("java:comp/env");
                    this.getSipInstanceManager().setContext(envCtx);
                }
                catch (NamingException e) {
                    logger.error((Object)"Impossible to get the naming context ", (Throwable)e);
                    throw new IllegalStateException(e);
                }
            }
        }
        if (this.isUseNaming()) {
            this.fireContainerEvent("addSipSubcontext", null);
            this.fireContainerEvent("addAppNameSubcontext", null);
            this.fireContainerEvent("addSipFactory", this.sipFactoryFacade);
            this.fireContainerEvent("addSipSessionsUtil", this.sipSessionsUtil);
            this.fireContainerEvent("addTimerService", this.timerService);
        } else {
            try {
                iniCtx = new InitialContext();
                envCtx = (javax.naming.Context)iniCtx.lookup("java:comp/env");
                SipNamingContextListener.addSipSubcontext(envCtx);
                SipNamingContextListener.addAppNameSubContext(envCtx, this.applicationName);
                SipNamingContextListener.addSipFactory(envCtx, this.applicationName, (SipFactory)this.sipFactoryFacade);
                SipNamingContextListener.addSipSessionsUtil(envCtx, this.applicationName, (SipSessionsUtil)this.sipSessionsUtil);
                SipNamingContextListener.addTimerService(envCtx, this.applicationName, (TimerService)this.timerService);
            }
            catch (NamingException e) {
                logger.error((Object)"Impossible to get the naming context ", (Throwable)e);
                throw new IllegalStateException(e);
            }
        }
        this.sipJNDIContextLoaded = true;
    }

    public Wrapper createWrapper() {
        return super.createWrapper();
    }

    public void addChild(Container container) {
        if (this.children.get(container.getName()) == null) {
            if (container instanceof SipServletImpl) {
                this.addChild((SipServletImpl)container);
            } else {
                super.addChild(container);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)(container.getName() + " already present as a Sip Servlet not adding it again"));
        }
    }

    public void addChild(SipServletImpl sipServletImpl) {
        SipServletImpl existingServlet = (SipServletImpl)this.childrenMap.get(sipServletImpl.getName());
        if (existingServlet != null) {
            logger.warn((Object)(sipServletImpl.getName() + " servlet already present, removing the previous one. " + "This might be due to the fact that the definition of the servlet " + "is present both in annotations and in sip.xml"));
            this.childrenMap.remove(sipServletImpl.getName());
            this.childrenMapByClassName.remove(sipServletImpl.getServletClass());
            super.removeChild((Container)existingServlet);
        }
        this.childrenMap.put(sipServletImpl.getName(), (MobicentsSipServlet)sipServletImpl);
        this.childrenMapByClassName.put(sipServletImpl.getServletClass(), (MobicentsSipServlet)sipServletImpl);
        super.addChild((Container)sipServletImpl);
    }

    public void removeChild(SipServletImpl sipServletImpl) {
        super.removeChild((Container)sipServletImpl);
        this.childrenMap.remove(sipServletImpl.getName());
        this.childrenMapByClassName.remove(sipServletImpl.getServletClass());
    }

    public Map<String, MobicentsSipServlet> getChildrenMap() {
        return this.childrenMap;
    }

    public MobicentsSipServlet findSipServletByName(String name) {
        if (name == null) {
            return null;
        }
        return this.childrenMap.get(name);
    }

    public MobicentsSipServlet findSipServletByClassName(String className) {
        if (className == null) {
            return null;
        }
        return this.childrenMapByClassName.get(className);
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getApplicationNameHashed() {
        return this.sipApplicationDispatcher.getHashFromApplicationName(this.applicationName);
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLargeIcon() {
        return this.largeIcon;
    }

    public void setLargeIcon(String largeIcon) {
        this.largeIcon = largeIcon;
    }

    public SipListeners getListeners() {
        return this.sipListeners;
    }

    public void setListeners(SipListeners listeners) {
        this.sipListeners = (CatalinaSipListenersHolder)listeners;
    }

    public boolean isMainServlet() {
        return this.isMainServlet;
    }

    public String getMainServlet() {
        return this.mainServlet;
    }

    public void setMainServlet(String mainServlet) {
        this.mainServlet = mainServlet;
        this.isMainServlet = true;
        this.servletHandler = mainServlet;
    }

    public int getProxyTimeout() {
        return this.proxyTimeout;
    }

    public void setProxyTimeout(int proxyTimeout) {
        this.proxyTimeout = proxyTimeout;
    }

    public void addConstraint(SipSecurityConstraint securityConstraint) {
        super.addConstraint((SecurityConstraint)securityConstraint);
    }

    public void removeConstraint(SipSecurityConstraint securityConstraint) {
        super.removeConstraint((SecurityConstraint)securityConstraint);
    }

    public String getSmallIcon() {
        return this.smallIcon;
    }

    public void setSmallIcon(String smallIcon) {
        this.smallIcon = smallIcon;
    }

    public void setLoginConfig(LoginConfig config) {
        super.setLoginConfig(config);
    }

    public LoginConfig getLoginConfig() {
        return super.getLoginConfig();
    }

    public void setSipLoginConfig(MobicentsSipLoginConfig config) {
        this.sipLoginConfig = config;
    }

    public MobicentsSipLoginConfig getSipLoginConfig() {
        return this.sipLoginConfig;
    }

    public void addSipApplicationListener(String listener) {
        this.sipApplicationListeners.add(listener);
        this.fireContainerEvent("addSipApplicationListener", listener);
    }

    public void removeSipApplicationListener(String listener) {
        this.sipApplicationListeners.remove(listener);
        this.fireContainerEvent("removeSipApplicationListener", listener);
    }

    public String[] findSipApplicationListeners() {
        return this.sipApplicationListeners.toArray(new String[this.sipApplicationListeners.size()]);
    }

    public SipApplicationDispatcher getSipApplicationDispatcher() {
        return this.sipApplicationDispatcher;
    }

    public SipFactoryFacade getSipFactoryFacade() {
        return this.sipFactoryFacade;
    }

    public SipSessionsUtilImpl getSipSessionsUtil() {
        return this.sipSessionsUtil;
    }

    public TimerService getTimerService() {
        return this.timerService;
    }

    public ProxyTimerService getProxyTimerService() {
        return this.proxyTimerService;
    }

    private String getNamingContextName() {
        if (this.namingContextName == null) {
            Container parent = this.getParent();
            if (parent == null) {
                this.namingContextName = this.getName();
            } else {
                Stack<String> stk = new Stack<String>();
                StringBuffer buff = new StringBuffer();
                while (parent != null) {
                    stk.push(parent.getName());
                    parent = parent.getParent();
                }
                while (!stk.empty()) {
                    buff.append("/" + (String)stk.pop());
                }
                buff.append(this.getName());
                this.namingContextName = buff.toString();
            }
        }
        return this.namingContextName;
    }

    public synchronized void setManager(Manager manager) {
        if (manager instanceof SipManager && this.sipApplicationDispatcher != null) {
            ((SipManager)manager).setMobicentsSipFactory(this.sipApplicationDispatcher.getSipFactory());
            ((CatalinaSipManager)manager).setContainer((Container)this);
        }
        if (manager instanceof DistributableSipManager) {
            this.hasDistributableManager = true;
            if (logger.isInfoEnabled()) {
                logger.info((Object)"this context contains a manager that allows applications to work in a distributed environment");
            }
        }
        super.setManager(manager);
    }

    public Manager getManager() {
        return super.getManager();
    }

    public int getSipApplicationSessionTimeout() {
        return this.sipApplicationSessionTimeout;
    }

    public void setSipApplicationSessionTimeout(int sipApplicationSessionTimeout) {
        this.sipApplicationSessionTimeout = sipApplicationSessionTimeout;
    }

    public Method getSipApplicationKeyMethod() {
        return this.sipApplicationKeyMethod;
    }

    public void setSipApplicationKeyMethod(Method sipApplicationKeyMethod) {
        this.sipApplicationKeyMethod = sipApplicationKeyMethod;
    }

    public void addSipServletMapping(MobicentsSipServletMapping sipServletMapping) {
        this.sipServletMappings.add(sipServletMapping);
        this.isMainServlet = false;
        if (this.servletHandler == null) {
            this.servletHandler = sipServletMapping.getServletName();
        }
    }

    public List<MobicentsSipServletMapping> findSipServletMappings() {
        return this.sipServletMappings;
    }

    public MobicentsSipServletMapping findSipServletMappings(SipServletRequest sipServletRequest) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Checking sip Servlet Mapping for following request : " + sipServletRequest));
        }
        for (MobicentsSipServletMapping sipServletMapping : this.sipServletMappings) {
            if (sipServletMapping.getMatchingRule().matches(sipServletRequest)) {
                return sipServletMapping;
            }
            logger.debug((Object)("Following mapping rule didn't match : servletName => " + sipServletMapping.getServletName() + " | expression = " + sipServletMapping.getMatchingRule().getExpression()));
        }
        return null;
    }

    public void removeSipServletMapping(MobicentsSipServletMapping sipServletMapping) {
        this.sipServletMappings.remove(sipServletMapping);
    }

    public final SipManager getSipManager() {
        return (SipManager)this.manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notifySipContextListeners(SipContextEvent event) {
        boolean ok = true;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.childrenMap.size() + " container to notify of " + event.getEventType()));
        }
        if (event.getEventType() == SipContextEventType.SERVLET_INITIALIZED) {
            if (!this.timerService.isStarted()) {
                this.timerService.start();
            }
            if (!this.proxyTimerService.isStarted()) {
                this.proxyTimerService.start();
            }
            if (!this.sasTimerService.isStarted()) {
                this.sasTimerService.start();
            }
        }
        this.enterSipApp(null, null, false, true);
        boolean batchStarted = this.enterSipAppHa(true);
        ArrayList<MobicentsSipServlet> sipServlets = new ArrayList<MobicentsSipServlet>(this.childrenMap.values());
        Collections.sort(sipServlets, new SipServletLoadOnStartupComparator());
        try {
            for (MobicentsSipServlet container : sipServlets) {
                Servlet sipServlet;
                Wrapper wrapper;
                block32: {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("container " + container.getName() + ", class : " + container.getClass().getName()));
                    }
                    if (!(container instanceof Wrapper)) continue;
                    wrapper = (Wrapper)container;
                    sipServlet = null;
                    try {
                        sipServlet = wrapper.allocate();
                        if (!(sipServlet instanceof SipServlet)) break block32;
                        boolean servletHandlerWasNull = false;
                        if (this.servletHandler == null) {
                            this.servletHandler = container.getName();
                            servletHandlerWasNull = true;
                        }
                        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                        try {
                            ClassLoader cl = this.getLoader().getClassLoader();
                            Thread.currentThread().setContextClassLoader(cl);
                            switch (event.getEventType()) {
                                case SERVLET_INITIALIZED: {
                                    SipServletContextEvent sipServletContextEvent = new SipServletContextEvent(this.getServletContext(), (SipServlet)sipServlet);
                                    List sipServletListeners = this.sipListeners.getSipServletsListeners();
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)(sipServletListeners.size() + " SipServletListener to notify of servlet initialization"));
                                    }
                                    for (SipServletListener sipServletListener : sipServletListeners) {
                                        sipServletListener.servletInitialized(sipServletContextEvent);
                                    }
                                    break;
                                }
                                case SIP_CONNECTOR_ADDED: {
                                    this.getServletContext().setAttribute("javax.servlet.sip.outboundInterfaces", (Object)this.sipApplicationDispatcher.getOutboundInterfaces());
                                    this.getServletContext().setAttribute("org.mobicents.servlet.sip.SIP_CONNECTORS", (Object)this.sipApplicationDispatcher.getSipService().findSipConnectors());
                                    List sipConnectorListeners = this.sipListeners.getSipConnectorListeners();
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)(sipConnectorListeners.size() + " SipConnectorListener to notify of sip connector addition"));
                                    }
                                    for (SipConnectorListener sipConnectorListener : sipConnectorListeners) {
                                        sipConnectorListener.sipConnectorAdded((SipConnector)event.getEventObject());
                                    }
                                    break;
                                }
                                case SIP_CONNECTOR_REMOVED: {
                                    this.getServletContext().setAttribute("javax.servlet.sip.outboundInterfaces", (Object)this.sipApplicationDispatcher.getOutboundInterfaces());
                                    this.getServletContext().setAttribute("org.mobicents.servlet.sip.SIP_CONNECTORS", (Object)this.sipApplicationDispatcher.getSipService().findSipConnectors());
                                    List sipConnectorListeners = this.sipListeners.getSipConnectorListeners();
                                    if (logger.isDebugEnabled()) {
                                        logger.debug((Object)(sipConnectorListeners.size() + " SipConnectorListener to notify of sip connector removal"));
                                    }
                                    for (SipConnectorListener sipConnectorListener : sipConnectorListeners) {
                                        sipConnectorListener.sipConnectorRemoved((SipConnector)event.getEventObject());
                                    }
                                    break;
                                }
                            }
                            if (servletHandlerWasNull) {
                                this.servletHandler = null;
                            }
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(oldClassLoader);
                        }
                    }
                    catch (ServletException e) {
                        logger.error((Object)("Cannot allocate the servlet " + wrapper.getServletClass() + " for notifying the listener " + " of the event " + event.getEventType()), (Throwable)e);
                        ok = false;
                    }
                    catch (Throwable e) {
                        logger.error((Object)("An error occured when notifying the servlet " + wrapper.getServletClass() + " of the event " + event.getEventType()), e);
                        ok = false;
                    }
                }
                try {
                    if (sipServlet == null) continue;
                    wrapper.deallocate(sipServlet);
                }
                catch (ServletException e) {
                    logger.error((Object)("Deallocate exception for servlet" + wrapper.getName()), (Throwable)e);
                    ok = false;
                }
                catch (Throwable e) {
                    logger.error((Object)("Deallocate exception for servlet" + wrapper.getName()), e);
                    ok = false;
                }
            }
        }
        finally {
            this.exitSipAppHa(null, null, batchStarted);
            this.exitSipApp(null, null);
        }
        return ok;
    }

    public void enterSipApp(MobicentsSipApplicationSession sipApplicationSession, MobicentsSipSession sipSession, boolean checkIsManagedThread, boolean isContainerManaged) {
        switch (this.concurrencyControlMode) {
            case SipSession: {
                if (sipSession == null) break;
                sipSession.acquire();
                break;
            }
            case SipApplicationSession: {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("checkIsManagedThread " + checkIsManagedThread + " , isManagedThread " + this.isManagedThread.get() + ", isContainerManaged " + isContainerManaged));
                }
                if (!checkIsManagedThread || checkIsManagedThread && Boolean.TRUE.equals(this.isManagedThread.get())) {
                    boolean notPresent;
                    if (this.isManagedThread.get() == null) {
                        this.isManagedThread.set(Boolean.TRUE);
                    }
                    if (sipApplicationSession == null) break;
                    SipApplicationSessionCreationThreadLocal sipApplicationSessionCreationThreadLocal = this.sipApplicationSessionsAccessedThreadLocal.get();
                    if (sipApplicationSessionCreationThreadLocal == null) {
                        sipApplicationSessionCreationThreadLocal = new SipApplicationSessionCreationThreadLocal();
                        this.sipApplicationSessionsAccessedThreadLocal.set(sipApplicationSessionCreationThreadLocal);
                    }
                    if ((notPresent = sipApplicationSessionCreationThreadLocal.getSipApplicationSessions().add(sipApplicationSession)) && isContainerManaged) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("acquiring sipApplicationSession=" + sipApplicationSession + " since it is not present in our local thread of accessed sip application sessions "));
                        }
                        sipApplicationSession.acquire();
                        break;
                    }
                    if (!logger.isDebugEnabled()) break;
                    if (!isContainerManaged) {
                        logger.debug((Object)("not acquiring sipApplicationSession=" + sipApplicationSession + " since application specified the container shouldn't manage it "));
                        break;
                    }
                    logger.debug((Object)("not acquiring sipApplicationSession=" + sipApplicationSession + " since it is present in our local thread of accessed sip application sessions "));
                    break;
                }
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("not acquiring sipApplicationSession=" + sipApplicationSession + " since isManagedThread is " + this.isManagedThread.get()));
                break;
            }
        }
    }

    public void exitSipApp(MobicentsSipApplicationSession sipApplicationSession, MobicentsSipSession sipSession) {
        switch (this.concurrencyControlMode) {
            case SipSession: {
                if (sipSession != null) {
                    sipSession.release();
                    break;
                }
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("NOT RELEASING SipSession on exit sipApplicationSession=" + sipApplicationSession + " sipSession=" + sipSession + " semaphore=null"));
                break;
            }
            case SipApplicationSession: {
                boolean wasSessionReleased = false;
                SipApplicationSessionCreationThreadLocal sipApplicationSessionCreationThreadLocal = this.sipApplicationSessionsAccessedThreadLocal.get();
                if (sipApplicationSessionCreationThreadLocal != null) {
                    for (MobicentsSipApplicationSession sipApplicationSessionAccessed : this.sipApplicationSessionsAccessedThreadLocal.get().getSipApplicationSessions()) {
                        sipApplicationSessionAccessed.release();
                        if (!sipApplicationSessionAccessed.equals(sipApplicationSession)) continue;
                        wasSessionReleased = true;
                    }
                    this.sipApplicationSessionsAccessedThreadLocal.get().getSipApplicationSessions().clear();
                    this.sipApplicationSessionsAccessedThreadLocal.set(null);
                    this.sipApplicationSessionsAccessedThreadLocal.remove();
                }
                this.isManagedThread.set(null);
                this.isManagedThread.remove();
                if (wasSessionReleased) break;
                if (sipApplicationSession != null) {
                    sipApplicationSession.release();
                    break;
                }
                if (!logger.isDebugEnabled()) break;
                logger.debug((Object)("NOT RELEASING SipApplicationSession on exit sipApplicationSession=" + sipApplicationSession + " sipSession=" + sipSession + " semaphore=null"));
                break;
            }
        }
    }

    public ConcurrencyControlMode getConcurrencyControlMode() {
        return this.concurrencyControlMode;
    }

    public void setConcurrencyControlMode(ConcurrencyControlMode mode) {
        this.concurrencyControlMode = mode;
        if (this.concurrencyControlMode != null && logger.isInfoEnabled()) {
            logger.info((Object)("Concurrency Control set to " + this.concurrencyControlMode.toString() + " for application " + this.applicationName));
        }
    }

    public SipRubyController getSipRubyController() {
        return null;
    }

    public void setSipRubyController(SipRubyController rubyController) {
        throw new UnsupportedOperationException("ruby applications are not supported on Tomcat or JBoss 4.X versions");
    }

    public SipApplicationSessionTimerService getSipApplicationSessionTimerService() {
        return this.sasTimerService;
    }

    public boolean hasDistributableManager() {
        return this.hasDistributableManager;
    }

    public String getServletHandler() {
        return this.servletHandler;
    }

    public void setServletHandler(String servletHandler) {
        this.servletHandler = servletHandler;
    }

    public String getEngineName() {
        return null;
    }

    public boolean enterSipAppHa(boolean startCacheActivity) {
        return false;
    }

    public void exitSipAppHa(MobicentsSipServletRequest request, MobicentsSipServletResponse response, boolean batchStarted) {
    }

    private void addInjectionTarget(Injectable resource, Map<String, Map<String, String>> injectionMap) {
        List injectionTargets = resource.getInjectionTargets();
        if (injectionTargets != null && injectionTargets.size() > 0) {
            String jndiName = resource.getName();
            for (InjectionTarget injectionTarget : injectionTargets) {
                String clazz = injectionTarget.getTargetClass();
                Map<String, String> injections = injectionMap.get(clazz);
                if (injections == null) {
                    injections = new HashMap<String, String>();
                    injectionMap.put(clazz, injections);
                }
                injections.put(injectionTarget.getTargetName(), jndiName);
            }
        }
    }

    public SipInstanceManager getSipInstanceManager() {
        return (SipInstanceManager)super.getInstanceManager();
    }

    public void setInstanceManager(InstanceManager instanceManager) {
        super.setInstanceManager(instanceManager);
    }

    public ClassLoader getSipContextClassLoader() {
        return this.getLoader().getClassLoader();
    }

    public boolean isPackageProtectionEnabled() {
        return SecurityUtil.isPackageProtectionEnabled();
    }

    public boolean authorize(MobicentsSipServletRequest request) {
        return this.sipSecurityUtils.authorize(request);
    }

    public SipDigestAuthenticator getDigestAuthenticator() {
        return this.sipDigestAuthenticator;
    }

    public void enterSipContext() {
        ClassLoader cl = this.getSipContextClassLoader();
        Thread.currentThread().setContextClassLoader(cl);
    }

    public void exitSipContext(ClassLoader oldClassLoader) {
        Thread.currentThread().setContextClassLoader(oldClassLoader);
    }

    public void stopGracefully(long timeToWait) {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Stopping the Context " + this.getName() + " Gracefully in " + timeToWait + " ms"));
        }
        ArrayList<String> applicationsUndeployed = new ArrayList<String>();
        applicationsUndeployed.add(this.applicationName);
        this.sipApplicationDispatcher.getSipApplicationRouter().applicationUndeployed(applicationsUndeployed);
        if (timeToWait == 0L) {
            if (this.gracefulStopFuture != null) {
                this.gracefulStopFuture.cancel(false);
            }
            try {
                this.stop();
            }
            catch (LifecycleException e) {
                logger.error((Object)"The server couldn't be stopped", (Throwable)e);
            }
        } else {
            long gracefulStopTaskInterval = 30000L;
            this.gracefulStopFuture = timeToWait > 0L && timeToWait < gracefulStopTaskInterval ? this.sipApplicationDispatcher.getAsynchronousScheduledExecutor().schedule((Runnable)new ContextGracefulStopTask((Context)this, timeToWait), timeToWait, TimeUnit.MILLISECONDS) : this.sipApplicationDispatcher.getAsynchronousScheduledExecutor().scheduleWithFixedDelay((Runnable)new ContextGracefulStopTask((Context)this, timeToWait), gracefulStopTaskInterval, gracefulStopTaskInterval, TimeUnit.MILLISECONDS);
        }
    }

    public boolean isStoppingGracefully() {
        return this.gracefulStopFuture != null;
    }

    protected class SipServletLoadOnStartupComparator
    implements Comparator<MobicentsSipServlet> {
        protected SipServletLoadOnStartupComparator() {
        }

        @Override
        public int compare(MobicentsSipServlet o1, MobicentsSipServlet o2) {
            if (o1 != null && o2 != null) {
                if (o1.getLoadOnStartup() > o2.getLoadOnStartup()) {
                    return 1;
                }
                if (o1.getLoadOnStartup() == o2.getLoadOnStartup()) {
                    return 0;
                }
                return -1;
            }
            return 0;
        }
    }
}

