/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.startup;

import javax.naming.NamingException;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipSessionsUtil;
import javax.servlet.sip.TimerService;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.Server;
import org.apache.catalina.core.NamingContextListener;
import org.apache.log4j.Logger;
import org.apache.naming.ContextAccessController;
import org.mobicents.servlet.sip.catalina.CatalinaSipContext;
import org.mobicents.servlet.sip.core.SipContext;

public class SipNamingContextListener
extends NamingContextListener {
    private static final transient Logger logger = Logger.getLogger(SipNamingContextListener.class);
    public static final String NAMING_CONTEXT_SIP_SUBCONTEXT_ADDED_EVENT = "addSipSubcontext";
    public static final String NAMING_CONTEXT_SIP_SUBCONTEXT_REMOVED_EVENT = "removeSipSubContext";
    public static final String NAMING_CONTEXT_APPNAME_SUBCONTEXT_ADDED_EVENT = "addAppNameSubcontext";
    public static final String NAMING_CONTEXT_APPNAME_SUBCONTEXT_REMOVED_EVENT = "removeAppNameSubcontext";
    public static final String NAMING_CONTEXT_SIP_FACTORY_ADDED_EVENT = "addSipFactory";
    public static final String NAMING_CONTEXT_SIP_FACTORY_REMOVED_EVENT = "removeSipFactory";
    public static final String NAMING_CONTEXT_SIP_SESSIONS_UTIL_ADDED_EVENT = "addSipSessionsUtil";
    public static final String NAMING_CONTEXT_SIP_SESSIONS_UTIL_REMOVED_EVENT = "removeSipSessionsUtil";
    public static final String NAMING_CONTEXT_TIMER_SERVICE_ADDED_EVENT = "addTimerService";
    public static final String NAMING_CONTEXT_TIMER_SERVICE_REMOVED_EVENT = "removeTimerService";
    public static final String SIP_SUBCONTEXT = "sip";
    public static final String SIP_FACTORY_JNDI_NAME = "SipFactory";
    public static final String SIP_SESSIONS_UTIL_JNDI_NAME = "SipSessionsUtil";
    public static final String TIMER_SERVICE_JNDI_NAME = "TimerService";
    private Object token = null;

    public void lifecycleEvent(LifecycleEvent event) {
        this.container = event.getLifecycle();
        if (this.container instanceof Context) {
            this.token = ((Context)this.container).getNamingToken();
        } else if (this.container instanceof Server) {
            this.token = ((Server)this.container).getNamingToken();
        } else {
            return;
        }
        super.lifecycleEvent(event);
        if (event.getType().equalsIgnoreCase("configure_start") && this.container instanceof CatalinaSipContext) {
            ((CatalinaSipContext)this.container).getSipInstanceManager().setContext(this.envCtx);
        }
    }

    public void containerEvent(ContainerEvent event) {
        TimerService timerService;
        super.containerEvent(event);
        ContextAccessController.setWritable((Object)this.getName(), (Object)this.token);
        String type = event.getType();
        SipContext sipContext = null;
        String appName = null;
        if (event.getContainer() instanceof SipContext) {
            sipContext = (SipContext)event.getContainer();
            appName = sipContext.getApplicationName();
        }
        if (type.equals(NAMING_CONTEXT_SIP_SUBCONTEXT_ADDED_EVENT)) {
            SipNamingContextListener.addSipSubcontext(this.envCtx);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sip Subcontext added to the JNDI context for container " + event.getContainer()));
            }
        } else if (type.equals(NAMING_CONTEXT_SIP_SUBCONTEXT_REMOVED_EVENT)) {
            SipNamingContextListener.removeSipSubcontext(this.envCtx);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Sip Subcontext removed from the JNDI context for container " + event.getContainer()));
            }
        }
        if (type.equals(NAMING_CONTEXT_APPNAME_SUBCONTEXT_ADDED_EVENT)) {
            if (appName != null) {
                SipNamingContextListener.addAppNameSubContext(this.envCtx, appName);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(appName + " Subcontext added to the JNDI context for container " + event.getContainer()));
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)(appName + " is null so subcontext not added to JNDI context for container " + event.getContainer()));
            }
        } else if (type.equals(NAMING_CONTEXT_APPNAME_SUBCONTEXT_REMOVED_EVENT)) {
            if (appName != null) {
                SipNamingContextListener.removeAppNameSubContext(this.envCtx, appName);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(appName + " Subcontext removed from the JNDI context for container " + event.getContainer()));
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)(appName + " is null so subcontext not removed to JNDI context for container " + event.getContainer()));
            }
        } else if (type.equals(NAMING_CONTEXT_SIP_FACTORY_ADDED_EVENT)) {
            SipFactory sipFactory = (SipFactory)event.getData();
            if (sipFactory != null) {
                SipNamingContextListener.addSipFactory(this.envCtx, appName, sipFactory);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Sip Factory added to the JNDI context for container " + event.getContainer()));
                }
            }
        } else if (type.equals(NAMING_CONTEXT_SIP_FACTORY_REMOVED_EVENT)) {
            SipFactory sipFactory = (SipFactory)event.getData();
            if (sipFactory != null) {
                SipNamingContextListener.removeSipFactory(this.envCtx, appName, sipFactory);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Sip Factory removed from the JNDI context for container " + event.getContainer()));
                }
            }
        } else if (type.equals(NAMING_CONTEXT_SIP_SESSIONS_UTIL_ADDED_EVENT)) {
            SipSessionsUtil sipSessionsUtil = (SipSessionsUtil)event.getData();
            if (sipSessionsUtil != null) {
                SipNamingContextListener.addSipSessionsUtil(this.envCtx, appName, sipSessionsUtil);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("SipSessionsUtil added to the JNDI context for container " + event.getContainer()));
                }
            }
        } else if (type.equals(NAMING_CONTEXT_SIP_SESSIONS_UTIL_REMOVED_EVENT)) {
            SipSessionsUtil sipSessionsUtil = (SipSessionsUtil)event.getData();
            if (sipSessionsUtil != null) {
                SipNamingContextListener.removeSipSessionsUtil(this.envCtx, appName, sipSessionsUtil);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("SipSessionsUtil removed from the JNDI context for container " + event.getContainer()));
                }
            }
        } else if (type.equals(NAMING_CONTEXT_TIMER_SERVICE_ADDED_EVENT)) {
            TimerService timerService2 = (TimerService)event.getData();
            if (timerService2 != null) {
                SipNamingContextListener.addTimerService(this.envCtx, appName, timerService2);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("TimerService added to the JNDI context for container " + event.getContainer()));
                }
            }
        } else if (type.equals(NAMING_CONTEXT_SIP_FACTORY_REMOVED_EVENT) && (timerService = (TimerService)event.getData()) != null) {
            SipNamingContextListener.removeTimerService(this.envCtx, appName, timerService);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("TimerService removed from the JNDI context for container " + event.getContainer()));
            }
        }
        ContextAccessController.setReadOnly((Object)this.getName());
    }

    public static void removeSipSubcontext(javax.naming.Context envCtx) {
        try {
            envCtx.destroySubcontext(SIP_SUBCONTEXT);
        }
        catch (NamingException e) {
            logger.error((Object)sm.getString("naming.unbindFailed", new Object[]{e}));
        }
    }

    public static void addSipSubcontext(javax.naming.Context envCtx) {
        try {
            envCtx.createSubcontext(SIP_SUBCONTEXT);
        }
        catch (NamingException e) {
            logger.error((Object)sm.getString("naming.bindFailed", new Object[]{e}));
        }
    }

    public static void removeAppNameSubContext(javax.naming.Context envCtx, String appName) {
        if (envCtx != null) {
            try {
                javax.naming.Context sipContext = (javax.naming.Context)envCtx.lookup(SIP_SUBCONTEXT);
                sipContext.destroySubcontext(appName);
            }
            catch (NamingException e) {
                logger.error((Object)sm.getString("naming.unbindFailed", new Object[]{e}));
            }
        }
    }

    public static void addAppNameSubContext(javax.naming.Context envCtx, String appName) {
        if (envCtx != null) {
            try {
                javax.naming.Context sipContext = (javax.naming.Context)envCtx.lookup(SIP_SUBCONTEXT);
                sipContext.createSubcontext(appName);
            }
            catch (NamingException e) {
                logger.error((Object)sm.getString("naming.bindFailed", new Object[]{e}));
            }
        }
    }

    public static void removeSipSessionsUtil(javax.naming.Context envCtx, String appName, SipSessionsUtil sipSessionsUtil) {
        if (envCtx != null) {
            try {
                javax.naming.Context sipContext = (javax.naming.Context)envCtx.lookup("sip/" + appName);
                sipContext.unbind(SIP_SESSIONS_UTIL_JNDI_NAME);
            }
            catch (NamingException e) {
                logger.error((Object)sm.getString("naming.unbindFailed", new Object[]{e}));
            }
        }
    }

    public static void addSipSessionsUtil(javax.naming.Context envCtx, String appName, SipSessionsUtil sipSessionsUtil) {
        if (envCtx != null) {
            try {
                javax.naming.Context sipContext = (javax.naming.Context)envCtx.lookup("sip/" + appName);
                sipContext.bind(SIP_SESSIONS_UTIL_JNDI_NAME, (Object)sipSessionsUtil);
            }
            catch (NamingException e) {
                logger.error((Object)sm.getString("naming.bindFailed", new Object[]{e}));
            }
        }
    }

    public static void removeTimerService(javax.naming.Context envCtx, String appName, TimerService timerService) {
        if (envCtx != null) {
            try {
                javax.naming.Context sipContext = (javax.naming.Context)envCtx.lookup("sip/" + appName);
                sipContext.unbind(TIMER_SERVICE_JNDI_NAME);
            }
            catch (NamingException e) {
                logger.error((Object)sm.getString("naming.unbindFailed", new Object[]{e}));
            }
        }
    }

    public static void addTimerService(javax.naming.Context envCtx, String appName, TimerService timerService) {
        if (envCtx != null) {
            try {
                javax.naming.Context sipContext = (javax.naming.Context)envCtx.lookup("sip/" + appName);
                sipContext.bind(TIMER_SERVICE_JNDI_NAME, (Object)timerService);
            }
            catch (NamingException e) {
                logger.error((Object)sm.getString("naming.bindFailed", new Object[]{e}));
            }
        }
    }

    public static void removeSipFactory(javax.naming.Context envCtx, String appName, SipFactory sipFactory) {
        if (envCtx != null) {
            try {
                javax.naming.Context sipContext = (javax.naming.Context)envCtx.lookup("sip/" + appName);
                sipContext.unbind(SIP_FACTORY_JNDI_NAME);
            }
            catch (NamingException e) {
                logger.error((Object)sm.getString("naming.unbindFailed", new Object[]{e}));
            }
        }
    }

    public static void addSipFactory(javax.naming.Context envCtx, String appName, SipFactory sipFactory) {
        if (envCtx != null) {
            try {
                javax.naming.Context sipContext = (javax.naming.Context)envCtx.lookup("sip/" + appName);
                sipContext.bind(SIP_FACTORY_JNDI_NAME, (Object)sipFactory);
            }
            catch (NamingException e) {
                logger.error((Object)sm.getString("naming.bindFailed", new Object[]{e}));
            }
        }
    }
}

