/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.startup;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import javax.servlet.ServletContext;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.ExpandWar;
import org.apache.catalina.util.ContextName;
import org.apache.log4j.Logger;
import org.apache.tomcat.util.descriptor.DigesterFactory;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.RuleSet;
import org.mobicents.servlet.sip.annotations.AnnotationVerificationException;
import org.mobicents.servlet.sip.annotations.ClassFileScanner;
import org.mobicents.servlet.sip.catalina.CatalinaSipContext;
import org.mobicents.servlet.sip.catalina.SipDeploymentException;
import org.mobicents.servlet.sip.catalina.SipEntityResolver;
import org.mobicents.servlet.sip.catalina.SipRuleSet;
import org.mobicents.servlet.sip.catalina.SipServletImpl;
import org.mobicents.servlet.sip.core.SipContext;
import org.xml.sax.EntityResolver;

public class SipContextConfig
extends ContextConfig {
    private static final transient Logger logger = Logger.getLogger(SipContextConfig.class);

    public void lifecycleEvent(LifecycleEvent event) {
        try {
            super.lifecycleEvent(event);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected synchronized void configureStart() {
        super.configureStart();
        if (this.context instanceof SipContext) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"starting sipContextConfig");
            }
            ServletContext servletContext = this.context.getServletContext();
            this.context.setWrapperClass(SipServletImpl.class.getName());
            Host host = (Host)this.context.getParent();
            File appBase = host.getAppBaseFile();
            ClassFileScanner scanner = new ClassFileScanner(appBase.getPath() + File.separatorChar + ((CatalinaSipContext)this.context).getDocBase(), (CatalinaSipContext)this.context);
            try {
                scanner.scan();
            }
            catch (AnnotationVerificationException ave) {
                logger.error((Object)"An annotation didn't follow its annotation contract", (Throwable)ave);
                this.ok = false;
            }
            String applicationSipXmlPath = "/WEB-INF/sip.xml";
            InputStream sipXmlInputStream = servletContext.getResourceAsStream(applicationSipXmlPath);
            if (sipXmlInputStream != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(applicationSipXmlPath + " has been found !"));
                }
                Digester sipDigester = DigesterFactory.newDigester((boolean)this.context.getXmlValidation(), (boolean)this.context.getXmlNamespaceAware(), (RuleSet)new SipRuleSet(), (boolean)false);
                SipEntityResolver entityResolver = new SipEntityResolver();
                sipDigester.setValidating(false);
                sipDigester.setEntityResolver((EntityResolver)entityResolver);
                sipDigester.push((Object)this.context);
                sipDigester.setClassLoader(this.context.getClass().getClassLoader());
                try {
                    sipDigester.resolveEntity(null, null);
                    sipDigester.parse(sipXmlInputStream);
                }
                catch (Throwable e) {
                    logger.warn((Object)"Impossible to parse the sip.xml deployment descriptor");
                    this.ok = false;
                }
            } else {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)(applicationSipXmlPath + " has not been found !"));
                }
                this.ok = false;
            }
            if (scanner.isApplicationParsed()) {
                this.ok = true;
            }
            this.checkSipDeploymentRequirements(this.context);
            if (!scanner.isApplicationParsed() && sipXmlInputStream != null) {
                this.context.setWrapperClass(StandardWrapper.class.getName());
            }
            if (this.ok) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"sipContextConfig started");
                }
                this.context.setConfigured(true);
            } else {
                logger.warn((Object)"sipContextConfig didn't start properly");
                this.context.setConfigured(false);
            }
        }
    }

    private void checkSipDeploymentRequirements(Context context) {
        if (((SipContext)context).getApplicationName() == null) {
            this.ok = false;
            context.setConfigured(false);
            throw new SipDeploymentException("No app-name present in the sip.xml deployment descriptor or no SipApplication annotation defined");
        }
        boolean servletSelectionSet = false;
        String mainServlet = ((SipContext)context).getMainServlet();
        if (mainServlet != null && mainServlet.length() > 0) {
            servletSelectionSet = true;
        } else if (((SipContext)context).findSipServletMappings() != null && ((SipContext)context).findSipServletMappings().size() > 0) {
            servletSelectionSet = true;
        } else if (((SipContext)context).getSipRubyController() != null) {
            servletSelectionSet = true;
        }
        if (((SipContext)context).getChildrenMap().keySet().size() > 1 && !servletSelectionSet) {
            this.ok = false;
            context.setConfigured(false);
            throw new SipDeploymentException("the main servlet is not set and there is more than one servlet defined in the sip.xml or as annotations !");
        }
    }

    protected synchronized void configureStop() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"stopping sipContextConfig");
        }
        super.configureStop();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"sipContextConfig stopped");
        }
    }

    protected void fixDocBase() throws IOException {
        File file;
        Host host = (Host)this.context.getParent();
        File appBase = host.getAppBaseFile();
        String docBase = this.context.getDocBase();
        if (docBase == null) {
            String path = this.context.getPath();
            if (path == null) {
                return;
            }
            ContextName cn = new ContextName(path, this.context.getWebappVersion());
            docBase = cn.getBaseName();
        }
        docBase = !(file = new File(docBase)).isAbsolute() ? new File(appBase, docBase).getPath() : file.getCanonicalPath();
        file = new File(docBase);
        String origDocBase = docBase;
        ContextName cn = new ContextName(this.context.getPath(), this.context.getWebappVersion());
        String pathName = cn.getBaseName();
        boolean unpackWARs = true;
        if (host instanceof StandardHost && (unpackWARs = ((StandardHost)host).isUnpackWARs()) && this.context instanceof StandardContext) {
            unpackWARs = ((StandardContext)this.context).getUnpackWAR();
        }
        if ((docBase.toLowerCase(Locale.ENGLISH).endsWith(".sar") || docBase.toLowerCase(Locale.ENGLISH).endsWith(".war")) && !file.isDirectory()) {
            if (unpackWARs) {
                URL war = new URL("jar:" + new File(docBase).toURI().toURL() + "!/");
                docBase = ExpandWar.expand((Host)host, (URL)war, (String)pathName);
                file = new File(docBase);
                docBase = file.getCanonicalPath();
                if (this.context instanceof StandardContext) {
                    ((StandardContext)this.context).setOriginalDocBase(origDocBase);
                }
            } else {
                URL war = new URL("jar:" + new File(docBase).toURI().toURL() + "!/");
                ExpandWar.validate((Host)host, (URL)war, (String)pathName);
            }
        } else {
            File docDir = new File(docBase);
            if (!docDir.exists()) {
                String[] extensions;
                for (String extension : extensions = new String[]{".sar", ".war"}) {
                    File archiveFile = new File(docBase + extension);
                    if (!archiveFile.exists()) continue;
                    URL war = new URL("jar:" + archiveFile.toURI().toURL() + "!/");
                    if (unpackWARs) {
                        docBase = ExpandWar.expand((Host)host, (URL)war, (String)this.context.getPath());
                        file = new File(docBase);
                        docBase = file.getCanonicalPath();
                        break;
                    }
                    docBase = archiveFile.getCanonicalPath();
                    ExpandWar.validate((Host)host, (URL)war, (String)pathName);
                    break;
                }
                if (this.context instanceof StandardContext) {
                    ((StandardContext)this.context).setOriginalDocBase(origDocBase);
                }
            }
        }
        if (docBase.startsWith(appBase.getPath() + File.separatorChar)) {
            docBase = docBase.substring(appBase.getPath().length());
            if ((docBase = docBase.replace(File.separatorChar, '/')).startsWith("/")) {
                docBase = docBase.substring(1);
            }
        } else {
            docBase = docBase.replace(File.separatorChar, '/');
        }
        this.context.setDocBase(docBase);
    }
}

