/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.annotations;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.naming.NamingException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import javax.xml.ws.WebServiceRef;
import org.apache.catalina.Context;
import org.apache.catalina.core.DefaultInstanceManager;
import org.mobicents.servlet.sip.catalina.CatalinaSipContext;
import org.mobicents.servlet.sip.catalina.annotations.SipInstanceManager;
import org.mobicents.servlet.sip.core.SipContext;

public class DefaultSipInstanceManager
extends DefaultInstanceManager
implements SipInstanceManager {
    private SipContext sipContext;
    private javax.naming.Context context;
    private final Map<String, Map<String, String>> injectionMap;

    public void processAnnotations(Object instance, Map<String, String> injections) throws IllegalAccessException, InvocationTargetException, NamingException {
        if (this.context == null) {
            return;
        }
        Field[] fields = instance.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Resource annotation;
            if (injections != null && injections.containsKey(fields[i].getName())) {
                DefaultSipInstanceManager.lookupFieldResource(this.context, instance, fields[i], injections.get(fields[i].getName()));
                continue;
            }
            if (fields[i].isAnnotationPresent(Resource.class)) {
                annotation = fields[i].getAnnotation(Resource.class);
                if (this.lookupResourceInServletContext(instance, fields[i], annotation.name())) continue;
                DefaultSipInstanceManager.lookupFieldResource(this.context, instance, fields[i], annotation.name());
                continue;
            }
            if (fields[i].isAnnotationPresent(EJB.class)) {
                annotation = fields[i].getAnnotation(EJB.class);
                DefaultSipInstanceManager.lookupFieldResource(this.context, instance, fields[i], annotation.name());
                continue;
            }
            if (fields[i].isAnnotationPresent(WebServiceRef.class)) {
                annotation = fields[i].getAnnotation(WebServiceRef.class);
                DefaultSipInstanceManager.lookupFieldResource(this.context, instance, fields[i], annotation.name());
                continue;
            }
            if (fields[i].isAnnotationPresent(PersistenceContext.class)) {
                annotation = fields[i].getAnnotation(PersistenceContext.class);
                DefaultSipInstanceManager.lookupFieldResource(this.context, instance, fields[i], annotation.name());
                continue;
            }
            if (!fields[i].isAnnotationPresent(PersistenceUnit.class)) continue;
            annotation = fields[i].getAnnotation(PersistenceUnit.class);
            DefaultSipInstanceManager.lookupFieldResource(this.context, instance, fields[i], annotation.name());
        }
    }

    protected boolean lookupResourceInServletContext(Object instance, Field field, String annotationName) {
        Object objectToInject;
        String typeName = field.getType().getCanonicalName();
        if (annotationName == null || annotationName.equals("")) {
            annotationName = typeName;
        }
        if ((objectToInject = this.sipContext.getServletContext().getAttribute(annotationName)) != null && field.getType().isAssignableFrom(objectToInject.getClass())) {
            boolean accessibility = false;
            accessibility = field.isAccessible();
            field.setAccessible(true);
            try {
                field.set(instance, objectToInject);
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            field.setAccessible(accessibility);
            return true;
        }
        return false;
    }

    protected static void lookupFieldResource(javax.naming.Context context, Object instance, Field field, String name) throws NamingException, IllegalAccessException {
        Object lookedupResource = null;
        boolean accessibility = false;
        String normalizedName = DefaultSipInstanceManager.normalize(name);
        lookedupResource = normalizedName != null && normalizedName.length() > 0 ? context.lookup(normalizedName) : (field.getClass().getName().startsWith("javax.servlet.sip") ? context.lookup("sip/" + instance.getClass().getName() + "/" + field.getName()) : context.lookup(instance.getClass().getName() + "/" + field.getName()));
        accessibility = field.isAccessible();
        field.setAccessible(true);
        field.set(instance, lookedupResource);
        field.setAccessible(accessibility);
    }

    public DefaultSipInstanceManager(javax.naming.Context context, Map<String, Map<String, String>> injectionMap, CatalinaSipContext catalinaContext, ClassLoader containerClassLoader) {
        super(context, injectionMap, (Context)catalinaContext, containerClassLoader);
        this.context = context;
        this.sipContext = catalinaContext;
        this.injectionMap = injectionMap;
    }

    public void setSipContext(SipContext sipContext) {
        this.sipContext = sipContext;
    }

    public SipContext getSipContext() {
        return this.sipContext;
    }

    public void setContext(javax.naming.Context context) {
        this.context = context;
    }

    public javax.naming.Context getContext() {
        return this.context;
    }

    public Map<String, String> getInjectionMap(String name) {
        if (this.injectionMap != null) {
            return this.injectionMap.get(name);
        }
        return null;
    }

    private static String normalize(String jndiName) {
        if (jndiName != null && jndiName.startsWith("java:comp/env/")) {
            return jndiName.substring(14);
        }
        return jndiName;
    }
}

