/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.annotations;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.annotation.SipApplication;
import javax.servlet.sip.annotation.SipApplicationKey;
import javax.servlet.sip.annotation.SipListener;
import javax.servlet.sip.annotation.SipServlet;
import org.apache.catalina.Container;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.annotation.ConcurrencyControl;
import org.mobicents.servlet.sip.annotations.AnnotationVerificationException;
import org.mobicents.servlet.sip.catalina.CatalinaSipContext;
import org.mobicents.servlet.sip.catalina.SipServletImpl;

public class ClassFileScanner {
    private static final transient Logger logger = Logger.getLogger(ClassFileScanner.class);
    private String docbase;
    private CatalinaSipContext sipContext;
    private String parsedAnnotatedPackage = null;
    private boolean applicationParsed = false;
    private Method sipAppKey = null;
    private ClassLoader classLoader;

    public ClassFileScanner(String docbase, CatalinaSipContext ctx) {
        this.docbase = docbase;
        this.sipContext = ctx;
    }

    public void scan() throws AnnotationVerificationException {
        ClassLoader cl = this.sipContext.getClass().getClassLoader();
        this.classLoader = this.sipContext.getLoader().getClassLoader();
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Annotations docBase : " + this.docbase));
        }
        this._scan(new File(this.docbase));
    }

    protected void _scan(File folder) throws AnnotationVerificationException {
        File[] files = folder.listFiles();
        if (files != null) {
            for (int j = 0; j < files.length; ++j) {
                if (files[j].isDirectory()) {
                    this._scan(files[j]);
                    continue;
                }
                if (files[j].getAbsolutePath().endsWith(".jar")) {
                    this.scanJar(files[j].getAbsolutePath());
                    continue;
                }
                this.analyzeClass(files[j].getAbsolutePath());
            }
        }
    }

    private void scanJar(String path) throws AnnotationVerificationException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("scanning jar " + path + " for annotations"));
        }
        try {
            JarFile jar = new JarFile(path);
            Enumeration<JarEntry> jarEntries = jar.entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = jarEntries.nextElement();
                String entryName = jarEntry.getName();
                if (!entryName.endsWith(".class")) continue;
                String className = entryName.substring(0, entryName.indexOf(".class"));
                className = className.replace('/', '.');
                className = className.replace('\\', '.');
                try {
                    Class<?> clazz = Class.forName(className, false, this.classLoader);
                    this.processAnnotations(clazz);
                }
                catch (Throwable e) {
                    logger.debug((Object)("Failed to parse annotations for class " + className));
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Failed to parse annotations for class " + className), e);
                }
            }
        }
        catch (IOException e) {
            throw new AnnotationVerificationException("couldn't read the following jar file for parsing annotations " + path, e);
        }
    }

    protected void analyzeClass(String path) throws AnnotationVerificationException {
        block6: {
            int classesIndex;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("analyzing class " + path + " for annotations"));
            }
            if ((classesIndex = path.toLowerCase().lastIndexOf("classes/")) < 0) {
                classesIndex = path.toLowerCase().lastIndexOf("classes\\");
            }
            String classpath = path.substring(classesIndex += "classes/".length());
            if ((classpath = classpath.replace('/', '.').replace('\\', '.')).endsWith(".class")) {
                if ((classpath = classpath.substring(0, classpath.length() - 6)).startsWith(".")) {
                    classpath = classpath.substring(1);
                }
                String className = classpath;
                try {
                    Class<?> clazz = Class.forName(className, false, this.classLoader);
                    this.processAnnotations(clazz);
                }
                catch (Throwable e) {
                    logger.debug((Object)("Failed to parse annotations for class " + className));
                    if (!logger.isDebugEnabled()) break block6;
                    logger.debug((Object)("Failed to parse annotations for class " + className), e);
                }
            }
        }
    }

    protected void processAnnotations(Class clazz) throws AnnotationVerificationException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("analyzing class " + clazz + " for annotations"));
        }
        this.processListenerAnnotation(clazz);
        this.processServletAnnotation(clazz);
        this.processSipApplicationKeyAnnotation(clazz);
        this.processConcurrencyAnnotation(clazz);
        if (clazz.toString().contains("package-info")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("scanning " + clazz.getCanonicalName() + " for @SipApplication annotation"));
            }
            Package pack = clazz.getPackage();
            String packageName = pack.getName();
            SipApplication appData = this.getApplicationAnnotation(pack);
            if (appData != null) {
                if (this.parsedAnnotatedPackage != null && !this.parsedAnnotatedPackage.equals(packageName)) {
                    throw new IllegalStateException("Cant have two different applications in a single context - " + packageName + " and " + this.parsedAnnotatedPackage);
                }
                if (this.parsedAnnotatedPackage == null) {
                    this.parsedAnnotatedPackage = packageName;
                    this.parseSipApplication(appData, packageName);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("no @SipApplication annotation in " + clazz.getCanonicalName()));
            }
        }
    }

    protected void processListenerAnnotation(Class<?> clazz) {
        SipListener listener;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("scanning " + clazz.getCanonicalName() + " for listener annotations"));
        }
        if ((listener = clazz.getAnnotation(SipListener.class)) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("the following listener has been found as an annotation " + clazz.getCanonicalName()));
            }
            this.sipContext.addSipApplicationListener(clazz.getCanonicalName());
        }
    }

    protected void processSipApplicationKeyAnnotation(Class<?> clazz) throws AnnotationVerificationException {
        Method[] methods;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("scanning " + clazz.getCanonicalName() + " for sip application key annotation"));
        }
        for (Method method : methods = clazz.getMethods()) {
            if (method.getAnnotation(SipApplicationKey.class) == null) continue;
            if (!Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers())) {
                throw new AnnotationVerificationException("A method annotated with the @SipApplicationKey annotation MUST be public and static");
            }
            if (!method.getGenericReturnType().equals(String.class)) {
                throw new AnnotationVerificationException("A method annotated with the @SipApplicationKey annotation MUST return a String");
            }
            Type[] types = method.getGenericParameterTypes();
            if (types.length != 1 || !types[0].equals(SipServletRequest.class)) {
                throw new AnnotationVerificationException("A method annotated with the @SipApplicationKey annotation MUST have a single argument of type SipServletRequest");
            }
            if (this.sipAppKey != null && !this.sipAppKey.equals(method)) {
                throw new IllegalStateException("More than one SipApplicationKey annotated method is not allowed.");
            }
            this.sipAppKey = method;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("the following @SipApplicationKey annotated method has been found " + method.toString()));
            }
            this.sipContext.setSipApplicationKeyMethod(method);
        }
    }

    protected void processServletAnnotation(Class<?> clazz) {
        SipServlet servlet;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("scanning " + clazz.getCanonicalName() + " for servlet annotations"));
        }
        if ((servlet = clazz.getAnnotation(SipServlet.class)) == null) {
            return;
        }
        SipServletImpl parsedServletData = (SipServletImpl)this.sipContext.createWrapper();
        String appName = null;
        if (servlet.applicationName() == null || servlet.applicationName().equals("")) {
            Package pack = clazz.getPackage();
            String packageName = pack.getName();
            SipApplication appData = this.getApplicationAnnotation(pack);
            if (appData != null) {
                if (this.parsedAnnotatedPackage != null && !this.parsedAnnotatedPackage.equals(packageName)) {
                    throw new IllegalStateException("Cant have two different applications in a single context - " + packageName + " and " + this.parsedAnnotatedPackage);
                }
                if (this.parsedAnnotatedPackage == null) {
                    this.parsedAnnotatedPackage = packageName;
                    this.parseSipApplication(appData, packageName);
                }
                appName = this.sipContext.getName();
            }
        }
        if (appName == null) {
            appName = servlet.applicationName();
        }
        if (this.sipContext.getApplicationName() == null && appName != null) {
            this.sipContext.setApplicationName(appName);
        }
        String name = null;
        name = servlet.name() == null || servlet.name().equals("") ? clazz.getSimpleName() : servlet.name();
        if (this.sipContext.getMainServlet() == null || this.sipContext.getMainServlet().equals("")) {
            this.sipContext.setMainServlet(name);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"the following @SipServlet annotation has been found : ");
            logger.debug((Object)("Name,ServletName,DisplayName : " + name));
            logger.debug((Object)("Description : " + servlet.description()));
            logger.debug((Object)("servletClass : " + clazz.getCanonicalName()));
        }
        parsedServletData.setName(name);
        parsedServletData.setServletName(name);
        parsedServletData.setDisplayName(name);
        parsedServletData.setDescription(servlet.description());
        parsedServletData.setServletClass(clazz.getCanonicalName());
        parsedServletData.setLoadOnStartup(1);
        parsedServletData.setParent((Container)this.sipContext);
        this.sipContext.addChild(parsedServletData);
        this.applicationParsed = true;
    }

    protected void parseSipApplication(SipApplication appData, String packageName) {
        this.sipContext.setMainServlet(appData.mainServlet());
        this.sipContext.setProxyTimeout(appData.proxyTimeout());
        this.sipContext.setSipApplicationSessionTimeout(appData.sessionTimeout());
        if (appData.name() == null || appData.name().equals("")) {
            this.sipContext.setApplicationName(packageName);
        } else {
            this.sipContext.setApplicationName(appData.name());
        }
        if (appData.displayName() == null || appData.displayName().equals("")) {
            this.sipContext.setDisplayName(packageName);
        } else {
            this.sipContext.setDisplayName(appData.displayName());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"the following @SipApplication annotation has been found : ");
            logger.debug((Object)("ApplicationName : " + this.sipContext.getApplicationName()));
            logger.debug((Object)("MainServlet : " + this.sipContext.getMainServlet()));
        }
        this.sipContext.setDescription(appData.description());
        this.sipContext.setLargeIcon(appData.largeIcon());
        this.sipContext.setSmallIcon(appData.smallIcon());
        this.sipContext.setDistributable(appData.distributable());
    }

    protected SipApplication getApplicationAnnotation(Package pack) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Analyzing " + pack + " for @SipApplication annotations"));
        }
        if (pack == null) {
            return null;
        }
        SipApplication sipApp = pack.getAnnotation(SipApplication.class);
        if (sipApp != null) {
            return sipApp;
        }
        return null;
    }

    protected void processConcurrencyAnnotation(Class clazz) {
        ConcurrencyControl concurrencyControl;
        Package pack;
        if (this.sipContext.getConcurrencyControlMode() == null && (pack = clazz.getPackage()) != null && (concurrencyControl = pack.getAnnotation(ConcurrencyControl.class)) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Concurrency control annotation found " + concurrencyControl.mode()));
            }
            this.sipContext.setConcurrencyControlMode(concurrencyControl.mode());
        }
    }

    public boolean isApplicationParsed() {
        return this.applicationParsed;
    }
}

