/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.servlet.sip.annotations;

import java.beans.Introspector;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.security.AccessControlException;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.loader.ResourceEntry;
import org.apache.juli.logging.LogFactory;
import org.apache.log4j.Logger;
import org.apache.naming.JndiPermission;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.res.StringManager;

public class AnnotationsClassLoader
extends URLClassLoader
implements Lifecycle {
    private static final transient Logger log = Logger.getLogger(AnnotationsClassLoader.class);
    public static final boolean ENABLE_CLEAR_REFERENCES = Boolean.valueOf(System.getProperty("org.apache.catalina.loader.WebappClassLoader.ENABLE_CLEAR_REFERENCES", "true"));
    private static final String CLASS_FILE_SUFFIX = ".class";
    private static final String SERVICES_PREFIX = "/META-INF/services/";
    static final String[] triggers = new String[]{"javax.servlet.Servlet"};
    protected static final String[] packageTriggers = new String[0];
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.loader");
    boolean antiJARLocking = false;
    protected WebResourceRoot resources = null;
    protected Map<String, ResourceEntry> resourceEntries = new HashMap<String, ResourceEntry>();
    protected Map<String, String> notFoundResources = new HashMap<String, String>();
    protected boolean delegate = false;
    private final HashMap<String, Long> jarModificationTimes = new HashMap();
    protected long lastJarAccessed = 0L;
    protected String[] repositories = new String[0];
    protected URL[] repositoryURLs = null;
    protected File[] files = new File[0];
    protected JarFile[] jarFiles = new JarFile[0];
    protected File[] jarRealFiles = new File[0];
    protected String jarPath = null;
    protected String[] jarNames = new String[0];
    protected long[] lastModifiedDates = new long[0];
    protected String[] paths = new String[0];
    protected ArrayList permissionList = new ArrayList();
    protected File loaderDir = null;
    protected Map loaderPC = new HashMap();
    protected SecurityManager securityManager = null;
    protected ClassLoader parent = null;
    protected ClassLoader system = null;
    protected boolean started = true;
    protected boolean hasExternalRepositories = false;
    protected boolean needConvert = false;
    protected Permission allPermission = new AllPermission();

    public AnnotationsClassLoader() {
        super(new URL[0]);
        this.parent = this.getParent();
        this.system = AnnotationsClassLoader.getSystemClassLoader();
        this.securityManager = System.getSecurityManager();
        if (this.securityManager != null) {
            this.refreshPolicy();
        }
    }

    public AnnotationsClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
        this.parent = this.getParent();
        this.system = AnnotationsClassLoader.getSystemClassLoader();
        this.securityManager = System.getSecurityManager();
        if (this.securityManager != null) {
            this.refreshPolicy();
        }
    }

    public WebResourceRoot getResources() {
        return this.resources;
    }

    public void setResources(WebResourceRoot resources) {
        this.resources = resources;
    }

    public boolean getDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean delegate) {
        this.delegate = delegate;
    }

    public boolean getAntiJARLocking() {
        return this.antiJARLocking;
    }

    public void setAntiJARLocking(boolean antiJARLocking) {
        this.antiJARLocking = antiJARLocking;
    }

    public void addPermission(String path) {
        if (path == null) {
            return;
        }
        if (this.securityManager != null) {
            FilePermission permission = null;
            if (path.startsWith("jndi:") || path.startsWith("jar:jndi:")) {
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                permission = new JndiPermission(path + "*");
                this.addPermission(permission);
            } else {
                if (!path.endsWith(File.separator)) {
                    permission = new FilePermission(path, "read");
                    this.addPermission(permission);
                    path = path + File.separator;
                }
                permission = new FilePermission(path + "-", "read");
                this.addPermission(permission);
            }
        }
    }

    public void addPermission(URL url) {
        if (url != null) {
            this.addPermission(url.toString());
        }
    }

    public void addPermission(Permission permission) {
        if (this.securityManager != null && permission != null) {
            this.permissionList.add(permission);
        }
    }

    public String getJarPath() {
        return this.jarPath;
    }

    public void setJarPath(String jarPath) {
        this.jarPath = jarPath;
    }

    public void setWorkDir(File workDir) {
        this.loaderDir = new File(workDir, "loader");
    }

    protected void setParentClassLoader(ClassLoader pcl) {
        this.parent = pcl;
    }

    public void addRepository(String repository) {
        if (repository.startsWith("/WEB-INF/lib") || repository.startsWith("/WEB-INF/classes")) {
            return;
        }
        try {
            URL url = new URL(repository);
            super.addURL(url);
            this.hasExternalRepositories = true;
            this.repositoryURLs = null;
        }
        catch (MalformedURLException e) {
            IllegalArgumentException iae = new IllegalArgumentException("Invalid repository: " + repository);
            iae.initCause(e);
            throw iae;
        }
    }

    synchronized void addRepository(String repository, File file) {
        int i;
        if (repository == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("addRepository(" + repository + ")"));
        }
        String[] result = new String[this.repositories.length + 1];
        for (i = 0; i < this.repositories.length; ++i) {
            result[i] = this.repositories[i];
        }
        result[this.repositories.length] = repository;
        this.repositories = result;
        File[] result2 = new File[this.files.length + 1];
        for (i = 0; i < this.files.length; ++i) {
            result2[i] = this.files[i];
        }
        result2[this.files.length] = file;
        this.files = result2;
    }

    public void addJarDir(String dirPath) {
        File[] files;
        File dir = new File(dirPath);
        if (!dir.isDirectory()) {
            log.info((Object)("No libraries loaded from this directory: " + dir.getAbsolutePath()));
            return;
        }
        for (File file : files = dir.listFiles()) {
            if (!file.isDirectory() && file.getName().indexOf(".jar") != -1) {
                try {
                    this.addJar(file.getName(), new JarFile(file), file);
                }
                catch (IOException e) {
                    log.error((Object)("An exception occured when trying to add the following jar to the AnnotationsClassLoader : " + file.getAbsolutePath()), (Throwable)e);
                }
                continue;
            }
            log.info((Object)(file.getAbsolutePath() + " is a directory in " + dirPath + " and as such will be skipped."));
        }
    }

    synchronized void addJar(String jar, JarFile jarFile, File file) throws IOException {
        int i;
        if (jar == null) {
            return;
        }
        if (jarFile == null) {
            return;
        }
        if (file == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("addJar(" + jar + ")"));
        }
        if (this.jarPath != null && jar.startsWith(this.jarPath)) {
            String jarName = jar.substring(this.jarPath.length());
            while (jarName.startsWith("/")) {
                jarName = jarName.substring(1);
            }
            String[] result = new String[this.jarNames.length + 1];
            for (i = 0; i < this.jarNames.length; ++i) {
                result[i] = this.jarNames[i];
            }
            result[this.jarNames.length] = jarName;
            this.jarNames = result;
        }
        long lastModified = this.resources.getClassLoaderResource(jar).getLastModified();
        String[] result = new String[this.paths.length + 1];
        for (i = 0; i < this.paths.length; ++i) {
            result[i] = this.paths[i];
        }
        result[this.paths.length] = jar;
        this.paths = result;
        long[] result3 = new long[this.lastModifiedDates.length + 1];
        for (i = 0; i < this.lastModifiedDates.length; ++i) {
            result3[i] = this.lastModifiedDates[i];
        }
        result3[this.lastModifiedDates.length] = lastModified;
        this.lastModifiedDates = result3;
        if (!this.validateJarFile(file)) {
            return;
        }
        JarFile[] result2 = new JarFile[this.jarFiles.length + 1];
        for (i = 0; i < this.jarFiles.length; ++i) {
            result2[i] = this.jarFiles[i];
        }
        result2[this.jarFiles.length] = jarFile;
        this.jarFiles = result2;
        File[] result4 = new File[this.jarRealFiles.length + 1];
        for (i = 0; i < this.jarRealFiles.length; ++i) {
            result4[i] = this.jarRealFiles[i];
        }
        result4[this.jarRealFiles.length] = file;
        this.jarRealFiles = result4;
    }

    public String[] findRepositories() {
        return (String[])this.repositories.clone();
    }

    public boolean modified() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"modified()");
        }
        for (Map.Entry<String, ResourceEntry> entry : this.resourceEntries.entrySet()) {
            long cachedLastModified = entry.getValue().lastModified;
            long lastModified = this.resources.getClassLoaderResource(entry.getKey()).getLastModified();
            if (lastModified == cachedLastModified) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("webappClassLoader.resourceModified", new Object[]{entry.getKey(), new Date(cachedLastModified), new Date(lastModified)}));
            }
            return true;
        }
        WebResource[] jars = this.resources.listResources("/WEB-INF/lib");
        int jarCount = 0;
        for (WebResource jar : jars) {
            if (!jar.getName().endsWith(".jar") || !jar.isFile() || !jar.canRead()) continue;
            ++jarCount;
            Long recordedLastModified = this.jarModificationTimes.get(jar.getName());
            if (recordedLastModified == null) {
                log.info((Object)sm.getString("webappClassLoader.jarsAdded", new Object[]{this.resources.getContext().getName()}));
                return true;
            }
            if (recordedLastModified.longValue() == jar.getLastModified()) continue;
            log.info((Object)sm.getString("webappClassLoader.jarsModified", new Object[]{this.resources.getContext().getName()}));
            return true;
        }
        if (jarCount < this.jarModificationTimes.size()) {
            log.info((Object)sm.getString("webappClassLoader.jarsRemoved", new Object[]{this.resources.getContext().getName()}));
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("WebappClassLoader\r\n");
        sb.append("  delegate: ");
        sb.append(this.delegate);
        sb.append("\r\n");
        sb.append("  repositories:\r\n");
        if (this.repositories != null) {
            for (int i = 0; i < this.repositories.length; ++i) {
                sb.append("    ");
                sb.append(this.repositories[i]);
                sb.append("\r\n");
            }
        }
        if (this.parent != null) {
            sb.append("----------> Parent Classloader:\r\n");
            sb.append(this.parent.toString());
            sb.append("\r\n");
        }
        return sb.toString();
    }

    @Override
    protected void addURL(URL url) {
        super.addURL(url);
        this.hasExternalRepositories = true;
        this.repositoryURLs = null;
    }

    public Class findClass(String name) throws ClassNotFoundException {
        int i;
        if (log.isDebugEnabled()) {
            log.debug((Object)("    findClass(" + name + ")"));
        }
        if (!this.started) {
            throw new ClassNotFoundException(name);
        }
        if (this.securityManager != null && (i = name.lastIndexOf(46)) >= 0) {
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"      securityManager.checkPackageDefinition");
                }
                this.securityManager.checkPackageDefinition(name.substring(0, i));
            }
            catch (Exception se) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"      -->Exception-->ClassNotFoundException", (Throwable)se);
                }
                throw new ClassNotFoundException(name, se);
            }
        }
        Class<?> clazz = null;
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("      findClassInternal(" + name + ")"));
            }
            try {
                clazz = this.findClassInternal(name);
            }
            catch (ClassNotFoundException cnfe) {
                if (!this.hasExternalRepositories) {
                    throw cnfe;
                }
            }
            catch (AccessControlException ace) {
                throw new ClassNotFoundException(name, ace);
            }
            catch (RuntimeException e) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"      -->RuntimeException Rethrown", (Throwable)e);
                }
                throw e;
            }
            if (clazz == null && this.hasExternalRepositories) {
                try {
                    clazz = super.findClass(name);
                }
                catch (AccessControlException ace) {
                    throw new ClassNotFoundException(name, ace);
                }
                catch (RuntimeException e) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"      -->RuntimeException Rethrown", (Throwable)e);
                    }
                    throw e;
                }
            }
            if (clazz == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"    --> Returning ClassNotFoundException");
                }
                throw new ClassNotFoundException(name);
            }
        }
        catch (ClassNotFoundException e) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"    --> Passing on ClassNotFoundException");
            }
            throw e;
        }
        if (log.isTraceEnabled()) {
            log.debug((Object)("      Returning class " + clazz));
        }
        if (log.isTraceEnabled()) {
            log.debug((Object)("      Loaded by " + clazz.getClassLoader()));
        }
        return clazz;
    }

    @Override
    public URL findResource(String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("    findResource(" + name + ")"));
        }
        URL url = null;
        ResourceEntry entry = this.resourceEntries.get(name);
        if (entry == null) {
            entry = this.findResourceInternal(name, name);
        }
        if (entry != null) {
            url = entry.source;
        }
        if (url == null && this.hasExternalRepositories) {
            url = super.findResource(name);
        }
        if (log.isDebugEnabled()) {
            if (url != null) {
                log.debug((Object)("    --> Returning '" + url.toString() + "'"));
            } else {
                log.debug((Object)"    --> Resource not found, returning null");
            }
        }
        return url;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        WebResource[] webResources;
        if (log.isDebugEnabled()) {
            log.debug((Object)("    findResources(" + name + ")"));
        }
        this.checkStateForResourceLoading(name);
        LinkedHashSet<URL> result = new LinkedHashSet<URL>();
        String path = this.nameToPath(name);
        for (WebResource webResource : webResources = this.resources.getClassLoaderResources(path)) {
            if (!webResource.exists()) continue;
            result.add(webResource.getURL());
        }
        if (this.hasExternalRepositories) {
            Enumeration<URL> otherResourcePaths = super.findResources(name);
            while (otherResourcePaths.hasMoreElements()) {
                result.add(otherResourcePaths.nextElement());
            }
        }
        return Collections.enumeration(result);
    }

    private String binaryNameToPath(String binaryName, boolean withLeadingSlash) {
        StringBuilder path = new StringBuilder(7 + binaryName.length());
        if (withLeadingSlash) {
            path.append('/');
        }
        path.append(binaryName.replace('.', '/'));
        path.append(CLASS_FILE_SUFFIX);
        return path.toString();
    }

    private String nameToPath(String name) {
        if (name.startsWith("/")) {
            return name;
        }
        StringBuilder path = new StringBuilder(1 + name.length());
        path.append('/');
        path.append(name);
        return path.toString();
    }

    @Override
    public URL getResource(String name) {
        ClassLoader loader;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getResource(" + name + ")"));
        }
        URL url = null;
        if (this.delegate) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Delegating to parent classloader " + this.parent));
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            if ((url = loader.getResource(name)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  --> Returning '" + url.toString() + "'"));
                }
                return url;
            }
        }
        if ((url = this.findResource(name)) != null) {
            if (this.antiJARLocking) {
                ResourceEntry entry = this.resourceEntries.get(name);
                try {
                    String repository = entry.codeBase.toString();
                    if (repository.endsWith(".jar") && !name.endsWith(CLASS_FILE_SUFFIX)) {
                        File resourceFile = new File(this.loaderDir, name);
                        url = this.getURI(resourceFile);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("  --> Returning '" + url.toString() + "'"));
            }
            return url;
        }
        if (!this.delegate) {
            loader = this.parent;
            if (loader == null) {
                loader = this.system;
            }
            if ((url = loader.getResource(name)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("  --> Returning '" + url.toString() + "'"));
                }
                return url;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"  --> Resource not found, returning null");
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        URL url;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getResourceAsStream(" + name + ")"));
        }
        InputStream stream = null;
        stream = this.findLoadedResource(name);
        if (stream != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  --> Returning stream from cache");
            }
            return stream;
        }
        if (this.delegate) {
            ClassLoader loader;
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Delegating to parent classloader " + this.parent));
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            if ((stream = loader.getResourceAsStream(name)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"  --> Returning stream from parent");
                }
                return stream;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"  Searching local repositories");
        }
        if ((url = this.findResource(name)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  --> Returning stream from local");
            }
            stream = this.findLoadedResource(name);
            try {
                if (this.hasExternalRepositories && stream == null) {
                    stream = url.openStream();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (stream != null) {
                return stream;
            }
        }
        if (!this.delegate) {
            ClassLoader loader;
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Delegating to parent classloader unconditionally " + this.parent));
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            if ((stream = loader.getResourceAsStream(name)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"  --> Returning stream from parent");
                }
                return stream;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"  --> Resource not found, returning null");
        }
        return null;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        ClassLoader loader;
        boolean delegateLoad;
        int i;
        if (log.isDebugEnabled()) {
            log.debug((Object)("loadClass(" + name + ", " + resolve + ")"));
        }
        Class<?> clazz = null;
        clazz = this.findLoadedClass0(name);
        if (clazz != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  Returning class from cache");
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        clazz = this.findLoadedClass(name);
        if (clazz != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"  Returning class from cache");
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        try {
            clazz = this.system.loadClass(name);
            if (clazz != null) {
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (this.securityManager != null && (i = name.lastIndexOf(46)) >= 0) {
            try {
                this.securityManager.checkPackageAccess(name.substring(0, i));
            }
            catch (SecurityException se) {
                String error = "Security Violation, attempt to use Restricted Class: " + name;
                log.info((Object)error, (Throwable)se);
                throw new ClassNotFoundException(error, se);
            }
        }
        boolean bl = delegateLoad = this.delegate || this.filter(name);
        if (delegateLoad) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Delegating to parent classloader1 " + this.parent));
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            try {
                clazz = loader.loadClass(name);
                if (clazz != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"  Loading class from parent");
                    }
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"  Searching local repositories");
        }
        try {
            clazz = this.findClass(name);
            if (clazz != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"  Loading class from local repository");
                }
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (!delegateLoad) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("  Delegating to parent classloader at end: " + this.parent));
            }
            if ((loader = this.parent) == null) {
                loader = this.system;
            }
            try {
                clazz = loader.loadClass(name);
                if (clazz != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"  Loading class from parent");
                    }
                    if (resolve) {
                        this.resolveClass(clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        String codeUrl = codeSource.getLocation().toString();
        PermissionCollection pc = (PermissionCollection)this.loaderPC.get(codeUrl);
        if (pc == null && (pc = super.getPermissions(codeSource)) != null) {
            for (Permission p : this.permissionList) {
                pc.add(p);
            }
            this.loaderPC.put(codeUrl, pc);
        }
        return pc;
    }

    @Override
    public URL[] getURLs() {
        if (this.repositoryURLs != null) {
            return this.repositoryURLs;
        }
        URL[] external = super.getURLs();
        int filesLength = this.files.length;
        int jarFilesLength = this.jarRealFiles.length;
        int length = filesLength + jarFilesLength + external.length;
        try {
            URL[] urls = new URL[length];
            for (int i = 0; i < length; ++i) {
                urls[i] = i < filesLength ? this.getURL(this.files[i], true) : (i < filesLength + jarFilesLength ? this.getURL(this.jarRealFiles[i - filesLength], true) : external[i - filesLength - jarFilesLength]);
            }
            this.repositoryURLs = urls;
        }
        catch (MalformedURLException e) {
            this.repositoryURLs = new URL[0];
        }
        return this.repositoryURLs;
    }

    public void addLifecycleListener(LifecycleListener listener) {
    }

    public LifecycleListener[] findLifecycleListeners() {
        return new LifecycleListener[0];
    }

    public void removeLifecycleListener(LifecycleListener listener) {
    }

    public void start() throws LifecycleException {
        String encoding = null;
        try {
            encoding = System.getProperty("file.encoding");
        }
        catch (SecurityException e) {
            return;
        }
        if (encoding.indexOf("EBCDIC") != -1) {
            this.needConvert = true;
        }
    }

    public void stop() throws LifecycleException {
        int i;
        this.clearReferences();
        int length = this.files.length;
        for (i = 0; i < length; ++i) {
            this.files[i] = null;
        }
        length = this.jarFiles.length;
        for (i = 0; i < length; ++i) {
            try {
                if (this.jarFiles[i] != null) {
                    this.jarFiles[i].close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.jarFiles[i] = null;
        }
        this.notFoundResources.clear();
        this.resourceEntries.clear();
        this.resources = null;
        this.repositories = null;
        this.repositoryURLs = null;
        this.files = null;
        this.jarFiles = null;
        this.jarRealFiles = null;
        this.jarPath = null;
        this.jarNames = null;
        this.lastModifiedDates = null;
        this.paths = null;
        this.hasExternalRepositories = false;
        this.parent = null;
        this.permissionList.clear();
        this.loaderPC.clear();
        if (this.loaderDir != null) {
            AnnotationsClassLoader.deleteDir(this.loaderDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void closeJARs(boolean force) {
        if (this.jarFiles.length <= 0) return;
        JarFile[] jarFileArray = this.jarFiles;
        synchronized (this.jarFiles) {
            if (!force && System.currentTimeMillis() <= this.lastJarAccessed + 90000L) return;
            for (int i = 0; i < this.jarFiles.length; ++i) {
                try {
                    if (this.jarFiles[i] == null) continue;
                    this.jarFiles[i].close();
                    this.jarFiles[i] = null;
                    continue;
                }
                catch (IOException e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"Failed to close JAR", (Throwable)e);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void clearReferences() {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            if (driver.getClass().getClassLoader() != this) continue;
            try {
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException e) {
                log.warn((Object)"SQL driver deregistration failed", (Throwable)e);
            }
        }
        if (ENABLE_CLEAR_REFERENCES) {
            for (ResourceEntry entry : ((HashMap)((HashMap)this.resourceEntries).clone()).values()) {
                if (entry.loadedClass == null) continue;
                Class clazz = entry.loadedClass;
                try {
                    Field[] fields = clazz.getDeclaredFields();
                    for (int i = 0; i < fields.length; ++i) {
                        Field field = fields[i];
                        int mods = field.getModifiers();
                        if (field.getType().isPrimitive() || field.getName().indexOf("$") != -1 || !Modifier.isStatic(mods)) continue;
                        try {
                            field.setAccessible(true);
                            if (Modifier.isFinal(mods)) {
                                if (field.getType().getName().startsWith("java.") || field.getType().getName().startsWith("javax.")) continue;
                                this.nullInstance(field.get(null));
                                continue;
                            }
                            field.set(null, null);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("Set field " + field.getName() + " to null in class " + clazz.getName()));
                            continue;
                        }
                        catch (Throwable t) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)("Could not set field " + field.getName() + " to null in class " + clazz.getName()), t);
                        }
                    }
                }
                catch (Throwable t) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Could not clean fields for class " + clazz.getName()), t);
                }
            }
        }
        IntrospectionUtils.clear();
        LogFactory.release((ClassLoader)this);
        Introspector.flushCaches();
    }

    protected void nullInstance(Object instance) {
        if (instance == null) {
            return;
        }
        Field[] fields = instance.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            int mods = field.getModifiers();
            if (field.getType().isPrimitive() || field.getName().indexOf("$") != -1) continue;
            try {
                Object value;
                field.setAccessible(true);
                if (Modifier.isStatic(mods) && Modifier.isFinal(mods) || null == (value = field.get(instance))) continue;
                Class<?> valueClass = value.getClass();
                if (!this.loadedByThisOrChild(valueClass)) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Not setting field " + field.getName() + " to null in object of class " + instance.getClass().getName() + " because the referenced object was of type " + valueClass.getName() + " which was not loaded by this WebappClassLoader."));
                    continue;
                }
                field.set(instance, null);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Set field " + field.getName() + " to null in class " + instance.getClass().getName()));
                continue;
            }
            catch (Throwable t) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Could not set field " + field.getName() + " to null in object instance of class " + instance.getClass().getName()), t);
            }
        }
    }

    protected boolean loadedByThisOrChild(Class clazz) {
        boolean result = false;
        for (ClassLoader classLoader = clazz.getClassLoader(); null != classLoader; classLoader = classLoader.getParent()) {
            if (!classLoader.equals(this)) continue;
            result = true;
            break;
        }
        return result;
    }

    protected boolean openJARs() {
        if (this.started && this.jarFiles.length > 0) {
            this.lastJarAccessed = System.currentTimeMillis();
            if (this.jarFiles[0] == null) {
                for (int i = 0; i < this.jarFiles.length; ++i) {
                    try {
                        this.jarFiles[i] = new JarFile(this.jarRealFiles[i]);
                        continue;
                    }
                    catch (IOException e) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Failed to open JAR", (Throwable)e);
                        }
                        return false;
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class findClassInternal(String name) throws ClassNotFoundException {
        if (!this.validate(name)) {
            throw new ClassNotFoundException(name);
        }
        String tempPath = name.replace('.', '/');
        String classPath = tempPath + CLASS_FILE_SUFFIX;
        ResourceEntry entry = null;
        entry = this.findResourceInternal(name, classPath);
        if (entry == null) {
            throw new ClassNotFoundException(name);
        }
        Class<?> clazz = entry.loadedClass;
        if (clazz != null) {
            return clazz;
        }
        AnnotationsClassLoader annotationsClassLoader = this;
        synchronized (annotationsClassLoader) {
            if (entry.binaryContent == null && entry.loadedClass == null) {
                throw new ClassNotFoundException(name);
            }
            String packageName = null;
            int pos = name.lastIndexOf(46);
            if (pos != -1) {
                packageName = name.substring(0, pos);
            }
            Package pkg = null;
            if (packageName != null && (pkg = this.getPackage(packageName)) == null) {
                try {
                    if (entry.manifest == null) {
                        this.definePackage(packageName, null, null, null, null, null, null, null);
                    } else {
                        this.definePackage(packageName, entry.manifest, entry.codeBase);
                    }
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
                pkg = this.getPackage(packageName);
            }
            if (this.securityManager != null && pkg != null) {
                boolean sealCheck = true;
                if (pkg.isSealed()) {
                    sealCheck = pkg.isSealed(entry.codeBase);
                } else {
                    boolean bl = sealCheck = entry.manifest == null || !this.isPackageSealed(packageName, entry.manifest);
                }
                if (!sealCheck) {
                    throw new SecurityException("Sealing violation loading " + name + " : Package " + packageName + " is sealed.");
                }
            }
            if (entry.loadedClass == null) {
                entry.loadedClass = clazz = this.defineClass(name, entry.binaryContent, 0, entry.binaryContent.length, new CodeSource(entry.codeBase, entry.certificates));
                entry.binaryContent = null;
                entry.source = null;
                entry.codeBase = null;
                entry.manifest = null;
                entry.certificates = null;
            } else {
                clazz = entry.loadedClass;
            }
        }
        return clazz;
    }

    protected ResourceEntry findResourceInternal(File file, String path) {
        ResourceEntry entry = new ResourceEntry();
        try {
            entry.source = this.getURI(new File(file, path));
            entry.codeBase = this.getURL(new File(file, path), false);
        }
        catch (MalformedURLException e) {
            return null;
        }
        return entry;
    }

    protected void checkStateForClassLoading(String className) throws ClassNotFoundException {
        try {
            this.checkStateForResourceLoading(className);
        }
        catch (IllegalStateException ise) {
            ClassNotFoundException cnfe = new ClassNotFoundException();
            cnfe.initCause(ise);
            throw cnfe;
        }
    }

    protected void checkStateForResourceLoading(String resource) throws IllegalStateException {
        if (!this.started) {
            String msg = sm.getString("webappClassLoader.stopped", new Object[]{resource});
            IllegalStateException ise = new IllegalStateException(msg);
            log.info((Object)msg, (Throwable)ise);
            throw ise;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceEntry findResourceInternal(String name, String path) {
        byte[] binaryContent;
        this.checkStateForResourceLoading(name);
        if (name == null || path == null) {
            return null;
        }
        ResourceEntry entry = this.resourceEntries.get(path);
        if (entry != null) {
            return entry;
        }
        boolean isClassResource = path.endsWith(CLASS_FILE_SUFFIX);
        boolean isCacheable = isClassResource;
        if (!isCacheable) {
            isCacheable = path.startsWith(SERVICES_PREFIX);
        }
        WebResource resource = null;
        boolean fileNeedConvert = false;
        resource = this.resources.getClassLoaderResource(path);
        if (!resource.exists()) {
            return null;
        }
        entry = new ResourceEntry();
        entry.source = resource.getURL();
        entry.codeBase = resource.getCodeBase();
        entry.lastModified = resource.getLastModified();
        if (this.needConvert && path.endsWith(".properties")) {
            fileNeedConvert = true;
        }
        if ((isCacheable || fileNeedConvert) && (binaryContent = resource.getContent()) != null) {
            if (fileNeedConvert) {
                String str = new String(binaryContent);
                try {
                    binaryContent = str.getBytes(StandardCharsets.UTF_8);
                }
                catch (Exception e) {
                    return null;
                }
            }
            entry.binaryContent = binaryContent;
            entry.certificates = resource.getCertificates();
        }
        entry.manifest = resource.getManifest();
        Map<String, ResourceEntry> map = this.resourceEntries;
        synchronized (map) {
            ResourceEntry entry2 = this.resourceEntries.get(path);
            if (entry2 == null) {
                this.resourceEntries.put(path, entry);
            } else {
                entry = entry2;
            }
        }
        return entry;
    }

    protected boolean isPackageSealed(String name, Manifest man) {
        String path = name.replace('.', '/') + '/';
        Attributes attr = man.getAttributes(path);
        String sealed = null;
        if (attr != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attr = man.getMainAttributes()) != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    protected InputStream findLoadedResource(String name) {
        ResourceEntry entry = this.resourceEntries.get(name);
        if (entry != null && entry.binaryContent != null) {
            return new ByteArrayInputStream(entry.binaryContent);
        }
        return null;
    }

    protected Class findLoadedClass0(String name) {
        ResourceEntry entry = this.resourceEntries.get(name);
        if (entry != null) {
            return entry.loadedClass;
        }
        return null;
    }

    protected void refreshPolicy() {
        try {
            Policy policy = Policy.getPolicy();
            policy.refresh();
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }

    protected boolean filter(String name) {
        if (name == null) {
            return false;
        }
        String packageName = null;
        int pos = name.lastIndexOf(46);
        if (pos == -1) {
            return false;
        }
        packageName = name.substring(0, pos);
        for (int i = 0; i < packageTriggers.length; ++i) {
            if (!packageName.startsWith(packageTriggers[i])) continue;
            return true;
        }
        return false;
    }

    protected boolean validate(String name) {
        if (name == null) {
            return false;
        }
        return !name.startsWith("java.");
    }

    protected boolean validateJarFile(File jarfile) throws IOException {
        if (triggers == null) {
            return true;
        }
        JarFile jarFile = new JarFile(jarfile);
        for (int i = 0; i < triggers.length; ++i) {
            JarEntry jarEntry;
            Class<?> clazz = null;
            try {
                clazz = this.parent != null ? this.parent.loadClass(triggers[i]) : Class.forName(triggers[i]);
            }
            catch (Throwable t) {
                clazz = null;
            }
            if (clazz == null) continue;
            String name = triggers[i].replace('.', '/') + CLASS_FILE_SUFFIX;
            if (log.isDebugEnabled()) {
                log.debug((Object)(" Checking for " + name));
            }
            if ((jarEntry = jarFile.getJarEntry(name)) == null) continue;
            log.info((Object)("validateJarFile(" + jarfile + ") - jar not loaded. See Servlet Spec 2.3, " + "section 9.7.2. Offending class: " + name));
            jarFile.close();
            return false;
        }
        jarFile.close();
        return true;
    }

    protected URL getURL(File file, boolean encoded) throws MalformedURLException {
        File realFile = file;
        try {
            realFile = realFile.getCanonicalFile();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (encoded) {
            return this.getURI(realFile);
        }
        return realFile.toURL();
    }

    protected URL getURI(File file) throws MalformedURLException {
        File realFile = file;
        try {
            realFile = realFile.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return realFile.toURI().toURL();
    }

    protected static void deleteDir(File dir) {
        String[] files = dir.list();
        if (files == null) {
            files = new String[]{};
        }
        for (int i = 0; i < files.length; ++i) {
            File file = new File(dir, files[i]);
            if (file.isDirectory()) {
                AnnotationsClassLoader.deleteDir(file);
                continue;
            }
            try {
                file.delete();
                continue;
            }
            catch (SecurityException se) {
                log.error((Object)("The file " + file.getAbsolutePath() + " couldn't be deleted"));
            }
        }
        try {
            dir.delete();
        }
        catch (SecurityException se) {
            log.error((Object)("The directory " + dir.getAbsolutePath() + " couldn't be deleted"));
        }
    }

    public void init() throws LifecycleException {
        throw new UnsupportedOperationException();
    }

    public void destroy() throws LifecycleException {
        throw new UnsupportedOperationException();
    }

    public LifecycleState getState() {
        throw new UnsupportedOperationException();
    }

    public String getStateName() {
        throw new UnsupportedOperationException();
    }

    protected class PrivilegedFindResource
    implements PrivilegedAction<Object> {
        protected File file;
        protected String path;

        PrivilegedFindResource(File file, String path) {
            this.file = file;
            this.path = path;
        }

        @Override
        public Object run() {
            return AnnotationsClassLoader.this.findResourceInternal(this.file, this.path);
        }
    }
}

