/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.rf;

import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.rf.RfAvpFactory;
import net.java.slee.resource.diameter.rf.RfMessageFactory;
import net.java.slee.resource.diameter.rf.RfSessionActivity;
import org.jdiameter.api.Answer;
import org.jdiameter.api.EventListener;
import org.jdiameter.api.Message;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.app.AppSession;
import org.jdiameter.api.app.StateChangeListener;
import org.mobicents.slee.resource.diameter.base.DiameterActivityImpl;
import org.mobicents.slee.resource.diameter.base.events.ErrorAnswerImpl;
import org.mobicents.slee.resource.diameter.rf.events.RfAccountingRequestImpl;

public abstract class RfSessionActivityImpl
extends DiameterActivityImpl
implements RfSessionActivity,
StateChangeListener<AppSession> {
    private static final long serialVersionUID = 4602851199202393775L;
    protected RfMessageFactory rfMessageFactory;

    public RfSessionActivityImpl(RfMessageFactory rfMessageFactory, RfAvpFactory rfAvpFactory, Session session, EventListener<Request, Answer> raEventListener, DiameterIdentity destinationHost, DiameterIdentity destinationRealm) {
        super(rfMessageFactory.getBaseMessageFactory(), rfAvpFactory.getBaseFactory(), session, raEventListener, destinationHost, destinationRealm);
        this.rfMessageFactory = rfMessageFactory;
    }

    public DiameterMessage sendSyncMessage(DiameterMessage message) {
        ErrorAnswerImpl answer = null;
        Message receivedMessage = this.doSendMessage(message);
        if (receivedMessage != null) {
            if (!receivedMessage.isRequest()) {
                if (receivedMessage.isError()) {
                    answer = new ErrorAnswerImpl(receivedMessage);
                } else {
                    switch (receivedMessage.getCommandCode()) {
                        case 271: {
                            answer = new RfAccountingRequestImpl(receivedMessage);
                            break;
                        }
                        default: {
                            logger.error((Object)("Received an unknown type of Message for Rf Activity: " + receivedMessage));
                            break;
                        }
                    }
                }
            } else {
                logger.error((Object)"Received a REQUEST message when expecting an ANSWER.");
            }
        } else {
            logger.debug((Object)"No answer received. Returning null.");
        }
        return answer;
    }
}

