/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.rf;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.slee.EventTypeID;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.resource.FireableEventType;
import org.jdiameter.api.Message;

public class EventIDCache {
    private static final String RF_PACKAGE_PREFIX = "net.java.slee.resource.diameter.rf.events.";
    public static Map<Integer, String> eventNames = new ConcurrentHashMap<Integer, String>();
    private static final String VENDOR = "java.net";
    private static final String VERSION = "0.8";
    private ConcurrentHashMap<String, FireableEventType> eventIds = new ConcurrentHashMap();

    public FireableEventType getEventId(EventLookupFacility eventLookupFacility, Message message) {
        FireableEventType eventID = null;
        if (!message.isError()) {
            int commandCode = message.getCommandCode();
            boolean isRequest = message.isRequest();
            String eventName = eventNames.get(commandCode);
            if (eventName != null) {
                eventID = this.getEventId(eventLookupFacility, eventName + (isRequest ? "Request" : "Answer"));
            }
        }
        return eventID;
    }

    private FireableEventType getEventId(EventLookupFacility eventLookupFacility, String eventName) {
        FireableEventType eventType = this.eventIds.get(eventName);
        if (eventType == null) {
            try {
                eventType = eventLookupFacility.getFireableEventType(new EventTypeID(eventName, VENDOR, VERSION));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (eventType != null) {
                this.eventIds.put(eventName, eventType);
            }
        }
        return eventType;
    }

    static {
        HashMap<Integer, String> eventsTemp = new HashMap<Integer, String>();
        eventsTemp.put(271, "net.java.slee.resource.diameter.rf.events.RfAccounting");
        eventNames = Collections.unmodifiableMap(eventsTemp);
    }
}

