/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.resource.diameter.rf;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import javax.slee.Address;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityFlags;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.EventFlags;
import javax.slee.resource.FailureReason;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.InvalidConfigurationException;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ReceivableService;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceAdaptorContext;
import javax.slee.resource.SleeEndpoint;
import javax.transaction.Transaction;
import net.java.slee.resource.diameter.Validator;
import net.java.slee.resource.diameter.base.CreateActivityException;
import net.java.slee.resource.diameter.base.DiameterActivity;
import net.java.slee.resource.diameter.base.DiameterAvpFactory;
import net.java.slee.resource.diameter.base.DiameterException;
import net.java.slee.resource.diameter.base.DiameterMessageFactory;
import net.java.slee.resource.diameter.base.events.DiameterMessage;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.rf.RfAvpFactory;
import net.java.slee.resource.diameter.rf.RfClientSessionActivity;
import net.java.slee.resource.diameter.rf.RfMessageFactory;
import net.java.slee.resource.diameter.rf.RfProvider;
import net.java.slee.resource.diameter.rf.RfServerSessionActivity;
import net.java.slee.resource.diameter.rf.events.RfAccountingAnswer;
import net.java.slee.resource.diameter.rf.events.RfAccountingRequest;
import org.jboss.mx.util.MBeanServerLocator;
import org.jdiameter.api.Answer;
import org.jdiameter.api.ApplicationId;
import org.jdiameter.api.Avp;
import org.jdiameter.api.AvpDataException;
import org.jdiameter.api.AvpSet;
import org.jdiameter.api.IllegalDiameterStateException;
import org.jdiameter.api.InternalException;
import org.jdiameter.api.Message;
import org.jdiameter.api.Peer;
import org.jdiameter.api.PeerTable;
import org.jdiameter.api.Request;
import org.jdiameter.api.Session;
import org.jdiameter.api.SessionFactory;
import org.jdiameter.api.Stack;
import org.jdiameter.api.app.StateChangeListener;
import org.jdiameter.api.auth.ClientAuthSession;
import org.jdiameter.api.auth.ServerAuthSession;
import org.jdiameter.api.rf.ClientRfSession;
import org.jdiameter.api.rf.ServerRfSession;
import org.jdiameter.client.api.ISessionFactory;
import org.jdiameter.client.impl.app.rf.ClientRfSessionImpl;
import org.jdiameter.common.api.app.IAppSessionFactory;
import org.jdiameter.common.api.app.rf.IRfSessionFactory;
import org.jdiameter.server.impl.app.rf.ServerRfSessionImpl;
import org.mobicents.diameter.stack.DiameterListener;
import org.mobicents.diameter.stack.DiameterStackMultiplexerMBean;
import org.mobicents.slee.resource.cluster.FaultTolerantResourceAdaptor;
import org.mobicents.slee.resource.cluster.FaultTolerantResourceAdaptorContext;
import org.mobicents.slee.resource.cluster.ReplicatedData;
import org.mobicents.slee.resource.diameter.AbstractClusteredDiameterActivityManagement;
import org.mobicents.slee.resource.diameter.DiameterActivityManagement;
import org.mobicents.slee.resource.diameter.LocalDiameterActivityManagement;
import org.mobicents.slee.resource.diameter.ValidatorImpl;
import org.mobicents.slee.resource.diameter.base.DiameterActivityHandle;
import org.mobicents.slee.resource.diameter.base.DiameterActivityImpl;
import org.mobicents.slee.resource.diameter.base.DiameterAvpFactoryImpl;
import org.mobicents.slee.resource.diameter.base.DiameterBaseMarshaler;
import org.mobicents.slee.resource.diameter.base.DiameterMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.base.EventIDFilter;
import org.mobicents.slee.resource.diameter.base.events.DiameterMessageImpl;
import org.mobicents.slee.resource.diameter.base.events.ErrorAnswerImpl;
import org.mobicents.slee.resource.diameter.base.events.ExtensionDiameterMessageImpl;
import org.mobicents.slee.resource.diameter.base.handlers.DiameterRAInterface;
import org.mobicents.slee.resource.diameter.rf.EventIDCache;
import org.mobicents.slee.resource.diameter.rf.RfAvpFactoryImpl;
import org.mobicents.slee.resource.diameter.rf.RfClientSessionActivityImpl;
import org.mobicents.slee.resource.diameter.rf.RfMessageFactoryImpl;
import org.mobicents.slee.resource.diameter.rf.RfServerSessionActivityImpl;
import org.mobicents.slee.resource.diameter.rf.events.RfAccountingAnswerImpl;
import org.mobicents.slee.resource.diameter.rf.events.RfAccountingRequestImpl;
import org.mobicents.slee.resource.diameter.rf.handlers.RfSessionFactory;

public class DiameterRfResourceAdaptor
implements ResourceAdaptor,
DiameterListener,
DiameterRAInterface,
FaultTolerantResourceAdaptor<String, DiameterActivity> {
    private static final long serialVersionUID = 1L;
    private static final String ACCT_APPLICATION_IDS = "acctApplicationIds";
    private List<ApplicationId> acctApplicationIds;
    public final EventIDCache eventIdCache = new EventIDCache();
    private final EventIDFilter eventIDFilter = new EventIDFilter();
    private ResourceAdaptorContext raContext;
    private FaultTolerantResourceAdaptorContext<String, DiameterActivity> ftRAContext;
    protected DiameterBaseMarshaler marshaler = new DiameterBaseMarshaler();
    private transient SleeEndpoint sleeEndpoint = null;
    private Tracer tracer;
    private Stack stack;
    private ObjectName diameterMultiplexerObjectName = null;
    private DiameterStackMultiplexerMBean diameterMux = null;
    private long activityRemoveDelay = 30000L;
    private DiameterMessageFactoryImpl baseMessageFactory;
    private DiameterAvpFactoryImpl baseAvpFactory;
    private RfMessageFactoryImpl rfMessageFactory;
    private RfAvpFactory rfAvpFactory;
    private SessionFactory sessionFactory = null;
    private IRfSessionFactory rfSessionFactory;
    private transient EventLookupFacility eventLookup = null;
    private transient DiameterActivityManagement activities;
    private RfProviderImpl raProvider = null;
    private static final int EVENT_FLAGS = DiameterRfResourceAdaptor.getEventFlags();
    private static final int DEFAULT_ACTIVITY_FLAGS = 2;
    private static final int MARSHALABLE_ACTIVITY_FLAGS = ActivityFlags.setSleeMayMarshal((int)2);

    private static int getEventFlags() {
        int eventFlags = 128;
        eventFlags = EventFlags.setRequestProcessingFailedCallback((int)eventFlags);
        eventFlags = EventFlags.setRequestProcessingSuccessfulCallback((int)eventFlags);
        return eventFlags;
    }

    public void setResourceAdaptorContext(ResourceAdaptorContext context) {
        this.raContext = context;
        this.tracer = context.getTracer("DiameterRfResourceAdaptor");
        this.sleeEndpoint = context.getSleeEndpoint();
        this.eventLookup = context.getEventLookupFacility();
        this.raProvider = new RfProviderImpl(this);
    }

    public void unsetResourceAdaptorContext() {
        this.raContext = null;
        this.tracer = null;
        this.sleeEndpoint = null;
        this.eventLookup = null;
        this.raProvider = null;
    }

    public void setFaultTolerantResourceAdaptorContext(FaultTolerantResourceAdaptorContext<String, DiameterActivity> ctx) {
        this.ftRAContext = ctx;
    }

    public void unsetFaultTolerantResourceAdaptorContext() {
        this.ftRAContext = null;
    }

    public void dataRemoved(String arg0) {
        this.activities.remove(this.getActivityHandle(arg0));
    }

    public void failOver(String arg0) {
        throw new UnsupportedOperationException();
    }

    public void raActive() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Rf RA :: raActive.");
        }
        try {
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Activating Diameter Rf RA Entity");
            }
            this.diameterMultiplexerObjectName = new ObjectName("diameter.mobicents:service=DiameterStackMultiplexer");
            Object object = null;
            if (ManagementFactory.getPlatformMBeanServer().isRegistered(this.diameterMultiplexerObjectName)) {
                object = ManagementFactory.getPlatformMBeanServer().invoke(this.diameterMultiplexerObjectName, "getMultiplexerMBean", new Object[0], new String[0]);
                if (this.tracer.isInfoEnabled()) {
                    this.tracer.info("Trying to get via Platform MBeanServer: " + this.diameterMultiplexerObjectName + ", object: " + object);
                }
            } else {
                object = MBeanServerLocator.locateJBoss().invoke(this.diameterMultiplexerObjectName, "getMultiplexerMBean", new Object[0], new String[0]);
                if (this.tracer.isInfoEnabled()) {
                    this.tracer.info("Trying to get via JBoss MBeanServer: " + this.diameterMultiplexerObjectName + ", object: " + object);
                }
            }
            if (object != null && object instanceof DiameterStackMultiplexerMBean) {
                this.diameterMux = (DiameterStackMultiplexerMBean)object;
            }
            this.initStack();
            this.initActivitiesMgmt();
            this.baseAvpFactory = new DiameterAvpFactoryImpl();
            this.baseMessageFactory = new DiameterMessageFactoryImpl(this.stack);
            this.rfAvpFactory = new RfAvpFactoryImpl();
            this.rfMessageFactory = new RfMessageFactoryImpl((DiameterMessageFactory)this.baseMessageFactory, null, this.stack);
            ApplicationId firstAppId = this.acctApplicationIds.get(0);
            this.rfMessageFactory.setApplicationId(firstAppId.getVendorId(), firstAppId.getAcctAppId());
            this.sessionFactory = this.stack.getSessionFactory();
            this.rfSessionFactory = new RfSessionFactory(this, this.sessionFactory);
            ((ISessionFactory)this.sessionFactory).registerAppFacory(ServerRfSession.class, (IAppSessionFactory)this.rfSessionFactory);
            ((ISessionFactory)this.sessionFactory).registerAppFacory(ClientRfSession.class, (IAppSessionFactory)this.rfSessionFactory);
        }
        catch (Exception e) {
            this.tracer.severe("Error Activating Diameter Rf RA Entity", (Throwable)e);
        }
    }

    public void raStopping() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Rf RA :: raStopping.");
        }
        try {
            this.diameterMux.unregisterListener((DiameterListener)this);
        }
        catch (Exception e) {
            this.tracer.severe("Failed to unregister Rf RA from Diameter Mux.", (Throwable)e);
        }
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter Rf RA :: raStopping completed.");
        }
    }

    public void raInactive() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Rf RA :: raInactive.");
        }
        this.activities = null;
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter Rf RA :: raInactive completed.");
        }
    }

    public void raConfigure(ConfigProperties properties) {
        this.parseApplicationIds((String)properties.getProperty(ACCT_APPLICATION_IDS).getValue());
    }

    private void parseApplicationIds(String appIdsStr) {
        if (appIdsStr != null) {
            appIdsStr = appIdsStr.replaceAll(" ", "");
            String[] appIdsStrings = appIdsStr.split(",");
            this.acctApplicationIds = new ArrayList<ApplicationId>(appIdsStrings.length);
            for (String appId : appIdsStrings) {
                String[] vendorAndAppId = appId.split(":");
                this.acctApplicationIds.add(ApplicationId.createByAccAppId((long)Long.valueOf(vendorAndAppId[0]), (long)Long.valueOf(vendorAndAppId[1])));
            }
        }
    }

    public void raUnconfigure() {
        this.activities = null;
        this.raContext = null;
        this.eventLookup = null;
        this.raProvider = null;
        this.sleeEndpoint = null;
        this.stack = null;
    }

    public void raVerifyConfiguration(ConfigProperties properties) throws InvalidConfigurationException {
    }

    public void raConfigurationUpdate(ConfigProperties properties) {
    }

    public Object getResourceAdaptorInterface(String className) {
        return this.raProvider;
    }

    public Marshaler getMarshaler() {
        return this.marshaler;
    }

    public void serviceActive(ReceivableService serviceInfo) {
        this.eventIDFilter.serviceActive(serviceInfo);
    }

    public void serviceStopping(ReceivableService serviceInfo) {
        this.eventIDFilter.serviceStopping(serviceInfo);
    }

    public void serviceInactive(ReceivableService serviceInfo) {
        this.eventIDFilter.serviceInactive(serviceInfo);
    }

    public void queryLiveness(ActivityHandle handle) {
        this.tracer.info("Diameter Rf RA :: queryLiveness :: handle[" + handle + "].");
        if (!(handle instanceof DiameterActivityHandle)) {
            return;
        }
        DiameterActivityImpl activity = (DiameterActivityImpl)this.activities.get((DiameterActivityHandle)handle);
        if (activity != null && !activity.isValid()) {
            try {
                this.sleeEndpoint.endActivity(handle);
            }
            catch (Exception e) {
                this.tracer.severe("Failure ending non-live activity.", (Throwable)e);
            }
        }
    }

    public Object getActivity(ActivityHandle handle) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Rf RA :: getActivity :: handle[" + handle + "].");
        }
        if (!(handle instanceof DiameterActivityHandle)) {
            return null;
        }
        return this.activities.get((DiameterActivityHandle)handle);
    }

    public ActivityHandle getActivityHandle(Object activity) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Rf RA :: getActivityHandle :: activity[" + activity + "].");
        }
        if (!(activity instanceof DiameterActivity)) {
            return null;
        }
        DiameterActivityImpl inActivity = (DiameterActivityImpl)activity;
        return inActivity.getActivityHandle();
    }

    public void administrativeRemove(ActivityHandle handle) {
    }

    public void eventProcessingFailed(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags, FailureReason reason) {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter Rf RA :: eventProcessingFailed :: handle[" + handle + "], eventType[" + eventType + "], event[" + event + "], address[" + address + "], flags[" + flags + "], reason[" + reason + "].");
        }
        if (!(handle instanceof DiameterActivityHandle)) {
            return;
        }
        this.processAfterEventDelivery(handle, eventType, event, address, service, flags);
    }

    public void eventProcessingSuccessful(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags) {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter Rf RA :: eventProcessingSuccessful :: handle[" + handle + "], eventType[" + eventType + "], event[" + event + "], address[" + address + "], flags[" + flags + "].");
        }
        if (!(handle instanceof DiameterActivityHandle)) {
            return;
        }
        this.processAfterEventDelivery(handle, eventType, event, address, service, flags);
    }

    public void eventUnreferenced(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Rf RA :: eventUnreferenced :: handle[" + handle + "], eventType[" + eventType + "], event[" + event + "], address[" + address + "], service[" + service + "], flags[" + flags + "].");
        }
        if (!(handle instanceof DiameterActivityHandle)) {
            return;
        }
        this.processAfterEventDelivery(handle, eventType, event, address, service, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAfterEventDelivery(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags) {
        DiameterActivityImpl activity = (DiameterActivityImpl)this.getActivity(handle);
        if (activity != null) {
            DiameterActivityImpl diameterActivityImpl = activity;
            synchronized (diameterActivityImpl) {
                if (activity.isTerminateAfterProcessing()) {
                    activity.endActivity();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activityEnded(ActivityHandle handle) {
        this.tracer.info("Diameter Rf RA :: activityEnded :: handle[" + handle + ".");
        if (!(handle instanceof DiameterActivityHandle)) {
            return;
        }
        if (this.activities != null) {
            DiameterActivityManagement diameterActivityManagement = this.activities;
            synchronized (diameterActivityManagement) {
                this.activities.remove((DiameterActivityHandle)handle);
            }
        }
    }

    public void activityUnreferenced(ActivityHandle handle) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Rf RA :: activityUnreferenced :: handle[" + handle + "].");
        }
        if (handle instanceof DiameterActivityHandle) {
            this.endActivity((DiameterActivityHandle)handle);
        }
    }

    public boolean fireEvent(Object event, ActivityHandle handle, FireableEventType eventID, Address address, boolean useFiltering, boolean transacted) {
        if (useFiltering && this.eventIDFilter.filterEvent(eventID)) {
            if (this.tracer.isFineEnabled()) {
                this.tracer.fine("Event " + eventID + " filtered");
            }
        } else if (eventID == null) {
            this.tracer.severe("Event ID for " + eventID + " is unknown, unable to fire.");
        } else {
            if (this.tracer.isFineEnabled()) {
                this.tracer.fine("Firing event " + event + " on handle " + handle);
            }
            try {
                Object o = this.getActivity(handle);
                if (o == null) {
                    Transaction t = this.raContext.getSleeTransactionManager().getTransaction();
                    throw new IllegalStateException("TX[ " + t + " ] No activity for handle: " + handle);
                }
                if (o instanceof RfServerSessionActivityImpl && event instanceof RfAccountingRequest) {
                    ((RfServerSessionActivityImpl)((Object)o)).fetchSessionData((DiameterMessage)((RfAccountingRequest)event), true);
                }
                this.raContext.getSleeEndpoint().fireEvent(handle, eventID, event, address, null, EVENT_FLAGS);
                return true;
            }
            catch (Exception e) {
                this.tracer.severe("Error firing event.", (Throwable)e);
            }
        }
        return false;
    }

    public void endActivity(DiameterActivityHandle arg0) {
        this.sleeEndpoint.endActivity((ActivityHandle)arg0);
    }

    public void startActivityRemoveTimer(DiameterActivityHandle handle) {
        try {
            this.activities.startActivityRemoveTimer(handle);
        }
        catch (Exception e) {
            this.tracer.warning("Failed to start activity remove timer.", (Throwable)e);
        }
    }

    public void stopActivityRemoveTimer(DiameterActivityHandle handle) {
        try {
            this.activities.stopActivityRemoveTimer(handle);
        }
        catch (Exception e) {
            this.tracer.warning("Failed to stop activity remove timer.", (Throwable)e);
        }
    }

    public void update(DiameterActivityHandle arg0, DiameterActivity arg1) {
        this.activities.update(arg0, arg1);
    }

    public void fireEvent(String sessionId, Message message) {
        DiameterMessage event = this.createEvent(message);
        FireableEventType eventId = this.eventIdCache.getEventId(this.eventLookup, message);
        this.fireEvent(event, (ActivityHandle)this.getActivityHandle(sessionId), eventId, null, true, message.isRequest());
    }

    private DiameterMessage createEvent(Message message) {
        if (message == null) {
            throw new NullPointerException("Message argument cannot be null while creating event.");
        }
        int commandCode = message.getCommandCode();
        if (message.isError()) {
            return new ErrorAnswerImpl(message);
        }
        boolean isRequest = message.isRequest();
        switch (commandCode) {
            case 271: {
                return isRequest ? new RfAccountingRequestImpl(message) : new RfAccountingAnswerImpl(message);
            }
        }
        return new ExtensionDiameterMessageImpl(message);
    }

    private void addActivity(DiameterActivity ac, boolean suspended) {
        try {
            DiameterActivityImpl activity = (DiameterActivityImpl)ac;
            if (suspended) {
                this.sleeEndpoint.startActivitySuspended((ActivityHandle)activity.getActivityHandle(), (Object)activity, MARSHALABLE_ACTIVITY_FLAGS);
            } else {
                this.sleeEndpoint.startActivity((ActivityHandle)activity.getActivityHandle(), (Object)activity, MARSHALABLE_ACTIVITY_FLAGS);
            }
            activity.setSessionListener((Object)this);
            this.activities.put(activity.getActivityHandle(), (DiameterActivity)activity);
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Activity started [" + activity.getActivityHandle() + "]");
            }
        }
        catch (Exception e) {
            this.tracer.severe("Error creating activity", (Throwable)e);
            throw new RuntimeException("Error creating activity", e);
        }
    }

    private synchronized void initStack() throws Exception {
        this.diameterMux.registerListener((DiameterListener)this, this.getSupportedApplications());
        this.stack = this.diameterMux.getStack();
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter Rf RA :: Successfully initialized stack.");
        }
    }

    private void initActivitiesMgmt() {
        final DiameterRfResourceAdaptor lst = this;
        if (this.ftRAContext.isLocal()) {
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info(this.raContext.getEntityName() + " -- running in LOCAL mode.");
            }
            this.activities = new LocalDiameterActivityManagement(this.raContext, this.activityRemoveDelay);
        } else {
            this.tracer.info(this.raContext.getEntityName() + " -- running in CLUSTER mode.");
            ReplicatedData clusteredData = this.ftRAContext.getReplicateData(true);
            this.activities = new AbstractClusteredDiameterActivityManagement(this.ftRAContext, this.activityRemoveDelay, this.raContext.getTracer(""), this.stack, this.raContext.getSleeTransactionManager(), clusteredData){

                protected void performBeforeReturn(DiameterActivityImpl activity) {
                    block5: {
                        try {
                            Session session = null;
                            if (activity.getClass().equals(DiameterActivityImpl.class)) {
                                session = this.diameterStack.getSessionFactory().getNewSession(activity.getSessionId());
                                this.performBeforeReturnOnBase(activity, session);
                                return;
                            }
                            if (activity instanceof RfServerSessionActivity) {
                                RfServerSessionActivityImpl acc = (RfServerSessionActivityImpl)activity;
                                ServerRfSession appSession = (ServerRfSession)this.diameterStack.getSession(activity.getSessionId(), ServerRfSession.class);
                                session = (Session)appSession.getSessions().get(0);
                                this.performBeforeReturnOnBase(activity, session);
                                this.performBeforeReturnRf(acc);
                                acc.setSession(appSession);
                                break block5;
                            }
                            if (activity instanceof RfClientSessionActivity) {
                                RfClientSessionActivityImpl acc = (RfClientSessionActivityImpl)activity;
                                ClientRfSession appSession = (ClientRfSession)this.diameterStack.getSession(activity.getSessionId(), ClientRfSession.class);
                                session = (Session)appSession.getSessions().get(0);
                                this.performBeforeReturnOnBase(activity, session);
                                this.performBeforeReturnRf(acc);
                                acc.setSession(appSession);
                                break block5;
                            }
                            throw new IllegalArgumentException("Unknown activity type: " + activity);
                        }
                        catch (Exception e) {
                            throw new DiameterException((Throwable)e);
                        }
                    }
                }

                private void performBeforeReturnOnBase(DiameterActivityImpl ac, Session session) {
                    DiameterMessageFactoryImpl msgFactory = new DiameterMessageFactoryImpl(session, DiameterRfResourceAdaptor.this.stack, new DiameterIdentity[0]);
                    ac.setAvpFactory((DiameterAvpFactory)DiameterRfResourceAdaptor.this.baseAvpFactory);
                    ac.setMessageFactory((DiameterMessageFactory)msgFactory);
                    ac.setCurrentWorkingSession(session);
                    ac.setSessionListener((Object)lst);
                }

                private void performBeforeReturnRf(RfClientSessionActivityImpl ac) {
                    RfMessageFactoryImpl rfMessageFactory = new RfMessageFactoryImpl((DiameterMessageFactory)DiameterRfResourceAdaptor.this.baseMessageFactory, ac.getSessionId(), DiameterRfResourceAdaptor.this.stack);
                    ApplicationId firstAppId = (ApplicationId)DiameterRfResourceAdaptor.this.acctApplicationIds.get(0);
                    rfMessageFactory.setApplicationId(firstAppId.getVendorId(), firstAppId.getAcctAppId());
                    ac.setRfMessageFactory(rfMessageFactory);
                }

                private void performBeforeReturnRf(RfServerSessionActivityImpl ac) {
                    RfMessageFactoryImpl rfMessageFactory = new RfMessageFactoryImpl((DiameterMessageFactory)DiameterRfResourceAdaptor.this.baseMessageFactory, ac.getSessionId(), DiameterRfResourceAdaptor.this.stack);
                    ApplicationId firstAppId = (ApplicationId)DiameterRfResourceAdaptor.this.acctApplicationIds.get(0);
                    rfMessageFactory.setApplicationId(firstAppId.getVendorId(), firstAppId.getAcctAppId());
                    ac.setRfMessageFactory(rfMessageFactory);
                }

                public DiameterActivity get(DiameterActivityHandle handle) {
                    return super.get(handle);
                }

                public void put(DiameterActivityHandle handle, DiameterActivity activity) {
                    super.put(handle, activity);
                }

                public DiameterActivity remove(DiameterActivityHandle handle) {
                    return super.remove(handle);
                }
            };
        }
    }

    protected DiameterActivityHandle getActivityHandle(String sessionId) {
        return new DiameterActivityHandle(sessionId);
    }

    public Answer processRequest(Request request) {
        try {
            DiameterActivityImpl activity = (DiameterActivityImpl)this.raProvider.createActivity((Message)request);
            if (activity instanceof RfServerSessionActivityImpl) {
                RfServerSessionActivityImpl assai = (RfServerSessionActivityImpl)activity;
                ((ServerRfSessionImpl)assai.getSession()).processRequest(request);
            } else if (activity instanceof RfClientSessionActivityImpl) {
                RfClientSessionActivityImpl assai = (RfClientSessionActivityImpl)activity;
                ((ClientRfSessionImpl)assai.getSession()).processRequest(request);
            }
        }
        catch (CreateActivityException e) {
            this.tracer.severe("Failure trying to create Rf Activity.", (Throwable)e);
        }
        return null;
    }

    public void receivedSuccessMessage(Request request, Answer answer) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Diameter Rf RA :: receivedSuccessMessage :: Request[" + request + "], Answer[" + answer + "].");
        }
        this.tracer.warning("Resource Adaptor should not receive this (receivedSuccessMessage), a session should exist to handle it.");
        try {
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Received Message Result-Code: " + answer.getResultCode().getUnsigned32());
            }
        }
        catch (AvpDataException avpDataException) {
            // empty catch block
        }
    }

    public void timeoutExpired(Request request) {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Diameter Rf RA :: timeoutExpired :: Request[" + request + "].");
        }
        this.tracer.warning("Resource Adaptor should not receive this (timeoutExpired), a session should exist to handle it.");
        try {
            ((DiameterActivity)this.getActivity((ActivityHandle)this.getActivityHandle(request.getSessionId()))).endActivity();
        }
        catch (Exception e) {
            this.tracer.severe("Failure processing timeout message.", (Throwable)e);
        }
    }

    public void sessionCreated(ClientRfSession session) {
        RfClientSessionActivityImpl activity = new RfClientSessionActivityImpl((RfMessageFactory)this.rfMessageFactory, this.rfAvpFactory, session, null, null, this.stack);
        activity.setSessionListener(this);
        session.addStateChangeNotification((StateChangeListener)activity);
        this.addActivity((DiameterActivity)activity, false);
    }

    public void sessionCreated(ServerRfSession session) {
        RfServerSessionActivityImpl activity = new RfServerSessionActivityImpl((RfMessageFactory)this.rfMessageFactory, this.rfAvpFactory, session, null, null, this.stack);
        session.addStateChangeNotification((StateChangeListener)activity);
        activity.setSessionListener(this);
        this.addActivity((DiameterActivity)activity, false);
    }

    public void sessionCreated(ServerAuthSession session) {
        this.tracer.severe("Unexpected Auth Session at Rf Resource Adaptor.");
    }

    public void sessionCreated(ClientAuthSession session) {
        this.tracer.severe("Unexpected Auth Session at Rf Resource Adaptor.");
    }

    public boolean sessionExists(String sessionId) {
        return this.activities.containsKey(this.getActivityHandle(sessionId));
    }

    public void sessionDestroyed(String sessionId, Object appSession) {
        try {
            this.sleeEndpoint.endActivity((ActivityHandle)this.getActivityHandle(sessionId));
        }
        catch (Exception e) {
            this.tracer.severe("Failure Ending Activity with Session-Id[" + sessionId + "]", (Throwable)e);
        }
    }

    public ApplicationId[] getSupportedApplications() {
        return this.acctApplicationIds.toArray(new ApplicationId[this.acctApplicationIds.size()]);
    }

    public DiameterIdentity[] getConnectedPeers() {
        if (this.stack != null) {
            try {
                List peers = ((PeerTable)this.stack.unwrap(PeerTable.class)).getPeerTable();
                DiameterIdentity[] result = new DiameterIdentity[peers.size()];
                int i = 0;
                for (Peer peer : peers) {
                    DiameterIdentity identity = new DiameterIdentity(peer.getUri().toString());
                    result[i++] = identity;
                }
                return result;
            }
            catch (Exception e) {
                this.tracer.severe("Failure getting peer list.", (Throwable)e);
            }
        }
        return new DiameterIdentity[0];
    }

    private class RfProviderImpl
    implements RfProvider {
        protected DiameterRfResourceAdaptor ra;
        protected Validator validator = new ValidatorImpl();

        public RfProviderImpl(DiameterRfResourceAdaptor rfResourceAdaptor) {
            this.ra = rfResourceAdaptor;
        }

        private DiameterActivity createActivity(Message message) throws CreateActivityException {
            DiameterActivity activity = DiameterRfResourceAdaptor.this.activities.get(DiameterRfResourceAdaptor.this.getActivityHandle(message.getSessionId()));
            if (activity == null) {
                if (message.isRequest()) {
                    return this.createRfServerSessionActivity((Request)message);
                }
                AvpSet avps = message.getAvps();
                Avp avp = null;
                DiameterIdentity destinationHost = null;
                DiameterIdentity destinationRealm = null;
                avp = avps.getAvp(293);
                if (avp != null) {
                    try {
                        destinationHost = new DiameterIdentity(avp.getDiameterIdentity());
                    }
                    catch (AvpDataException e) {
                        DiameterRfResourceAdaptor.this.tracer.severe("Failed to extract Destination-Host from Message.", (Throwable)e);
                    }
                }
                if ((avp = avps.getAvp(283)) != null) {
                    try {
                        destinationRealm = new DiameterIdentity(avp.getDiameterIdentity());
                    }
                    catch (AvpDataException e) {
                        DiameterRfResourceAdaptor.this.tracer.severe("Failed to extract Destination-Realm from Message.", (Throwable)e);
                    }
                }
                return this.createRfClientSessionActivity(destinationHost, destinationRealm);
            }
            return activity;
        }

        private DiameterActivity createRfServerSessionActivity(Request request) throws CreateActivityException {
            ServerRfSession session = null;
            try {
                ApplicationId appId = request.getApplicationIdAvps().isEmpty() ? null : (ApplicationId)request.getApplicationIdAvps().iterator().next();
                session = (ServerRfSession)((ISessionFactory)DiameterRfResourceAdaptor.this.stack.getSessionFactory()).getNewAppSession(request.getSessionId(), appId, ServerRfSession.class, new Object[]{request});
                if (session == null) {
                    throw new CreateActivityException("Got NULL Session while creating Server Accounting Activity");
                }
                DiameterRfResourceAdaptor.this.sessionCreated(session);
            }
            catch (InternalException e) {
                throw new CreateActivityException("Internal exception while creating Server Accounting Activity", (Throwable)e);
            }
            catch (IllegalDiameterStateException e) {
                throw new CreateActivityException("Illegal Diameter State exception while creating Server Accounting Activity", (Throwable)e);
            }
            return (RfServerSessionActivityImpl)DiameterRfResourceAdaptor.this.activities.get(DiameterRfResourceAdaptor.this.getActivityHandle(((Session)session.getSessions().get(0)).getSessionId()));
        }

        public RfClientSessionActivity createRfClientSessionActivity() throws CreateActivityException {
            return this.createRfClientSessionActivity(null, null);
        }

        public RfClientSessionActivity createRfClientSessionActivity(DiameterIdentity destinationHost, DiameterIdentity destinationRealm) throws CreateActivityException {
            try {
                ClientRfSession session = (ClientRfSession)((ISessionFactory)DiameterRfResourceAdaptor.this.stack.getSessionFactory()).getNewAppSession(null, (ApplicationId)DiameterRfResourceAdaptor.this.acctApplicationIds.get(0), ClientRfSession.class);
                if (session == null) {
                    throw new CreateActivityException("Got NULL Session while creating Client Accounting Activity");
                }
                DiameterRfResourceAdaptor.this.sessionCreated(session);
                return new RfClientSessionActivityImpl((RfMessageFactory)DiameterRfResourceAdaptor.this.rfMessageFactory, DiameterRfResourceAdaptor.this.rfAvpFactory, session, destinationHost, destinationRealm, DiameterRfResourceAdaptor.this.stack);
            }
            catch (Exception e) {
                throw new CreateActivityException("Internal exception while creating Client Accounting Activity", (Throwable)e);
            }
        }

        public RfMessageFactory getRfMessageFactory() {
            return this.ra.rfMessageFactory;
        }

        public RfAvpFactory getRfAvpFactory() {
            return this.ra.rfAvpFactory;
        }

        public RfAccountingAnswer sendRfAccountingRequest(RfAccountingRequest accountingRequest) {
            try {
                DiameterActivityImpl activity = (DiameterActivityImpl)DiameterRfResourceAdaptor.this.getActivity((ActivityHandle)DiameterRfResourceAdaptor.this.getActivityHandle(accountingRequest.getSessionId()));
                if (activity == null) {
                    activity = (DiameterActivityImpl)this.createActivity(((DiameterMessageImpl)accountingRequest).getGenericData());
                }
                return (RfAccountingAnswer)activity.sendSyncMessage((DiameterMessage)accountingRequest);
            }
            catch (Exception e) {
                DiameterRfResourceAdaptor.this.tracer.severe("Failure sending sync request.", (Throwable)e);
                return null;
            }
        }

        public DiameterIdentity[] getConnectedPeers() {
            return this.ra.getConnectedPeers();
        }

        public int getPeerCount() {
            return this.ra.getConnectedPeers().length;
        }

        public Validator getValidator() {
            return this.validator;
        }
    }
}

