/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.gmlc.slee.mlp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.slee.facilities.Tracer;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.JiBXException;
import org.oma.protocols.mlp.svc_result.AddInfo;
import org.oma.protocols.mlp.svc_result.CircularArea;
import org.oma.protocols.mlp.svc_result.Coord;
import org.oma.protocols.mlp.svc_result.Msid;
import org.oma.protocols.mlp.svc_result.Pd;
import org.oma.protocols.mlp.svc_result.Pos;
import org.oma.protocols.mlp.svc_result.Poserr;
import org.oma.protocols.mlp.svc_result.Radius;
import org.oma.protocols.mlp.svc_result.Result;
import org.oma.protocols.mlp.svc_result.Shape;
import org.oma.protocols.mlp.svc_result.Slia;
import org.oma.protocols.mlp.svc_result.SvcResult;
import org.oma.protocols.mlp.svc_result.Time;
import org.oma.protocols.mlp.svc_result.X;
import org.oma.protocols.mlp.svc_result.Y;

public class MLPResponse {
    private Tracer logger;
    private String genericErrorXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n  <!DOCTYPE svc_result SYSTEM \"MLP_SVC_RESULT_310.dtd\">  <svc_result xmlns=\"MLP_SVC_RESULT_310.dtd\" ver=\"3.1.0\">\n  <slia ver=\"3.1.0\">\n    <result resid=\"1\">SYSTEM FAILURE</result>\n    <add_info>Internal IO or parsing error occurred</add_info>\n  </slia>\n</svc_result>";

    public MLPResponse(Tracer logger) {
        this.logger = logger;
    }

    public static String getResultCodeForType(MLPResultType t) {
        switch (t) {
            case OK: {
                return "0";
            }
            case SYSTEM_FAILURE: {
                return "1";
            }
            case UNKNOWN_SUBSCRIBER: {
                return "4";
            }
            case ABSENT_SUBSCRIBER: {
                return "5";
            }
            case FORMAT_ERROR: {
                return "105";
            }
            case QOP_NOT_ATTAINABLE: {
                return "201";
            }
            case POSITION_METHOD_FAILURE: {
                return "6";
            }
        }
        return "1";
    }

    public static String getResultStringForType(MLPResultType t) {
        switch (t) {
            case OK: {
                return "OK";
            }
            case SYSTEM_FAILURE: {
                return "SYSTEM FAILURE";
            }
            case UNKNOWN_SUBSCRIBER: {
                return "UNKNOWN SUBSCRIBER";
            }
            case ABSENT_SUBSCRIBER: {
                return "ABSENT SUBSCRIBER";
            }
            case FORMAT_ERROR: {
                return "FORMAT ERROR";
            }
            case QOP_NOT_ATTAINABLE: {
                return "QOP NOT ATTAINABLE";
            }
            case POSITION_METHOD_FAILURE: {
                return "POSITION METHOD FAILURE";
            }
        }
        return "1";
    }

    public static boolean isSystemError(MLPResultType t) {
        switch (t) {
            case SYSTEM_FAILURE: 
            case UNKNOWN_SUBSCRIBER: 
            case ABSENT_SUBSCRIBER: 
            case FORMAT_ERROR: {
                return true;
            }
        }
        return false;
    }

    public String getSinglePositionSuccessXML(String x, String y, String radius, String msid) {
        String svcResultXml = "";
        try {
            Date requestTime = new Date();
            String date = new SimpleDateFormat("yyyyMMddHHmmss").format(requestTime);
            String utcOffset = new SimpleDateFormat("Z").format(requestTime);
            svcResultXml = this.generateSinglePositionSuccessXML(x, y, radius, utcOffset, date, msid);
        }
        catch (IllegalArgumentException e) {
            svcResultXml = this.getSystemErrorResponseXML(MLPResultType.SYSTEM_FAILURE, "Failed to create request timestamp");
        }
        catch (IOException e) {
            svcResultXml = this.getSystemErrorResponseXML(MLPResultType.SYSTEM_FAILURE, "IO failure generating XML");
        }
        catch (JiBXException e) {
            svcResultXml = this.getSystemErrorResponseXML(MLPResultType.SYSTEM_FAILURE, "Failed to generate XML response from internal objects");
        }
        return svcResultXml;
    }

    private String generateSinglePositionSuccessXML(String x, String y, String radius, String utcOffSet, String time, String msid) throws JiBXException, IOException {
        String lXml = null;
        String ver = "3.1.0";
        SvcResult mlpSvcResult = new SvcResult();
        Slia mlpSlia = new Slia();
        Pos mlpPos = new Pos();
        Msid mlpMsid = new Msid();
        Pd mlpPd = new Pd();
        Time mlpTime = new Time();
        Shape mlpShape = new Shape();
        CircularArea mlpCircularArea = new CircularArea();
        Coord mlpCoord = new Coord();
        X mlpX = new X();
        Y mlpY = new Y();
        Radius mlpRadius = new Radius();
        ArrayList<Pos> posList = new ArrayList<Pos>();
        mlpX.setX(x);
        mlpY.setY(y);
        mlpTime.setUtcOff(utcOffSet);
        mlpMsid.setString(msid);
        mlpRadius.setRadius(radius);
        mlpCoord.setX(mlpX);
        mlpCoord.setY(mlpY);
        mlpCircularArea.setCoord(mlpCoord);
        mlpCircularArea.setRadius(mlpRadius);
        mlpShape.setCircularArea(mlpCircularArea);
        mlpPd.setShape(mlpShape);
        mlpTime.setString(time);
        mlpPd.setTime(mlpTime);
        mlpPos.setMsid(mlpMsid);
        mlpPos.setPd(mlpPd);
        posList.add(mlpPos);
        mlpSlia.setPoList(posList);
        mlpSlia.setVer(ver);
        mlpSvcResult.setSlia(mlpSlia);
        mlpSvcResult.setVer(ver);
        lXml = this.marshalMlpResult(mlpSvcResult);
        return lXml;
    }

    public String getSystemErrorResponseXML(MLPResultType mlpClientErrorType, String mlpClientErrorMessage) {
        String svcResultXml = "";
        try {
            svcResultXml = this.generateSystemErrorXML(mlpClientErrorType, mlpClientErrorMessage);
            return svcResultXml;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.info("Exception while creating XML response data: " + e.getMessage());
            return this.genericErrorXML;
        }
        catch (JiBXException e) {
            e.printStackTrace();
            this.logger.info("Exception while marshalling XML response data: " + e.getMessage());
            return this.genericErrorXML;
        }
    }

    private String generateSystemErrorXML(MLPResultType mlpClientErrorType, String mlpClientErrorMessage) throws JiBXException, IOException {
        String lXml = null;
        String ver = "3.1.0";
        SvcResult mlpSvcResult = new SvcResult();
        Slia mlpSlia = new Slia();
        Result mlpResult = new Result();
        AddInfo mlpAddInfo = new AddInfo();
        if (mlpClientErrorMessage != null) {
            mlpAddInfo.setAddInfo(mlpClientErrorMessage);
            mlpSlia.setAddInfo(mlpAddInfo);
        }
        mlpResult.setString(MLPResponse.getResultStringForType(mlpClientErrorType));
        mlpResult.setResid(MLPResponse.getResultCodeForType(mlpClientErrorType));
        mlpSlia.setResult(mlpResult);
        mlpSlia.setVer(ver);
        mlpSvcResult.setSlia(mlpSlia);
        mlpSvcResult.setVer(ver);
        IBindingFactory jc = BindingDirectory.getFactory(SvcResult.class);
        IMarshallingContext marshaller = jc.createMarshallingContext();
        ByteArrayOutputStream lOutputStream = new ByteArrayOutputStream();
        marshaller.setOutput((OutputStream)lOutputStream, "UTF-8");
        IXMLWriter ix = marshaller.getXmlWriter();
        ix.writeXMLDecl("1.0", "UTF-8", null);
        ix.writeDocType("svc_result", "MLP_SVC_RESULT_310.DTD", null, null);
        marshaller.setIndent(4);
        marshaller.marshalDocument((Object)mlpSvcResult);
        lXml = new String(lOutputStream.toByteArray(), "UTF-8");
        return lXml;
    }

    public String getPositionErrorResponseXML(String msid, MLPResultType mlpClientErrorType, String mlpClientErrorMessage) {
        String svcResultXml = "";
        try {
            Date requestTime = new Date();
            String date = new SimpleDateFormat("yyyyMMddHHmmss").format(requestTime);
            String utcOffset = new SimpleDateFormat("Z").format(requestTime);
            this.logger.info("Creating error XML response for type: " + MLPResponse.getResultCodeForType(mlpClientErrorType) + " message: " + mlpClientErrorMessage);
            svcResultXml = this.generatePositionErrorXML(utcOffset, date, msid, mlpClientErrorType, mlpClientErrorMessage);
            return svcResultXml;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            this.logger.info("Exception while creating timestamp: " + e.getMessage());
            return this.genericErrorXML;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.info("Exception while creating XML response data: " + e.getMessage());
            return this.genericErrorXML;
        }
        catch (JiBXException e) {
            e.printStackTrace();
            this.logger.info("Exception while marshalling XML response data: " + e.getMessage());
            return this.genericErrorXML;
        }
    }

    private String generatePositionErrorXML(String utcOffSet, String time, String msid, MLPResultType mlpClientErrorType, String mlpClientErrorMessage) throws JiBXException, IOException {
        String lXml = null;
        String ver = "3.1.0";
        SvcResult mlpSvcResult = new SvcResult();
        Slia mlpSlia = new Slia();
        Pos mlpPos = new Pos();
        Msid mlpMsid = new Msid();
        Result mlpResult = new Result();
        AddInfo mlpAddInfo = new AddInfo();
        Poserr mlpPosErr = new Poserr();
        Time mlpTime = new Time();
        ArrayList<Pos> posList = new ArrayList<Pos>();
        mlpTime.setUtcOff(utcOffSet);
        mlpTime.setString(time);
        mlpMsid.setString(msid);
        if (mlpClientErrorMessage != null) {
            mlpAddInfo.setAddInfo(mlpClientErrorMessage);
            mlpPosErr.setAddInfo(mlpAddInfo);
        }
        mlpResult.setString(MLPResponse.getResultStringForType(mlpClientErrorType));
        mlpResult.setResid(MLPResponse.getResultCodeForType(mlpClientErrorType));
        mlpPosErr.setResult(mlpResult);
        mlpPosErr.setTime(mlpTime);
        mlpPos.setMsid(mlpMsid);
        mlpPos.setPoserr(mlpPosErr);
        posList.add(mlpPos);
        mlpSlia.setPoList(posList);
        mlpSlia.setVer(ver);
        mlpSvcResult.setSlia(mlpSlia);
        mlpSvcResult.setVer(ver);
        lXml = this.marshalMlpResult(mlpSvcResult);
        return lXml;
    }

    private String marshalMlpResult(SvcResult mlpSvcResult) throws JiBXException, IOException {
        String lXml = null;
        IBindingFactory jc = BindingDirectory.getFactory(SvcResult.class);
        IMarshallingContext marshaller = jc.createMarshallingContext();
        ByteArrayOutputStream lOutputStream = new ByteArrayOutputStream();
        marshaller.setOutput((OutputStream)lOutputStream, "UTF-8");
        IXMLWriter ix = marshaller.getXmlWriter();
        ix.writeXMLDecl("1.0", "UTF-8", null);
        ix.writeDocType("svc_result", "MLP_SVC_RESULT_310.DTD", null, null);
        marshaller.setIndent(4);
        marshaller.marshalDocument((Object)mlpSvcResult);
        lXml = new String(lOutputStream.toByteArray(), "UTF-8");
        return lXml;
    }

    public static enum MLPResultType {
        OK,
        SYSTEM_FAILURE,
        FORMAT_ERROR,
        UNKNOWN_SUBSCRIBER,
        ABSENT_SUBSCRIBER,
        QOP_NOT_ATTAINABLE,
        POSITION_METHOD_FAILURE;

    }
}

