/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.gmlc.slee.mlp;

import java.io.InputStream;
import javax.slee.facilities.Tracer;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.mobicents.gmlc.slee.mlp.MLPException;
import org.mobicents.gmlc.slee.mlp.MLPResponse;
import org.oma.protocols.mlp.svc_init.Msid;
import org.oma.protocols.mlp.svc_init.Msids;
import org.oma.protocols.mlp.svc_init.SvcInit;

public class MLPRequest {
    private Tracer logger;

    public MLPRequest(Tracer logger) {
        this.logger = logger;
    }

    public String parseRequest(InputStream requestStream) throws MLPException {
        String requestingMSISDN = null;
        try {
            IBindingFactory jc = BindingDirectory.getFactory(SvcInit.class);
            IUnmarshallingContext unmarshaller = jc.createUnmarshallingContext();
            SvcInit svcInit = (SvcInit)unmarshaller.unmarshalDocument(requestStream, "UTF-8");
            Msids msids = svcInit.getSlir().getMsids();
            Msids.Choice c = msids.getChoiceList().get(0);
            Msid msisdn = c.getMsid();
            requestingMSISDN = msisdn.getString();
            this.logger.info("Parsed location request for MSISDN: " + requestingMSISDN);
            return requestingMSISDN;
        }
        catch (JiBXException e) {
            e.printStackTrace();
            this.logger.info("Exception while unmarshalling XML request data: " + e.getMessage());
            MLPException mlpException = new MLPException(e.getMessage());
            mlpException.setMlpClientErrorMessage("Invalid XML received: " + e.getMessage());
            mlpException.setMlpClientErrorType(MLPResponse.MLPResultType.FORMAT_ERROR);
            throw mlpException;
        }
    }
}

