/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.gmlc.slee;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.slee.ActivityContextInterface;
import javax.slee.CreateException;
import javax.slee.EventContext;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.SbbLocalObject;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ResourceAdaptorTypeID;
import net.java.slee.resource.http.events.HttpServletRequestEvent;
import org.mobicents.gmlc.GmlcPropertiesManagement;
import org.mobicents.gmlc.slee.mlp.MLPException;
import org.mobicents.gmlc.slee.mlp.MLPRequest;
import org.mobicents.gmlc.slee.mlp.MLPResponse;
import org.mobicents.protocols.ss7.indicator.NatureOfAddress;
import org.mobicents.protocols.ss7.indicator.RoutingIndicator;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContext;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextName;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextVersion;
import org.mobicents.protocols.ss7.map.api.MAPDialog;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParameterFactory;
import org.mobicents.protocols.ss7.map.api.MAPProvider;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessage;
import org.mobicents.protocols.ss7.map.api.primitives.AddressNature;
import org.mobicents.protocols.ss7.map.api.primitives.CellGlobalIdOrServiceAreaIdOrLAI;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.NumberingPlan;
import org.mobicents.protocols.ss7.map.api.primitives.SubscriberIdentity;
import org.mobicents.protocols.ss7.map.api.service.mobility.MAPDialogMobility;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.AnyTimeInterrogationRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.AnyTimeInterrogationResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.RequestedInfo;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.SubscriberInfo;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.SubscriberIdentityImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberInformation.RequestedInfoImpl;
import org.mobicents.protocols.ss7.sccp.impl.parameter.ParameterFactoryImpl;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle0100;
import org.mobicents.protocols.ss7.sccp.parameter.ParameterFactory;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.slee.SbbContextExt;
import org.mobicents.slee.resource.map.MAPContextInterfaceFactory;
import org.mobicents.slee.resource.map.events.DialogAccept;
import org.mobicents.slee.resource.map.events.DialogClose;
import org.mobicents.slee.resource.map.events.DialogDelimiter;
import org.mobicents.slee.resource.map.events.DialogNotice;
import org.mobicents.slee.resource.map.events.DialogProviderAbort;
import org.mobicents.slee.resource.map.events.DialogReject;
import org.mobicents.slee.resource.map.events.DialogRelease;
import org.mobicents.slee.resource.map.events.DialogTimeout;
import org.mobicents.slee.resource.map.events.DialogUserAbort;
import org.mobicents.slee.resource.map.events.ErrorComponent;
import org.mobicents.slee.resource.map.events.InvokeTimeout;
import org.mobicents.slee.resource.map.events.RejectComponent;

public abstract class MobileCoreNetworkInterfaceSbb
implements Sbb {
    protected SbbContextExt sbbContext;
    private Tracer logger;
    protected MAPContextInterfaceFactory mapAcif;
    protected MAPProvider mapProvider;
    protected MAPParameterFactory mapParameterFactory;
    protected ParameterFactory sccpParameterFact;
    protected static final ResourceAdaptorTypeID mapRATypeID = new ResourceAdaptorTypeID("MAPResourceAdaptorType", "org.mobicents", "2.0");
    protected static final String mapRaLink = "MAPRA";
    private static final GmlcPropertiesManagement gmlcPropertiesManagement = GmlcPropertiesManagement.getInstance();
    private SccpAddress serviceCenterSCCPAddress = null;
    private MAPApplicationContext anyTimeEnquiryContext = null;
    private HttpRequestType httpRequestType = null;
    private String requestingMSISDN = null;
    private int responseCellId = -1;
    private int responseMCC = -1;
    private int responseMNC = -1;
    private int responseLAC = -1;
    private int responseAOL = -1;
    private String responseVLR = "-1";
    private MLPResponse.MLPResultType responseType = null;
    private boolean useFakeLocation = false;
    private MLPResponse.MLPResultType fakeLocationType = MLPResponse.MLPResultType.OK;
    private String fakeLocationAdditionalInfoErrorString = "Internal positioning failure occurred";
    private int fakeCellId = 300;
    private String fakeLocationX = "27 28 25.00S";
    private String fakeLocationY = "153 01 43.00E";
    private String fakeLocationRadius = "5000";

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = (SbbContextExt)sbbContext;
        this.logger = sbbContext.getTracer(MobileCoreNetworkInterfaceSbb.class.getSimpleName());
        try {
            this.mapAcif = (MAPContextInterfaceFactory)this.sbbContext.getActivityContextInterfaceFactory(mapRATypeID);
            this.mapProvider = (MAPProvider)this.sbbContext.getResourceAdaptorInterface(mapRATypeID, mapRaLink);
            this.mapParameterFactory = this.mapProvider.getMAPParameterFactory();
            this.sccpParameterFact = new ParameterFactoryImpl();
        }
        catch (Exception ne) {
            this.logger.severe("Could not set SBB context:", (Throwable)ne);
        }
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
        this.logger = null;
    }

    public void sbbCreate() throws CreateException {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Created KnowledgeBase");
        }
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbActivate() {
    }

    public void sbbPassivate() {
    }

    public void sbbLoad() {
    }

    public void sbbStore() {
    }

    public void sbbRemove() {
    }

    public void sbbExceptionThrown(Exception exception, Object object, ActivityContextInterface activityContextInterface) {
    }

    public void sbbRolledBack(RolledBackContext rolledBackContext) {
    }

    public void onDialogTimeout(DialogTimeout evt, ActivityContextInterface aci) {
        this.logger.severe("\nRx :  onDialogTimeout " + evt);
        this.handleLocationResponse(MLPResponse.MLPResultType.SYSTEM_FAILURE, "DialogTimeout");
    }

    public void onDialogDelimiter(DialogDelimiter event, ActivityContextInterface aci) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("\nReceived onDialogDelimiter = " + event);
        }
    }

    public void onDialogAccept(DialogAccept event, ActivityContextInterface aci) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("\nReceived onDialogAccept = " + event);
        }
    }

    public void onDialogReject(DialogReject event, ActivityContextInterface aci) {
        this.logger.severe("\nRx :  onDialogReject " + event);
        this.handleLocationResponse(MLPResponse.MLPResultType.SYSTEM_FAILURE, "DialogReject: " + event);
    }

    public void onDialogUserAbort(DialogUserAbort event, ActivityContextInterface aci) {
        this.logger.severe("\nRx :  onDialogUserAbort " + event);
        this.handleLocationResponse(MLPResponse.MLPResultType.SYSTEM_FAILURE, "DialogUserAbort: " + event);
    }

    public void onDialogProviderAbort(DialogProviderAbort event, ActivityContextInterface aci) {
        this.logger.severe("\nRx :  onDialogProviderAbort " + event);
        this.handleLocationResponse(MLPResponse.MLPResultType.SYSTEM_FAILURE, "DialogProviderAbort: " + event);
    }

    public void onDialogClose(DialogClose event, ActivityContextInterface aci) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("\nReceived onDialogClose = " + event);
        }
    }

    public void onDialogNotice(DialogNotice event, ActivityContextInterface aci) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("\nReceived onDialogNotice = " + event);
        }
    }

    public void onDialogRelease(DialogRelease event, ActivityContextInterface aci) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("\nReceived onDialogRelease = " + event);
        }
    }

    public void onInvokeTimeout(InvokeTimeout event, ActivityContextInterface aci) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("\nReceived onInvokeTimeout = " + event);
        }
    }

    public void onErrorComponent(ErrorComponent event, ActivityContextInterface aci) {
        MAPErrorMessage mapErrorMessage;
        long error_code;
        if (this.logger.isFineEnabled()) {
            this.logger.fine("\nReceived onErrorComponent = " + event);
        }
        this.handleLocationResponse((error_code = (mapErrorMessage = event.getMAPErrorMessage()).getErrorCode().longValue()) == 1L ? MLPResponse.MLPResultType.UNKNOWN_SUBSCRIBER : MLPResponse.MLPResultType.SYSTEM_FAILURE, "ReturnError: " + String.valueOf(error_code) + " : " + event.getMAPErrorMessage());
    }

    public void onRejectComponent(RejectComponent event, ActivityContextInterface aci) {
        this.logger.severe("\nRx :  onRejectComponent " + event);
        this.handleLocationResponse(MLPResponse.MLPResultType.SYSTEM_FAILURE, "RejectComponent: " + event);
    }

    public void onAnyTimeInterrogationRequest(AnyTimeInterrogationRequest event, ActivityContextInterface aci) {
        this.logger.severe("\nReceived onAnyTimeInterrogationRequest = " + event);
    }

    public void onAnyTimeInterrogationResponse(AnyTimeInterrogationResponse event, ActivityContextInterface aci) {
        try {
            MLPResponse.MLPResultType result;
            if (this.logger.isFineEnabled()) {
                this.logger.fine("\nReceived onAnyTimeInterrogationResponse = " + event);
            }
            MAPDialogMobility mapDialogMobility = event.getMAPDialog();
            SubscriberInfo si = event.getSubscriberInfo();
            String mlpClientErrorMessage = null;
            if (si != null) {
                if (si.getLocationInformation() != null) {
                    CellGlobalIdOrServiceAreaIdOrLAI cellGlobalIdOrServiceAreaIdOrLAI;
                    result = MLPResponse.MLPResultType.OK;
                    if (si.getLocationInformation().getCellGlobalIdOrServiceAreaIdOrLAI() != null && (cellGlobalIdOrServiceAreaIdOrLAI = si.getLocationInformation().getCellGlobalIdOrServiceAreaIdOrLAI()).getCellGlobalIdOrServiceAreaIdFixedLength() != null) {
                        this.responseMCC = cellGlobalIdOrServiceAreaIdOrLAI.getCellGlobalIdOrServiceAreaIdFixedLength().getMCC();
                        this.responseMNC = cellGlobalIdOrServiceAreaIdOrLAI.getCellGlobalIdOrServiceAreaIdFixedLength().getMNC();
                        this.responseLAC = cellGlobalIdOrServiceAreaIdOrLAI.getCellGlobalIdOrServiceAreaIdFixedLength().getLac();
                        this.responseCellId = cellGlobalIdOrServiceAreaIdOrLAI.getCellGlobalIdOrServiceAreaIdFixedLength().getCellIdOrServiceAreaCode();
                    }
                    if (si.getLocationInformation().getAgeOfLocationInformation() != null) {
                        this.responseAOL = si.getLocationInformation().getAgeOfLocationInformation();
                    }
                    if (si.getLocationInformation().getVlrNumber() != null) {
                        this.responseVLR = si.getLocationInformation().getVlrNumber().getAddress();
                    }
                } else if (si.getSubscriberState() != null) {
                    result = MLPResponse.MLPResultType.ABSENT_SUBSCRIBER;
                    mlpClientErrorMessage = "SubscriberState: " + si.getSubscriberState();
                } else {
                    result = MLPResponse.MLPResultType.SYSTEM_FAILURE;
                    mlpClientErrorMessage = "Bad SubscriberInfo received: " + si;
                }
            } else {
                result = MLPResponse.MLPResultType.SYSTEM_FAILURE;
                mlpClientErrorMessage = "Bad AnyTimeInterrogationResponse received: " + event;
            }
            this.handleLocationResponse(result, mlpClientErrorMessage);
        }
        catch (Exception e) {
            this.logger.severe(String.format("Error while trying to process AnyTimeInterrogationResponse=%s", event), (Throwable)e);
            this.handleLocationResponse(MLPResponse.MLPResultType.SYSTEM_FAILURE, "Internal failure occurred while processing network response: " + e.getMessage());
        }
    }

    public void onPost(HttpServletRequestEvent event, ActivityContextInterface aci, EventContext eventContext) {
        this.onRequest(event, aci, eventContext);
    }

    public void onGet(HttpServletRequestEvent event, ActivityContextInterface aci, EventContext eventContext) {
        this.onRequest(event, aci, eventContext);
    }

    private void onRequest(HttpServletRequestEvent event, ActivityContextInterface aci, EventContext eventContext) {
        this.setEventContext(eventContext);
        HttpServletRequest httpServletRequest = event.getRequest();
        this.httpRequestType = HttpRequestType.fromPath(httpServletRequest.getPathInfo());
        switch (this.httpRequestType) {
            case REST: {
                this.requestingMSISDN = httpServletRequest.getParameter("msisdn");
                break;
            }
            case MLP: {
                try {
                    ServletInputStream body = httpServletRequest.getInputStream();
                    MLPRequest mlpRequest = new MLPRequest(this.logger);
                    this.requestingMSISDN = mlpRequest.parseRequest((InputStream)body);
                }
                catch (MLPException e) {
                    this.handleLocationResponse(e.getMlpClientErrorType(), "System Failure: " + e.getMlpClientErrorMessage());
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.handleLocationResponse(MLPResponse.MLPResultType.FORMAT_ERROR, "System Failure: Failed to read from server input stream");
                }
                break;
            }
            default: {
                event.getResponse().setStatus(404);
                this.sendHTTPResult("Request URI unsupported");
                return;
            }
        }
        this.logger.info(String.format("Handling %s request, msisdn: %s", this.httpRequestType.name().toUpperCase(), this.requestingMSISDN));
        if (this.requestingMSISDN != null) {
            eventContext.suspendDelivery();
            this.getSingleMSISDNLocation();
        } else {
            this.logger.info("MSISDN is null, sending back -1 for cellid");
            this.handleLocationResponse(MLPResponse.MLPResultType.FORMAT_ERROR, "Invalid MSISDN specified");
        }
    }

    public abstract void setEventContext(EventContext var1);

    public abstract EventContext getEventContext();

    private void getSingleMSISDNLocation() {
        if (!this.useFakeLocation) {
            try {
                MAPDialogMobility mapDialogMobility = this.mapProvider.getMAPServiceMobility().createNewDialog(this.getSRIMAPApplicationContext(), this.getServiceCenterSccpAddress(), null, this.convertAddressFieldToSCCPAddress(this.requestingMSISDN), null);
                ISDNAddressStringImpl isdnAdd = new ISDNAddressStringImpl(AddressNature.international_number, NumberingPlan.ISDN, this.requestingMSISDN);
                SubscriberIdentityImpl subsId = new SubscriberIdentityImpl((ISDNAddressString)isdnAdd);
                RequestedInfoImpl requestedInfo = new RequestedInfoImpl(true, true, null, false, null, false, false, false);
                ISDNAddressStringImpl gscmSCFAddress = new ISDNAddressStringImpl(AddressNature.international_number, NumberingPlan.ISDN, gmlcPropertiesManagement.getGmlcGt());
                mapDialogMobility.addAnyTimeInterrogationRequest((SubscriberIdentity)subsId, (RequestedInfo)requestedInfo, (ISDNAddressString)gscmSCFAddress, null);
                ActivityContextInterface sriDialogACI = this.mapAcif.getActivityContextInterface((MAPDialog)mapDialogMobility);
                sriDialogACI.attach((SbbLocalObject)this.sbbContext.getSbbLocalObject());
                mapDialogMobility.send();
            }
            catch (MAPException e) {
                this.logger.severe("MAPException while trying to send ATI request for MSISDN=" + this.requestingMSISDN, (Throwable)e);
                this.handleLocationResponse(MLPResponse.MLPResultType.SYSTEM_FAILURE, "System Failure: Failed to send request to network for position: " + e.getMessage());
            }
            catch (Exception e) {
                this.logger.severe("Exception while trying to send ATI request for MSISDN=" + this.requestingMSISDN, (Throwable)e);
                this.handleLocationResponse(MLPResponse.MLPResultType.SYSTEM_FAILURE, "System Failure: Failed to send request to network for position: " + e.getMessage());
            }
        } else if (this.fakeLocationType == MLPResponse.MLPResultType.OK) {
            this.responseCellId = this.fakeCellId;
            this.handleLocationResponse(this.fakeLocationType, null);
        } else {
            this.responseCellId = -1;
            this.handleLocationResponse(this.fakeLocationType, this.fakeLocationAdditionalInfoErrorString);
        }
    }

    protected SccpAddress getServiceCenterSccpAddress() {
        if (this.serviceCenterSCCPAddress == null) {
            GlobalTitle0100 gt = this.sccpParameterFact.createGlobalTitle(gmlcPropertiesManagement.getGmlcGt(), 0, org.mobicents.protocols.ss7.indicator.NumberingPlan.ISDN_TELEPHONY, null, NatureOfAddress.INTERNATIONAL);
            this.serviceCenterSCCPAddress = this.sccpParameterFact.createSccpAddress(RoutingIndicator.ROUTING_BASED_ON_GLOBAL_TITLE, (GlobalTitle)gt, 0, gmlcPropertiesManagement.getGmlcSsn());
        }
        return this.serviceCenterSCCPAddress;
    }

    private MAPApplicationContext getSRIMAPApplicationContext() {
        if (this.anyTimeEnquiryContext == null) {
            this.anyTimeEnquiryContext = MAPApplicationContext.getInstance((MAPApplicationContextName)MAPApplicationContextName.anyTimeEnquiryContext, (MAPApplicationContextVersion)MAPApplicationContextVersion.version3);
        }
        return this.anyTimeEnquiryContext;
    }

    private SccpAddress convertAddressFieldToSCCPAddress(String address) {
        GlobalTitle0100 gt = this.sccpParameterFact.createGlobalTitle(address, 0, org.mobicents.protocols.ss7.indicator.NumberingPlan.ISDN_TELEPHONY, null, NatureOfAddress.INTERNATIONAL);
        return this.sccpParameterFact.createSccpAddress(RoutingIndicator.ROUTING_BASED_ON_GLOBAL_TITLE, (GlobalTitle)gt, 0, gmlcPropertiesManagement.getHlrSsn());
    }

    private void handleLocationResponse(MLPResponse.MLPResultType mlpResultType, String mlpClientErrorMessage) {
        switch (this.httpRequestType) {
            case REST: {
                if (mlpResultType == MLPResponse.MLPResultType.OK) {
                    StringBuilder getResponse = new StringBuilder();
                    getResponse.append("mcc=");
                    getResponse.append(this.responseMCC);
                    getResponse.append(",mnc=");
                    getResponse.append(this.responseMNC);
                    getResponse.append(",lac=");
                    getResponse.append(this.responseLAC);
                    getResponse.append(",cellid=");
                    getResponse.append(this.responseCellId);
                    getResponse.append(",aol=");
                    getResponse.append(this.responseAOL);
                    getResponse.append(",vlrNumber=");
                    getResponse.append(this.responseVLR);
                    this.sendHTTPResult(getResponse.toString());
                    break;
                }
                this.sendHTTPResult(mlpClientErrorMessage);
                break;
            }
            case MLP: {
                MLPResponse mlpResponse = new MLPResponse(this.logger);
                String svcResultXml = mlpResultType == MLPResponse.MLPResultType.OK ? mlpResponse.getSinglePositionSuccessXML(this.fakeLocationX, this.fakeLocationY, this.fakeLocationRadius, this.requestingMSISDN) : (MLPResponse.isSystemError(mlpResultType) ? mlpResponse.getSystemErrorResponseXML(mlpResultType, mlpClientErrorMessage) : mlpResponse.getPositionErrorResponseXML(this.requestingMSISDN, mlpResultType, mlpClientErrorMessage));
                this.logger.info("Generated response XML: " + svcResultXml);
                this.sendHTTPResult(svcResultXml);
            }
        }
    }

    private void sendHTTPResult(String responseData) {
        try {
            EventContext ctx = this.getEventContext();
            if (ctx == null && this.logger.isWarningEnabled()) {
                this.logger.warning("When responding to HTTP no pending HTTP request is found, responseData=" + responseData);
                return;
            }
            HttpServletRequestEvent event = (HttpServletRequestEvent)ctx.getEvent();
            HttpServletResponse response = event.getResponse();
            PrintWriter w = null;
            w = response.getWriter();
            w.print(responseData);
            w.flush();
            response.flushBuffer();
            if (ctx.isSuspended()) {
                ctx.resumeDelivery();
            }
            this.logger.info("HTTP Request received and response sent.");
        }
        catch (Exception e) {
            this.logger.severe("Error while sending back HTTP response", (Throwable)e);
        }
    }

    private static enum HttpRequestType {
        REST("rest"),
        MLP("mlp"),
        UNSUPPORTED("404");

        private String path;

        private HttpRequestType(String path) {
            this.path = path;
        }

        public String getPath() {
            return String.format("/gmlc/%s", this.path);
        }

        public static HttpRequestType fromPath(String path) {
            for (HttpRequestType type : HttpRequestType.values()) {
                if (!path.equals(type.getPath())) continue;
                return type;
            }
            return UNSUPPORTED;
        }
    }
}

