/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.factory;

import java.util.concurrent.ConcurrentHashMap;
import org.milyn.javabean.factory.Factory;
import org.milyn.javabean.factory.FactoryDefinitionParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCachingFactoryDefinitionParser
implements FactoryDefinitionParser {
    private final ConcurrentHashMap<String, Factory<?>> factoryCache = new ConcurrentHashMap();

    @Override
    public Factory<?> parse(String factoryDefinition) {
        Factory<?> factory = this.factoryCache.get(factoryDefinition);
        if (factory == null) {
            factory = this.createFactory(factoryDefinition);
            if (factory == null) {
                throw new NullPointerException("Null was returned by the createFactory method.");
            }
            Factory<?> cachedFactory = this.factoryCache.putIfAbsent(factoryDefinition, factory);
            if (cachedFactory != null) {
                factory = cachedFactory;
            }
        }
        return factory;
    }

    protected abstract Factory<?> createFactory(String var1);
}

