/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.container.ApplicationContext;
import org.milyn.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanRuntimeInfo {
    private static final String CONTEXT_KEY = BeanRuntimeInfo.class.getName() + "#CONTEXT_KEY";
    private Class<?> populateType;
    private Classification classification;
    private Class<?> arrayType;
    private boolean isJAXBType = false;

    public BeanRuntimeInfo() {
    }

    public BeanRuntimeInfo(Class<?> clazz) {
        this.resolveBeanRuntimeInfo(clazz);
    }

    public BeanRuntimeInfo(String classname) {
        this.resolveBeanRuntimeInfo(classname);
    }

    public static void recordBeanRuntimeInfo(String beanId, BeanRuntimeInfo beanRuntimeInfo, ApplicationContext appContext) {
        Map<String, BeanRuntimeInfo> runtimeInfoMap = BeanRuntimeInfo.getRuntimeInfoMap(appContext);
        BeanRuntimeInfo existingBeanConfig = runtimeInfoMap.get(beanId);
        if (existingBeanConfig != null && !beanRuntimeInfo.equals(existingBeanConfig)) {
            throw new SmooksConfigurationException("Multiple configurations present with beanId='" + beanId + "', but the bean runtime infos are not equal i.e bean classes etc are different.  Use a different beanId and the 'setOnMethod' config if needed.");
        }
        runtimeInfoMap.put(beanId, beanRuntimeInfo);
    }

    public static BeanRuntimeInfo getBeanRuntimeInfo(String beanId, ApplicationContext appContext) {
        Map<String, BeanRuntimeInfo> runtimeInfoMap = BeanRuntimeInfo.getRuntimeInfoMap(appContext);
        return runtimeInfoMap.get(beanId);
    }

    public void setClassification(Class<?> clazz) {
        if (Map.class.isAssignableFrom(clazz)) {
            this.setClassification(Classification.MAP_COLLECTION);
        } else if (Collection.class.isAssignableFrom(clazz)) {
            this.setClassification(Classification.COLLECTION_COLLECTION);
        } else {
            this.setClassification(Classification.NON_COLLECTION);
        }
    }

    public static BeanRuntimeInfo getBeanRuntimeInfo(String beanId, String beanClassName, ApplicationContext appContext) {
        Map<String, BeanRuntimeInfo> runtimeInfoMap = BeanRuntimeInfo.getRuntimeInfoMap(appContext);
        BeanRuntimeInfo beanRuntimeInfo = runtimeInfoMap.get(beanId);
        if (beanRuntimeInfo == null) {
            beanRuntimeInfo = new BeanRuntimeInfo(beanClassName);
            BeanRuntimeInfo.recordBeanRuntimeInfo(beanId, beanRuntimeInfo, appContext);
        }
        return beanRuntimeInfo;
    }

    private void resolveBeanRuntimeInfo(String beanClass) {
        if (beanClass.endsWith("[]")) {
            this.setClassification(Classification.ARRAY_COLLECTION);
            String arrayTypeName = beanClass.substring(0, beanClass.length() - 2);
            try {
                this.setArrayType(ClassUtil.forName((String)arrayTypeName, this.getClass()));
            }
            catch (ClassNotFoundException e) {
                throw new SmooksConfigurationException("Invalid Smooks bean configuration.  Bean class " + arrayTypeName + " not on classpath.");
            }
            this.setPopulateType(ArrayList.class);
        } else {
            Class clazz;
            try {
                clazz = ClassUtil.forName((String)beanClass, this.getClass());
            }
            catch (ClassNotFoundException e) {
                throw new SmooksConfigurationException("Invalid Smooks bean configuration.  Bean class " + beanClass + " not on classpath.");
            }
            this.setPopulateType(clazz);
            this.setClassification(clazz);
        }
    }

    private void resolveBeanRuntimeInfo(Class<?> clazz) {
        if (clazz.isArray()) {
            this.setClassification(Classification.ARRAY_COLLECTION);
            this.setArrayType(clazz.getComponentType());
            this.setPopulateType(ArrayList.class);
        } else {
            this.setPopulateType(clazz);
            this.setClassification(clazz);
        }
    }

    private static Map<String, BeanRuntimeInfo> getRuntimeInfoMap(ApplicationContext appContext) {
        HashMap runtimeInfoMap = (HashMap)appContext.getAttribute((Object)CONTEXT_KEY);
        if (runtimeInfoMap == null) {
            runtimeInfoMap = new HashMap();
            appContext.setAttribute((Object)CONTEXT_KEY, runtimeInfoMap);
        }
        return runtimeInfoMap;
    }

    public Class<?> getPopulateType() {
        return this.populateType;
    }

    public void setPopulateType(Class<?> populateType) {
        this.populateType = populateType;
        for (Annotation anno : populateType.getAnnotations()) {
            this.isJAXBType = anno.annotationType().getName().equals("javax.xml.bind.annotation.XmlType");
            if (this.isJAXBType) break;
        }
    }

    public Classification getClassification() {
        return this.classification;
    }

    public void setClassification(Classification classification) {
        this.classification = classification;
    }

    public Class<?> getArrayType() {
        return this.arrayType;
    }

    public void setArrayType(Class<?> arrayType) {
        this.arrayType = arrayType;
    }

    public boolean isJAXBType() {
        return this.isJAXBType;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BeanRuntimeInfo)) {
            return false;
        }
        BeanRuntimeInfo beanInfo = (BeanRuntimeInfo)obj;
        if (beanInfo.getArrayType() != this.getArrayType()) {
            return false;
        }
        if (beanInfo.getClassification() != this.getClassification()) {
            return false;
        }
        return beanInfo.getPopulateType() == this.getPopulateType();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Classification: " + (Object)((Object)this.classification));
        stringBuilder.append(", Populate Type: : " + this.populateType.getName());
        if (this.arrayType != null) {
            stringBuilder.append(", Array Type: " + this.arrayType.getName());
        }
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Classification {
        NON_COLLECTION,
        ARRAY_COLLECTION,
        COLLECTION_COLLECTION,
        MAP_COLLECTION;

    }
}

