/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.smooks.edi;

import java.util.List;
import org.milyn.GenericReaderConfigurator;
import org.milyn.ReaderConfigurator;
import org.milyn.assertion.AssertArgument;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.smooks.edi.EDIReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EDIReaderConfigurator
implements ReaderConfigurator {
    private String mappingModel;
    private String targetProfile;

    public EDIReaderConfigurator(String mappingModel) {
        AssertArgument.isNotNullAndNotEmpty(mappingModel, "mappingModel");
        this.mappingModel = mappingModel;
    }

    public EDIReaderConfigurator setTargetProfile(String targetProfile) {
        AssertArgument.isNotNullAndNotEmpty(targetProfile, "targetProfile");
        this.targetProfile = targetProfile;
        return this;
    }

    @Override
    public List<SmooksResourceConfiguration> toConfig() {
        GenericReaderConfigurator configurator = new GenericReaderConfigurator(EDIReader.class);
        configurator.getParameters().setProperty("mapping-model", this.mappingModel);
        configurator.setTargetProfile(this.targetProfile);
        return configurator.toConfig();
    }
}

