/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.flatfile;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.Config;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.cdr.annotation.Configurator;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.VisitorAppender;
import org.milyn.delivery.VisitorConfigMap;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.flatfile.Field;
import org.milyn.flatfile.Record;
import org.milyn.flatfile.RecordMetaData;
import org.milyn.flatfile.RecordParser;
import org.milyn.flatfile.RecordParserFactory;
import org.milyn.xml.SmooksXMLReader;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.AttributesImpl;

public class FlatFileReader
implements SmooksXMLReader,
VisitorAppender {
    private static Log logger = LogFactory.getLog(FlatFileReader.class);
    private static Attributes EMPTY_ATTRIBS = new AttributesImpl();
    private static char[] INDENT_LF = new char[]{'\n'};
    private static char[] INDENTCHARS = new char[]{'\t', '\t'};
    private static String RECORD_NUMBER_ATTR = "number";
    private static String RECORD_TRUNCATED_ATTR = "truncated";
    private ContentHandler contentHandler;
    private ExecutionContext execContext;
    @Config
    private SmooksResourceConfiguration config;
    @AppContext
    private ApplicationContext appContext;
    @ConfigParam(name="parserFactory")
    private Class<? extends RecordParserFactory> parserFactoryClass;
    private RecordParserFactory parserFactory;
    @ConfigParam(defaultVal="records")
    private String rootElementName;
    @ConfigParam(defaultVal="false")
    private boolean indent;

    @Initialize
    public void initialize() throws IllegalAccessException, InstantiationException {
        this.parserFactory = this.parserFactoryClass.newInstance();
        Configurator.configure(this.parserFactory, this.config, this.appContext);
    }

    public void addVisitors(VisitorConfigMap visitorMap) {
        if (this.parserFactory instanceof VisitorAppender) {
            ((VisitorAppender)((Object)this.parserFactory)).addVisitors(visitorMap);
        }
    }

    public void setExecutionContext(ExecutionContext request) {
        this.execContext = request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource inputSource) throws IOException, SAXException {
        if (this.contentHandler == null) {
            throw new IllegalStateException("'contentHandler' not set.  Cannot parse Record stream.");
        }
        if (this.execContext == null) {
            throw new IllegalStateException("'execContext' not set.  Cannot parse Record stream.");
        }
        try {
            RecordParser recordParser = this.parserFactory.newRecordParser();
            recordParser.setRecordParserFactory(this.parserFactory);
            recordParser.setDataSource(inputSource);
            try {
                recordParser.initialize();
                this.contentHandler.startDocument();
                this.contentHandler.startElement("", this.rootElementName, "", EMPTY_ATTRIBS);
                int lineNumber = 0;
                Record record = recordParser.nextRecord();
                while (record != null) {
                    ++lineNumber;
                    if (record != null) {
                        List<Field> recordFields = record.getFields();
                        if (this.indent) {
                            this.contentHandler.characters(INDENT_LF, 0, 1);
                            this.contentHandler.characters(INDENTCHARS, 0, 1);
                        }
                        AttributesImpl attrs = new AttributesImpl();
                        attrs.addAttribute("", RECORD_NUMBER_ATTR, RECORD_NUMBER_ATTR, "xs:int", Integer.toString(lineNumber));
                        RecordMetaData recordMetaData = record.getRecordMetaData();
                        if (recordFields.size() < recordMetaData.getUnignoredFieldCount()) {
                            attrs.addAttribute("", RECORD_TRUNCATED_ATTR, RECORD_TRUNCATED_ATTR, "xs:boolean", Boolean.TRUE.toString());
                        }
                        this.contentHandler.startElement("", record.getName(), "", attrs);
                        for (Field recordField : recordFields) {
                            String fieldName = recordField.getName();
                            if (this.indent) {
                                this.contentHandler.characters(INDENT_LF, 0, 1);
                                this.contentHandler.characters(INDENTCHARS, 0, 2);
                            }
                            this.contentHandler.startElement("", fieldName, "", EMPTY_ATTRIBS);
                            String value = recordField.getValue();
                            this.contentHandler.characters(value.toCharArray(), 0, value.length());
                            this.contentHandler.endElement("", fieldName, "");
                        }
                        if (this.indent) {
                            this.contentHandler.characters(INDENT_LF, 0, 1);
                            this.contentHandler.characters(INDENTCHARS, 0, 1);
                        }
                        this.contentHandler.endElement("", record.getName(), "");
                    }
                    record = recordParser.nextRecord();
                }
                if (this.indent) {
                    this.contentHandler.characters(INDENT_LF, 0, 1);
                }
                this.contentHandler.endElement("", this.rootElementName, "");
                this.contentHandler.endDocument();
            }
            finally {
                recordParser.uninitialize();
            }
        }
        finally {
            this.contentHandler = null;
            this.execContext = null;
        }
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void parse(String systemId) throws IOException, SAXException {
        throw new UnsupportedOperationException("Operation not supports by this reader.");
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setDTDHandler(DTDHandler arg0) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setEntityResolver(EntityResolver arg0) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void setErrorHandler(ErrorHandler arg0) {
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }
}

