/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.cdr.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.assertion.AssertArgument;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.Config;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.config.Configurable;
import org.milyn.container.ApplicationContext;
import org.milyn.delivery.ContentHandler;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.annotation.Uninitialize;
import org.milyn.delivery.sax.SAXToXMLWriter;
import org.milyn.delivery.sax.SAXVisitor;
import org.milyn.delivery.sax.annotation.StreamResultWriter;
import org.milyn.javabean.DataDecodeException;
import org.milyn.javabean.DataDecoder;
import org.milyn.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configurator {
    private static Log logger = LogFactory.getLog(Configurator.class);

    public static <U> U configure(U instance, SmooksResourceConfiguration config, ApplicationContext appContext) throws SmooksConfigurationException {
        AssertArgument.isNotNull(appContext, "appContext");
        Configurator.processFieldContextAnnotation(instance, appContext);
        config.attachGlobalParameters(appContext);
        return Configurator.configure(instance, config);
    }

    public static <U> U configure(U instance, SmooksResourceConfiguration config) throws SmooksConfigurationException {
        AssertArgument.isNotNull(instance, "instance");
        AssertArgument.isNotNull(config, "config");
        Configurator.processFieldConfigAnnotations(instance, config, true);
        Configurator.processMethodConfigAnnotations(instance, config);
        Configurator.setConfiguration(instance, config);
        Configurator.initialise(instance);
        return instance;
    }

    public static <U> void processFieldContextAnnotation(U instance, ApplicationContext appContext) {
        Configurator.processFieldContextAnnotation(instance.getClass(), instance, appContext);
    }

    private static <U> void processFieldContextAnnotation(Class contentHandlerClass, U instance, ApplicationContext appContext) {
        Field[] fields = contentHandlerClass.getDeclaredFields();
        Class superClass = contentHandlerClass.getSuperclass();
        if (superClass != null && ContentHandler.class.isAssignableFrom(superClass)) {
            Configurator.processFieldContextAnnotation(superClass, instance, appContext);
        }
        for (Field field : fields) {
            AppContext appContextAnnotation = field.getAnnotation(AppContext.class);
            if (appContextAnnotation == null) continue;
            try {
                ClassUtil.setField(field, instance, appContext);
            }
            catch (IllegalAccessException e) {
                throw new SmooksConfigurationException("Failed to set ApplicationContext value on '" + Configurator.getLongMemberName(field) + "'.", e);
            }
        }
    }

    public static <U> void processFieldConfigAnnotations(U instance, SmooksResourceConfiguration config, boolean includeConfigParams) {
        Class<?> contentHandlerClass = instance.getClass();
        if (includeConfigParams) {
            Configurator.processFieldConfigParamAnnotations(contentHandlerClass, instance, config);
        }
        Configurator.processFieldConfigAnnotations(contentHandlerClass, instance, config);
        Configurator.processStreamResultWriterAnnotations(instance, config);
    }

    private static <U> void processFieldConfigParamAnnotations(Class contentHandlerClass, U instance, SmooksResourceConfiguration config) {
        Field[] fields = contentHandlerClass.getDeclaredFields();
        Class superClass = contentHandlerClass.getSuperclass();
        if (superClass != null) {
            Configurator.processFieldConfigParamAnnotations(superClass, instance, config);
        }
        for (Field field : fields) {
            ConfigParam configParamAnnotation = null;
            configParamAnnotation = field.getAnnotation(ConfigParam.class);
            if (configParamAnnotation == null) continue;
            Configurator.applyConfigParam(configParamAnnotation, field, field.getType(), instance, config);
        }
    }

    private static <U> void processFieldConfigAnnotations(Class contentHandlerClass, U instance, SmooksResourceConfiguration config) {
        Field[] fields = contentHandlerClass.getDeclaredFields();
        Class superClass = contentHandlerClass.getSuperclass();
        if (superClass != null) {
            Configurator.processFieldConfigAnnotations(superClass, instance, config);
        }
        for (Field field : fields) {
            ConfigParam configParamAnnotation = field.getAnnotation(ConfigParam.class);
            Config configAnnotation = field.getAnnotation(Config.class);
            if (configAnnotation == null) continue;
            if (configParamAnnotation != null) {
                throw new SmooksConfigurationException("Invalid Smooks configuration annotations on Field '" + Configurator.getLongMemberName(field) + "'.  Field should not specify both @ConfigParam and @Config annotations.");
            }
            Configurator.applyConfig(field, instance, config);
        }
    }

    private static <U> void processStreamResultWriterAnnotations(U instance, SmooksResourceConfiguration config) {
        if (!(instance instanceof SAXVisitor)) {
            return;
        }
        List<Field> streamResFields = ClassUtil.getAnnotatedFields(instance.getClass(), StreamResultWriter.class);
        boolean encodeSpecialCharacters = config.getBoolParameter("entities.rewrite", true);
        for (Field streamResField : streamResFields) {
            try {
                if (ClassUtil.getField(streamResField, instance) != null) {
                    continue;
                }
            }
            catch (IllegalAccessException e) {
                throw new SmooksConfigurationException("Unable to get property field value for '" + Configurator.getLongMemberName(streamResField) + "'.", e);
            }
            Class<?> type = streamResField.getType();
            if (type != SAXToXMLWriter.class) continue;
            SAXToXMLWriter xmlWriter = new SAXToXMLWriter((SAXVisitor)instance, encodeSpecialCharacters);
            try {
                ClassUtil.setField(streamResField, instance, xmlWriter);
            }
            catch (IllegalAccessException e) {
                throw new SmooksConfigurationException("Unable to inject SAXToXMLWriter property field value for '" + Configurator.getLongMemberName(streamResField) + "'.", e);
            }
        }
    }

    private static <U> void checkPropertiesConfigured(Class contentHandlerClass, U instance) {
        Field[] fields = contentHandlerClass.getDeclaredFields();
        Class superClass = contentHandlerClass.getSuperclass();
        if (superClass != null) {
            Configurator.checkPropertiesConfigured(superClass, instance);
        }
        for (Field field : fields) {
            String setterName;
            Method setterMethod;
            Object fieldValue;
            String fieldName = field.getName();
            try {
                fieldValue = ClassUtil.getField(field, instance);
            }
            catch (IllegalAccessException e) {
                throw new SmooksConfigurationException("Unable to get property field value for '" + Configurator.getLongMemberName(field) + "'.", e);
            }
            if (fieldValue != null) continue;
            ConfigParam configParamAnnotation = field.getAnnotation(ConfigParam.class);
            if (configParamAnnotation == null && (setterMethod = ClassUtil.getSetterMethod(setterName = ClassUtil.toSetterName(fieldName), contentHandlerClass, field.getType())) != null) {
                configParamAnnotation = setterMethod.getAnnotation(ConfigParam.class);
            }
            if (configParamAnnotation == null || configParamAnnotation.use() != ConfigParam.Use.REQUIRED) continue;
            String defaultVal = configParamAnnotation.defaultVal();
            if (defaultVal.equals("org.milyn.cdr.annotation.AnnotationConstants##UNASSIGNED")) {
                throw new SmooksConfigurationException("Property '" + fieldName + "' not configured on class " + instance.getClass().getName() + "'.");
            }
            if (defaultVal.equals("##NULL")) continue;
            Class<? extends DataDecoder> decoderClass = configParamAnnotation.decoder();
            DataDecoder decoder = Configurator.createDecoder(field, field.getType(), decoderClass);
            try {
                ClassUtil.setField(field, instance, decoder.decode(defaultVal));
            }
            catch (IllegalAccessException e) {
                throw new SmooksConfigurationException("Unable to set property field value for '" + Configurator.getLongMemberName(field) + "'.", e);
            }
        }
    }

    private static <U> void processMethodConfigAnnotations(U instance, SmooksResourceConfiguration config) {
        Method[] methods;
        for (Method method : methods = instance.getClass().getMethods()) {
            ConfigParam configParamAnnotation = method.getAnnotation(ConfigParam.class);
            if (configParamAnnotation == null) continue;
            Class<?>[] params = method.getParameterTypes();
            if (params.length == 1) {
                Configurator.applyConfigParam(configParamAnnotation, method, params[0], instance, config);
                continue;
            }
            throw new SmooksConfigurationException("Method '" + Configurator.getLongMemberName(method) + "' defines a @ConfigParam, yet it specifies more than a single paramater.");
        }
    }

    private static <U> void applyConfigParam(ConfigParam configParam, Member member, Class type, U instance, SmooksResourceConfiguration config) throws SmooksConfigurationException {
        String paramValue;
        String name = configParam.name();
        if ("##NULL".equals(name)) {
            if (member instanceof Method) {
                name = Configurator.getPropertyName((Method)member);
                if (name == null) {
                    throw new SmooksConfigurationException("Unable to determine the property name associated with '" + Configurator.getLongMemberName(member) + "'. " + "Setter methods that specify the @ConfigParam annotation " + "must either follow the Javabean naming convention ('setX' for propert 'x'), or specify the " + "propery name via the 'name' parameter on the @ConfigParam annotation.");
                }
            } else {
                name = member.getName();
            }
        }
        if ((paramValue = config.getStringParameter(name)) == null) {
            paramValue = configParam.defaultVal();
            if ("##NULL".equals(paramValue)) {
                String[] choices = configParam.choice();
                Configurator.assertValidChoice(choices, name, "##NULL");
                Configurator.setMember(member, instance, null);
                return;
            }
            if ("org.milyn.cdr.annotation.AnnotationConstants##UNASSIGNED".equals(paramValue)) {
                paramValue = null;
            }
        }
        if (paramValue != null) {
            String[] choices = configParam.choice();
            Configurator.assertValidChoice(choices, name, paramValue);
            Class<? extends DataDecoder> decoderClass = configParam.decoder();
            DataDecoder decoder = Configurator.createDecoder(member, type, decoderClass);
            try {
                Configurator.setMember(member, instance, decoder.decode(paramValue));
            }
            catch (DataDecodeException e) {
                throw new SmooksConfigurationException("Failed to set paramater configuration value on '" + Configurator.getLongMemberName(member) + "'.", e);
            }
        } else if (configParam.use() == ConfigParam.Use.REQUIRED) {
            throw new SmooksConfigurationException("<param> '" + name + "' not specified on resource configuration:\n" + config);
        }
    }

    private static <U> DataDecoder createDecoder(Member member, Class type, Class<? extends DataDecoder> decoderClass) {
        DataDecoder decoder;
        if (decoderClass.isAssignableFrom(DataDecoder.class)) {
            decoder = DataDecoder.Factory.create(type);
            if (decoder == null) {
                throw new SmooksConfigurationException("ContentHandler class member '" + Configurator.getLongMemberName(member) + "' must define a decoder through it's @ConfigParam annotation.  Unable to automatically determine DataDecoder from member type.");
            }
        } else {
            try {
                decoder = decoderClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new SmooksConfigurationException("Failed to create DataDecoder instance from class '" + decoderClass.getName() + "'.  Make sure the DataDecoder implementation has a public default constructor.", e);
            }
            catch (IllegalAccessException e) {
                throw new SmooksConfigurationException("Failed to create DataDecoder instance from class '" + decoderClass.getName() + "'.  Make sure the DataDecoder implementation has a public default constructor.", e);
            }
        }
        return decoder;
    }

    private static void assertValidChoice(String[] choices, String name, String paramValue) throws SmooksConfigurationException {
        if (choices == null || choices.length == 0) {
            throw new RuntimeException("Unexpected annotation default choice value.  Should not be null or empty.  Code may have changed incompatibly.");
        }
        if (choices.length == 1 && "##NULL".equals(choices[0])) {
            return;
        }
        for (String choice : choices) {
            if (!paramValue.equals(choice)) continue;
            return;
        }
        throw new SmooksConfigurationException("Value '" + paramValue + "' for paramater '" + name + "' is invalid.  Valid choices for this paramater are: " + Arrays.asList(choices));
    }

    private static <U> void applyConfig(Field field, U instance, SmooksResourceConfiguration config) {
        try {
            ClassUtil.setField(field, instance, config);
        }
        catch (IllegalAccessException e) {
            throw new SmooksConfigurationException("Failed to set paramater configuration value on '" + Configurator.getLongMemberName(field) + "'.", e);
        }
    }

    private static <U> void setConfiguration(U instance, SmooksResourceConfiguration config) {
        if (instance instanceof Configurable) {
            ((Configurable)instance).setConfiguration(config.toProperties());
        } else {
            try {
                Method setConfigurationMethod = instance.getClass().getMethod("setConfiguration", SmooksResourceConfiguration.class);
                setConfigurationMethod.invoke(instance, config);
            }
            catch (NoSuchMethodException e) {
            }
            catch (IllegalAccessException e) {
                throw new SmooksConfigurationException("Error invoking 'setConfiguration' method on class '" + instance.getClass().getName() + "'.  This class must be public.  Alternatively, use the @Config annotation on a class field.", e);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof SmooksConfigurationException) {
                    throw (SmooksConfigurationException)e.getTargetException();
                }
                Throwable cause = e.getTargetException();
                throw new SmooksConfigurationException("Error invoking 'setConfiguration' method on class '" + instance.getClass().getName() + "'.", cause != null ? cause : e);
            }
        }
    }

    private static String getLongMemberName(Member field) {
        return field.getDeclaringClass().getName() + "#" + field.getName();
    }

    private static <U> void setMember(Member member, U instance, Object value) {
        block5: {
            try {
                if (member instanceof Field) {
                    ClassUtil.setField((Field)member, instance, value);
                    break block5;
                }
                try {
                    Configurator.setMethod((Method)member, instance, value);
                }
                catch (InvocationTargetException e) {
                    throw new SmooksConfigurationException("Failed to set paramater configuration value on '" + Configurator.getLongMemberName(member) + "'.", e.getTargetException());
                }
            }
            catch (IllegalAccessException e) {
                throw new SmooksConfigurationException("Failed to set paramater configuration value on '" + Configurator.getLongMemberName(member) + "'.", e);
            }
        }
    }

    private static <U> void setMethod(Method method, U instance, Object value) throws IllegalAccessException, InvocationTargetException {
        method.invoke(instance, value);
    }

    public static <U> void initialise(U instance) {
        Configurator.checkPropertiesConfigured(instance.getClass(), instance);
        Configurator.invoke(instance, Initialize.class);
    }

    public static <U> void uninitialise(U instance) {
        Configurator.invoke(instance, Uninitialize.class);
    }

    private static <U> void invoke(U instance, Class<? extends Annotation> annotation) {
        Method[] methods;
        for (Method method : methods = instance.getClass().getMethods()) {
            if (method.getAnnotation(annotation) == null) continue;
            if (method.getParameterTypes().length == 0) {
                try {
                    method.invoke(instance, new Object[0]);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new SmooksConfigurationException("Error invoking @" + annotation.getSimpleName() + " method '" + method.getName() + "' on class '" + instance.getClass().getName() + "'.", e);
                }
                catch (InvocationTargetException e) {
                    throw new SmooksConfigurationException("Error invoking @" + annotation.getSimpleName() + " method '" + method.getName() + "' on class '" + instance.getClass().getName() + "'.", e.getTargetException());
                }
            }
            logger.warn((Object)("Method '" + Configurator.getLongMemberName(method) + "' defines an @" + annotation.getSimpleName() + " annotation on a paramaterized method.  This is not allowed!"));
        }
    }

    private static String getPropertyName(Method method) {
        if (!method.getName().startsWith("set")) {
            return null;
        }
        StringBuffer methodName = new StringBuffer(method.getName());
        if (methodName.length() < 4) {
            return null;
        }
        methodName.delete(0, 3);
        methodName.setCharAt(0, Character.toLowerCase(methodName.charAt(0)));
        return methodName.toString();
    }
}

