/*
 * Decompiled with CFR 0.152.
 */
package org.milyn;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.saxpath.SAXPathException;
import org.milyn.FilterSettings;
import org.milyn.ReaderConfigurator;
import org.milyn.SmooksException;
import org.milyn.assertion.AssertArgument;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.classpath.CascadingClassLoaderSet;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.container.standalone.StandaloneApplicationContext;
import org.milyn.container.standalone.StandaloneExecutionContext;
import org.milyn.delivery.ContentDeliveryConfig;
import org.milyn.delivery.Filter;
import org.milyn.delivery.FilterBypass;
import org.milyn.delivery.Visitor;
import org.milyn.delivery.VisitorAppender;
import org.milyn.delivery.VisitorConfigMap;
import org.milyn.event.ExecutionEventListener;
import org.milyn.event.types.FilterLifecycleEvent;
import org.milyn.javabean.context.BeanContext;
import org.milyn.javabean.context.preinstalled.Time;
import org.milyn.javabean.context.preinstalled.UniqueID;
import org.milyn.javabean.lifecycle.BeanContextLifecycleObserver;
import org.milyn.net.URIUtil;
import org.milyn.payload.Exports;
import org.milyn.payload.FilterResult;
import org.milyn.payload.FilterSource;
import org.milyn.payload.JavaResult;
import org.milyn.profile.Profile;
import org.milyn.profile.UnknownProfileMemberException;
import org.milyn.resource.URIResourceLocator;
import org.milyn.xml.NamespaceMappings;
import org.xml.sax.SAXException;

public class Smooks {
    private static Log logger = LogFactory.getLog(Smooks.class);
    private StandaloneApplicationContext context;
    private ClassLoader classLoader;
    private VisitorConfigMap visitorConfigMap;
    private volatile boolean isConfigurable = true;

    public Smooks() {
        this.context = new StandaloneApplicationContext(true);
        this.visitorConfigMap = new VisitorConfigMap(this.context);
    }

    public Smooks(StandaloneApplicationContext context) {
        this.context = context;
        this.visitorConfigMap = new VisitorConfigMap(context);
    }

    public Smooks(String resourceURI) throws IOException, SAXException {
        this();
        URIResourceLocator resourceLocator = new URIResourceLocator();
        resourceLocator.setBaseURI(URIResourceLocator.extractBaseURI(resourceURI));
        this.context.setResourceLocator(resourceLocator);
        this.addConfigurations(resourceURI);
    }

    public Smooks(InputStream resourceConfigStream) throws IOException, SAXException {
        this();
        this.context.setResourceLocator(new URIResourceLocator());
        this.addConfigurations(resourceConfigStream);
    }

    public ClassLoader getClassLoader() {
        return this.context.getClassLoader();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.context.setClassLoader(classLoader);
    }

    public void setFilterSettings(FilterSettings filterSettings) {
        AssertArgument.isNotNull(filterSettings, "filterSettings");
        filterSettings.applySettings(this);
    }

    public Smooks setExports(Exports exports) {
        AssertArgument.isNotNull(exports, "exports");
        Exports.setExportsInApplicationContext(this.getApplicationContext(), exports);
        return this;
    }

    public void setReaderConfig(ReaderConfigurator readerConfigurator) {
        List<SmooksResourceConfiguration> configList = readerConfigurator.toConfig();
        for (SmooksResourceConfiguration config : configList) {
            this.addConfiguration(config);
        }
    }

    public void setNamespaces(Properties namespaces) {
        AssertArgument.isNotNull(namespaces, "namespaces");
        this.assertIsConfigurable();
        NamespaceMappings.setMappings(namespaces, this.context);
    }

    public SmooksResourceConfiguration addVisitor(Visitor visitor) {
        return this.addVisitor(visitor, "#document", null);
    }

    public SmooksResourceConfiguration addVisitor(Visitor visitor, String targetSelector) {
        return this.addVisitor(visitor, targetSelector, null);
    }

    public SmooksResourceConfiguration addVisitor(Visitor visitor, String targetSelector, String targetSelectorNS) {
        this.assertIsConfigurable();
        return this.visitorConfigMap.addVisitor(visitor, targetSelector, targetSelectorNS, true);
    }

    public void addVisitor(VisitorAppender appender) {
        appender.addVisitors(this.visitorConfigMap);
    }

    public void addConfiguration(SmooksResourceConfiguration resourceConfig) {
        AssertArgument.isNotNull(resourceConfig, "resourceConfig");
        this.assertIsConfigurable();
        this.context.getStore().registerResource(resourceConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfigurations(String resourceURI) throws IOException, SAXException {
        AssertArgument.isNotNullAndNotEmpty(resourceURI, "resourceURI");
        URIResourceLocator resourceLocator = new URIResourceLocator();
        InputStream resourceConfigStream = resourceLocator.getResource(resourceURI);
        try {
            URI resourceURIObj = new URI(resourceURI);
            this.addConfigurations(URIUtil.getParent(resourceURIObj).toString(), resourceConfigStream);
        }
        catch (URISyntaxException e) {
            logger.error((Object)("Failed to load Smooks resource configuration '" + resourceURI + "'."), (Throwable)e);
        }
        finally {
            resourceConfigStream.close();
        }
    }

    public void addConfigurations(String baseURI, InputStream resourceConfigStream) throws SAXException, IOException {
        this.assertIsConfigurable();
        AssertArgument.isNotNullAndNotEmpty(baseURI, "baseURI");
        AssertArgument.isNotNull(resourceConfigStream, "resourceConfigStream");
        try {
            this.context.getStore().registerResources(baseURI, resourceConfigStream);
        }
        catch (URISyntaxException e) {
            throw new IOException("Failed to read resource configuration. Invalid 'baseURI'.");
        }
    }

    public void addConfigurations(InputStream resourceConfigStream) throws SAXException, IOException {
        this.addConfigurations("./", resourceConfigStream);
    }

    public ExecutionContext createExecutionContext() {
        return this.createExecutionContext(Profile.DEFAULT_PROFILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionContext createExecutionContext(String targetProfile) throws UnknownProfileMemberException {
        if (this.classLoader != null) {
            ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
            CascadingClassLoaderSet newTCCL = new CascadingClassLoaderSet();
            newTCCL.addClassLoader(this.classLoader);
            newTCCL.addClassLoader(originalTCCL);
            Thread.currentThread().setContextClassLoader(newTCCL);
            try {
                if (this.isConfigurable) {
                    this.initializeResourceConfigurations();
                }
                StandaloneExecutionContext standaloneExecutionContext = new StandaloneExecutionContext(targetProfile, this.context, this.visitorConfigMap);
                return standaloneExecutionContext;
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalTCCL);
            }
        }
        if (this.isConfigurable) {
            this.initializeResourceConfigurations();
        }
        return new StandaloneExecutionContext(targetProfile, this.context, this.visitorConfigMap);
    }

    private synchronized void initializeResourceConfigurations() {
        if (!this.isConfigurable) {
            return;
        }
        this.isConfigurable = false;
        try {
            this.context.getStore().setNamespaces();
        }
        catch (SAXPathException e) {
            throw new SmooksConfigurationException("Error configuring namespaces", e);
        }
    }

    public void filterSource(Source source) throws SmooksException {
        this.filterSource(this.createExecutionContext(), source, null);
    }

    public void filterSource(Source source, Result ... results) throws SmooksException {
        this.filterSource(this.createExecutionContext(), source, results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterSource(ExecutionContext executionContext, Source source, Result ... results) throws SmooksException {
        AssertArgument.isNotNull(source, "source");
        AssertArgument.isNotNull(executionContext, "executionContext");
        if (this.classLoader != null) {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoader);
            try {
                this._filter(executionContext, source, results);
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        } else {
            this._filter(executionContext, source, results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _filter(ExecutionContext executionContext, Source source, Result ... results) {
        ExecutionEventListener eventListener = executionContext.getEventListener();
        try {
            Filter.setCurrentExecutionContext(executionContext);
            try {
                FilterBypass filterBypass;
                if (eventListener != null) {
                    eventListener.onEvent(new FilterLifecycleEvent(FilterLifecycleEvent.EventType.STARTED));
                }
                ContentDeliveryConfig deliveryConfig = executionContext.getDeliveryConfig();
                if (results != null && results.length == 1 && results[0] != null && (filterBypass = deliveryConfig.getFilterBypass()) != null && filterBypass.bypass(executionContext, source, results[0])) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("FilterBypass '" + filterBypass.getClass().getName() + "' applied."));
                    }
                    return;
                }
                Filter messageFilter = deliveryConfig.newFilter(executionContext);
                Filter.setFilter(messageFilter);
                try {
                    FilterSource.setSource(executionContext, source);
                    FilterResult.setResults(executionContext, results);
                    BeanContext beanContext = executionContext.getBeanContext();
                    beanContext.addBean("PTIME", (Object)new Time());
                    beanContext.addBean("PUUID", (Object)new UniqueID());
                    for (BeanContextLifecycleObserver observer : this.context.getBeanContextLifecycleObservers()) {
                        beanContext.addObserver(observer);
                    }
                    try {
                        deliveryConfig.executeHandlerInit(executionContext);
                        messageFilter.doFilter();
                    }
                    finally {
                        try {
                            JavaResult javaResult = (JavaResult)FilterResult.getResult(executionContext, JavaResult.class);
                            if (javaResult != null) {
                                javaResult.getResultMap().putAll(executionContext.getBeanContext().getBeanMap());
                            }
                            beanContext.removeBean("PTIME", null);
                            beanContext.removeBean("PUUID", null);
                        }
                        finally {
                            deliveryConfig.executeHandlerCleanup(executionContext);
                        }
                    }
                }
                catch (SmooksException e) {
                    executionContext.setTerminationError(e);
                    throw e;
                }
                catch (Throwable t) {
                    executionContext.setTerminationError(t);
                    throw new SmooksException("Smooks Filtering operation failed.", t);
                }
                finally {
                    messageFilter.cleanup();
                    Filter.removeCurrentFilter();
                }
            }
            finally {
                Filter.removeCurrentExecutionContext();
            }
        }
        finally {
            if (eventListener != null) {
                eventListener.onEvent(new FilterLifecycleEvent(FilterLifecycleEvent.EventType.FINISHED));
            }
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.context;
    }

    public void close() {
        this.context.getStore().close();
    }

    private void assertIsConfigurable() {
        if (!this.isConfigurable) {
            throw new UnsupportedOperationException("Unsupported call to Smooks instance configuration method after Smooks instance has created an ExecutionContext.");
        }
    }
}

