/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.vaadin.ui.layout;

import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.Label;
import java.util.HashMap;
import org.metawidget.layout.decorator.LayoutDecoratorConfig;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.StringUtils;
import org.metawidget.vaadin.ui.VaadinMetawidget;
import org.metawidget.vaadin.ui.layout.VaadinFlatSectionLayoutDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeadingTagLayoutDecorator
extends VaadinFlatSectionLayoutDecorator {
    public HeadingTagLayoutDecorator(LayoutDecoratorConfig<Component, ComponentContainer, VaadinMetawidget> config) {
        super(config);
    }

    @Override
    protected void addSectionWidget(String section, int level, ComponentContainer container, VaadinMetawidget metawidget) {
        String currentActiveSection = (String)metawidget.getClientProperty("currentActiveSection");
        if (currentActiveSection != null && currentActiveSection.equals(section)) {
            return;
        }
        Label label = new Label();
        String localizedSection = metawidget.getLocalizedKey(StringUtils.camelCase(section));
        if (localizedSection == null) {
            label.setValue((Object)section);
        } else {
            label.setValue((Object)localizedSection);
        }
        label.setStyleName("h" + String.valueOf(level + 1));
        HashMap<String, String> attributes = CollectionUtils.newHashMap();
        this.getDelegate().layoutWidget(label, "property", attributes, container, metawidget);
        metawidget.putClientProperty("currentActiveSection", section);
    }
}

