/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swing.widgetprocessor.validator.jgoodies;

import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.Validator;
import com.jgoodies.validation.view.ValidationComponentUtils;
import java.awt.Container;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.metawidget.swing.SwingMetawidget;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.PathUtils;
import org.metawidget.widgetprocessor.iface.AdvancedWidgetProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JGoodiesValidatorProcessor
implements AdvancedWidgetProcessor<JComponent, SwingMetawidget> {
    @Override
    public void onStartBuild(SwingMetawidget metawidget) {
    }

    @Override
    public JComponent processWidget(JComponent component, String elementName, Map<String, String> attributes, SwingMetawidget metawidget) {
        Validator<?> validator;
        boolean required = "true".equals(attributes.get("required"));
        if (required) {
            ValidationComponentUtils.setMandatory((JComponent)component, (boolean)true);
        }
        String path = metawidget.getPath();
        String name = attributes.get("name");
        if ("property".equals(elementName)) {
            path = path + '/' + name;
        }
        if ((validator = this.getValidator(component, attributes, path, metawidget)) == null) {
            if (!required) {
                return component;
            }
        } else {
            ValidationComponentUtils.setMessageKey((JComponent)component, (Object)name);
        }
        this.attachValidator(component, validator, path, metawidget);
        return component;
    }

    @Override
    public void onEndBuild(SwingMetawidget metawidget) {
        ValidationComponentUtils.updateComponentTreeMandatoryAndBlankBackground((Container)metawidget);
        ValidationComponentUtils.updateComponentTreeMandatoryBorder((Container)metawidget);
    }

    protected Validator<?> getValidator(JComponent component, Map<String, String> attributes, String path, SwingMetawidget metawidget) {
        return null;
    }

    protected void attachValidator(final JComponent component, final Validator<?> validator, final String path, final SwingMetawidget metawidget) {
        component.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                JGoodiesValidatorProcessor.this.validateChange(component, validator, path, metawidget);
            }
        });
    }

    protected void validateChange(JComponent component, Validator<?> validator, String path, SwingMetawidget metawidget) {
        String[] names = PathUtils.parsePath(path).getNamesAsArray();
        HashMap<JComponent, ValidationResult> validationResults = (HashMap<JComponent, ValidationResult>)metawidget.getClientProperty(JGoodiesValidatorProcessor.class);
        if (validationResults == null) {
            validationResults = CollectionUtils.newHashMap();
            metawidget.putClientProperty(JGoodiesValidatorProcessor.class, validationResults);
        }
        Object value = metawidget.getValue(names);
        if (validator != null) {
            Validator<?> objectValidator = validator;
            ValidationResult validationResult = objectValidator.validate(value);
            if (validationResult == null) {
                validationResults.remove(component);
            } else {
                validationResults.put(component, validationResult);
            }
        }
        ValidationResult validationResult = new ValidationResult();
        for (ValidationResult previousValidationResult : validationResults.values()) {
            validationResult.addAllFrom(previousValidationResult);
        }
        this.updateComponent(component, validationResult, metawidget);
    }

    protected void updateComponent(JComponent component, ValidationResult validationResult, SwingMetawidget metawidget) {
        if (ValidationComponentUtils.isMandatory((JComponent)component)) {
            ValidationComponentUtils.updateComponentTreeMandatoryAndBlankBackground((Container)metawidget);
        }
        ValidationComponentUtils.updateComponentTreeSeverityBackground((Container)metawidget, (ValidationResult)validationResult);
    }
}

