/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.layout.decorator;

import java.util.Map;
import org.metawidget.layout.decorator.LayoutDecoratorConfig;
import org.metawidget.layout.iface.AdvancedLayout;
import org.metawidget.layout.iface.Layout;
import org.metawidget.layout.iface.LayoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LayoutDecorator<W, C extends W, M extends C>
implements AdvancedLayout<W, C, M> {
    private final Layout<W, C, M> mDelegate;

    protected LayoutDecorator(LayoutDecoratorConfig<W, C, M> config) {
        this.mDelegate = config.getLayout();
        if (this.mDelegate == null) {
            throw LayoutException.newException(this.getClass().getName() + " needs a Layout to decorate (use " + config.getClass().getName() + ".setLayout)");
        }
    }

    @Override
    public void onStartBuild(M metawidget) {
        if (this.getDelegate() instanceof AdvancedLayout) {
            ((AdvancedLayout)this.getDelegate()).onStartBuild(metawidget);
        }
    }

    @Override
    public void startContainerLayout(C container, M metawidget) {
        if (this.getDelegate() instanceof AdvancedLayout) {
            ((AdvancedLayout)this.getDelegate()).startContainerLayout(container, metawidget);
        }
    }

    @Override
    public void layoutWidget(W component, String elementName, Map<String, String> attributes, C container, M metawidget) {
        this.getDelegate().layoutWidget(component, elementName, attributes, container, metawidget);
    }

    @Override
    public void endContainerLayout(C container, M metawidget) {
        if (this.getDelegate() instanceof AdvancedLayout) {
            ((AdvancedLayout)this.getDelegate()).endContainerLayout(container, metawidget);
        }
    }

    @Override
    public void onEndBuild(M metawidget) {
        if (this.getDelegate() instanceof AdvancedLayout) {
            ((AdvancedLayout)this.getDelegate()).onEndBuild(metawidget);
        }
    }

    protected Layout<W, C, M> getDelegate() {
        return this.mDelegate;
    }
}

