/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspectionresultprocessor.json.schema;

import java.util.Map;
import org.metawidget.inspectionresultprocessor.impl.BaseInspectionResultProcessor;
import org.metawidget.inspectionresultprocessor.json.schema.JsonSchemaMappingProcessorConfig;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.XmlUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonSchemaMappingProcessor<M>
extends BaseInspectionResultProcessor<M> {
    private String[] mRemoveAttributes;

    public JsonSchemaMappingProcessor() {
        this(new JsonSchemaMappingProcessorConfig());
    }

    public JsonSchemaMappingProcessor(JsonSchemaMappingProcessorConfig config) {
        this.mRemoveAttributes = config.getRemoveAttributes();
    }

    @Override
    protected void processTraits(Element entity, M metawidget, Object toInspect, String type, String ... names) {
        this.mapAttributes(entity);
        this.removeAttributes(entity);
        Element trait = XmlUtils.getFirstChildElement(entity);
        while (trait != null) {
            if (this.shouldRemove(trait)) {
                Element toRemove = trait;
                trait = XmlUtils.getNextSiblingElement(trait);
                entity.removeChild(toRemove);
                continue;
            }
            Map<String, String> attributes = XmlUtils.getAttributesAsMap(trait);
            if (trait.getChildNodes().getLength() > 0 && attributes.containsKey("name")) {
                this.processTraits(trait, metawidget, toInspect, type, ArrayUtils.add(names, attributes.get("name")));
            }
            this.mapAttributes(trait);
            this.removeAttributes(trait);
            trait = XmlUtils.getNextSiblingElement(trait);
        }
    }

    protected boolean shouldRemove(Element element) {
        return "true".equals(element.getAttribute("hidden"));
    }

    protected void mapAttributes(Element element) {
        this.mapAttribute(element, "label", "title");
        this.mapAttribute(element, "lookup", "enum");
        this.mapAttribute(element, "lookup-labels", "enumTitles");
        this.mapAttribute(element, "minimum-value", "minimum");
        this.mapAttribute(element, "maximum-value", "maximum");
        this.mapAttribute(element, "minimum-length", "minLength");
        this.mapAttribute(element, "maximum-length", "maxLength");
    }

    protected void removeAttributes(Element element) {
        if (this.mRemoveAttributes == null) {
            return;
        }
        for (String removeAttribute : this.mRemoveAttributes) {
            element.removeAttribute(removeAttribute);
        }
    }

    private void mapAttribute(Element element, String in, String out) {
        if (!element.hasAttribute(in)) {
            return;
        }
        element.setAttribute(out, element.getAttribute(in));
        element.removeAttribute(in);
    }
}

