/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.gwt.client.widgetprocessor.binding.simple;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.metawidget.gwt.client.ui.GwtMetawidget;
import org.metawidget.gwt.client.ui.Stub;
import org.metawidget.gwt.client.widgetprocessor.binding.simple.Converter;
import org.metawidget.gwt.client.widgetprocessor.binding.simple.SimpleBindingProcessorAdapter;
import org.metawidget.gwt.client.widgetprocessor.binding.simple.SimpleBindingProcessorConfig;
import org.metawidget.gwt.client.widgetprocessor.binding.simple.SimpleConverter;
import org.metawidget.util.simple.PathUtils;
import org.metawidget.widgetprocessor.iface.AdvancedWidgetProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleBindingProcessor
implements AdvancedWidgetProcessor<Widget, GwtMetawidget> {
    private final Map<Class<?>, SimpleBindingProcessorAdapter<?>> mAdapters;
    private final Map<Class<?>, Converter<?>> mConverters;

    public SimpleBindingProcessor() {
        this(new SimpleBindingProcessorConfig());
    }

    public SimpleBindingProcessor(SimpleBindingProcessorConfig config) {
        this.mAdapters = config.getAdapters() == null ? null : new HashMap(config.getAdapters());
        this.mConverters = new HashMap();
        SimpleConverter simpleConverter = new SimpleConverter();
        this.mConverters.put(Boolean.class, simpleConverter);
        this.mConverters.put(Character.class, simpleConverter);
        this.mConverters.put(Number.class, simpleConverter);
        if (config.getConverters() != null) {
            this.mConverters.putAll(config.getConverters());
        }
    }

    @Override
    public void onStartBuild(GwtMetawidget metawidget) {
        metawidget.putClientProperty(SimpleBindingProcessor.class, null);
    }

    @Override
    public Widget processWidget(Widget widget, String elementName, Map<String, String> attributes, final GwtMetawidget metawidget) {
        if (widget instanceof GwtMetawidget) {
            State state = this.getState(metawidget);
            if (state.nestedMetawidgets == null) {
                state.nestedMetawidgets = new HashSet<GwtMetawidget>();
            }
            state.nestedMetawidgets.add((GwtMetawidget)widget);
            return widget;
        }
        if (widget instanceof Stub || widget instanceof FlexTable) {
            return widget;
        }
        String path = metawidget.getPath();
        if ("property".equals(elementName) || "action".equals(elementName)) {
            path = path + '/' + attributes.get("name");
        }
        final String[] names = PathUtils.parsePath(path).getNamesAsArray();
        if ("action".equals(elementName)) {
            if (!(widget instanceof FocusWidget)) {
                throw new RuntimeException("SimpleBindingProcessor only supports binding actions to FocusWidgets - '" + attributes.get("name") + "' is using a " + widget.getClass().getName());
            }
            if (((FocusWidget)widget).isEnabled()) {
                FocusWidget focusWidget = (FocusWidget)widget;
                focusWidget.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        Object toInvokeOn = metawidget.getToInspect();
                        if (toInvokeOn == null) {
                            return;
                        }
                        Class<?> classToBindTo = toInvokeOn.getClass();
                        Object adapter = SimpleBindingProcessor.this.getAdapter(classToBindTo);
                        if (adapter == null) {
                            throw new RuntimeException("Don't know how to bind to a " + classToBindTo);
                        }
                        adapter.invokeAction(toInvokeOn, names);
                    }
                });
            }
            return widget;
        }
        Object toInspect = metawidget.getToInspect();
        if (toInspect == null) {
            return widget;
        }
        Class<?> classToBindTo = toInspect.getClass();
        Object adapter = this.getAdapter(classToBindTo);
        if (adapter == null) {
            throw new RuntimeException("Don't know how to bind to a " + classToBindTo);
        }
        Object value = adapter.getProperty(toInspect, names);
        Class<?> propertyType = adapter.getPropertyType(toInspect, names);
        Object converter = this.getConverter(propertyType);
        if (converter != null) {
            value = converter.convertForWidget(widget, (Object)value);
        }
        try {
            metawidget.setValue(value, widget);
            if ("true".equals(attributes.get("no-setter"))) {
                return widget;
            }
            State state = this.getState(metawidget);
            if (state.bindings == null) {
                state.bindings = new HashSet<Object[]>();
            }
            state.bindings.add(new Object[]{widget, names, converter, propertyType});
        }
        catch (Exception e) {
            Window.alert((String)(path + ": " + e.getMessage()));
        }
        return widget;
    }

    public void rebind(Object toRebind, GwtMetawidget metawidget) {
        metawidget.updateToInspectWithoutInvalidate(toRebind);
        State state = this.getState(metawidget);
        if (state.bindings != null) {
            Class<?> classToRebind = toRebind.getClass();
            Object adapter = this.getAdapter(classToRebind);
            if (adapter == null) {
                throw new RuntimeException("Don't know how to rebind to a " + classToRebind);
            }
            for (Object[] binding : state.bindings) {
                Widget widget = (Widget)binding[0];
                String[] names = (String[])binding[1];
                Converter converter = (Converter)binding[2];
                Object value = adapter.getProperty((Object)toRebind, names);
                if (converter != null) {
                    value = converter.convertForWidget(widget, value);
                }
                metawidget.setValue(value, widget);
            }
        }
        if (state.nestedMetawidgets != null) {
            for (GwtMetawidget nestedMetawidget : state.nestedMetawidgets) {
                this.rebind(toRebind, nestedMetawidget);
            }
        }
    }

    public void save(GwtMetawidget metawidget) {
        State state = this.getState(metawidget);
        if (state.bindings != null) {
            Object toSave = metawidget.getToInspect();
            if (toSave == null) {
                return;
            }
            Class<?> classToBindTo = toSave.getClass();
            Object adapter = this.getAdapter(classToBindTo);
            if (adapter == null) {
                throw new RuntimeException("Don't know how to save to a " + classToBindTo);
            }
            for (Object[] binding : state.bindings) {
                Widget widget = (Widget)binding[0];
                String[] names = (String[])binding[1];
                Converter converter = (Converter)binding[2];
                Class type = (Class)binding[3];
                Object value = metawidget.getValue(widget);
                if (value != null && converter != null) {
                    value = converter.convertFromWidget(widget, value, type);
                }
                adapter.setProperty(toSave, value, names);
            }
        }
        if (state.nestedMetawidgets != null) {
            for (GwtMetawidget nestedMetawidget : state.nestedMetawidgets) {
                this.save(nestedMetawidget);
            }
        }
    }

    @Override
    public void onEndBuild(GwtMetawidget metawidget) {
    }

    protected <T extends SimpleBindingProcessorAdapter<?>> T getAdapter(Class<?> classToBindTo) {
        if (this.mAdapters == null) {
            return null;
        }
        for (Class<?> classTraversal = classToBindTo; classTraversal != null; classTraversal = classTraversal.getSuperclass()) {
            SimpleBindingProcessorAdapter<?> adapter = this.mAdapters.get(classTraversal);
            if (adapter == null) continue;
            return (T)adapter;
        }
        return null;
    }

    private <T extends Converter<?>> T getConverter(Class<?> classToConvert) {
        for (Class<?> classTraversal = classToConvert; classTraversal != null; classTraversal = classTraversal.getSuperclass()) {
            Converter<?> converter = this.mConverters.get(classTraversal);
            if (converter == null) continue;
            return (T)converter;
        }
        return null;
    }

    State getState(GwtMetawidget metawidget) {
        State state = (State)metawidget.getClientProperty(SimpleBindingProcessor.class);
        if (state == null) {
            state = new State();
            metawidget.putClientProperty(SimpleBindingProcessor.class, state);
        }
        return state;
    }

    static class State {
        Set<Object[]> bindings;
        Set<GwtMetawidget> nestedMetawidgets;

        State() {
        }
    }
}

