/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.faces.component.html.widgetbuilder.primefaces;

import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;
import org.metawidget.faces.FacesUtils;
import org.metawidget.faces.component.UIMetawidget;
import org.metawidget.faces.component.UIStub;
import org.metawidget.faces.component.html.widgetbuilder.HtmlWidgetBuilder;
import org.metawidget.util.WidgetBuilderUtils;
import org.primefaces.component.autocomplete.AutoComplete;
import org.primefaces.component.calendar.Calendar;
import org.primefaces.component.commandbutton.CommandButton;
import org.primefaces.component.slider.Slider;
import org.primefaces.component.spinner.Spinner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimeFacesWidgetBuilder
extends HtmlWidgetBuilder {
    @Override
    public UIComponent buildWidget(String elementName, Map<String, String> attributes, UIMetawidget metawidget) {
        if ("true".equals(attributes.get("hidden"))) {
            return null;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        if ("action".equals(elementName)) {
            CommandButton button = (CommandButton)application.createComponent("org.primefaces.component.CommandButton");
            button.setValue((Object)metawidget.getLabelString(attributes));
            button.setAjax(false);
            return button;
        }
        Class<?> clazz = WidgetBuilderUtils.getActualClassOrType(attributes, null);
        boolean readOnly = WidgetBuilderUtils.isReadOnly(attributes);
        if (!readOnly) {
            String facesLookup = attributes.get("faces-lookup");
            if (facesLookup != null && !"".equals(facesLookup)) {
                Object component = clazz != null && (List.class.isAssignableFrom(clazz) || clazz.isArray()) ? FacesUtils.createComponent("org.primefaces.component.SelectManyCheckbox", "org.primefaces.component.SelectManyCheckboxRenderer") : FacesUtils.createComponent("org.primefaces.component.SelectOneMenu", "org.primefaces.component.SelectOneMenuRenderer");
                this.initFacesSelect((UIComponent)component, facesLookup, attributes, metawidget);
                return component;
            }
            if (clazz != null) {
                String facesSuggest;
                UIComponent ranged;
                if (Boolean.class.equals(clazz) && "true".equals(attributes.get("required"))) {
                    return null;
                }
                String lookup = attributes.get("lookup");
                if (lookup != null && !"".equals(lookup)) {
                    Object component = List.class.isAssignableFrom(clazz) || clazz.isArray() ? FacesUtils.createComponent("org.primefaces.component.SelectManyCheckbox", "org.primefaces.component.SelectManyCheckboxRenderer") : FacesUtils.createComponent("org.primefaces.component.SelectOneMenu", "org.primefaces.component.SelectOneMenuRenderer");
                    this.initStaticSelect((UIComponent)component, lookup, clazz, attributes, metawidget);
                    return component;
                }
                if (clazz.isPrimitive()) {
                    if (Boolean.TYPE.equals(clazz) || Character.TYPE.equals(clazz)) {
                        return null;
                    }
                    UIComponent ranged2 = this.createRanged(attributes);
                    if (ranged2 != null) {
                        return ranged2;
                    }
                    Spinner spinner = (Spinner)FacesUtils.createComponent("org.primefaces.component.Spinner", "org.primefaces.component.SpinnerRenderer");
                    String minimumValue = attributes.get("minimum-value");
                    if (minimumValue != null && !"".equals(minimumValue)) {
                        spinner.setMin(Double.parseDouble(minimumValue));
                    } else if (Byte.TYPE.equals(clazz)) {
                        spinner.setMin(-128.0);
                    } else if (Short.TYPE.equals(clazz)) {
                        spinner.setMin(-32768.0);
                    } else if (Integer.TYPE.equals(clazz)) {
                        spinner.setMin(-2.147483648E9);
                    } else if (Long.TYPE.equals(clazz)) {
                        spinner.setMin(-9.223372036854776E18);
                    } else if (Float.TYPE.equals(clazz)) {
                        spinner.setMin(-3.4028234663852886E38);
                    } else if (Double.TYPE.equals(clazz)) {
                        spinner.setMin(-1.7976931348623157E308);
                    }
                    String maximumValue = attributes.get("maximum-value");
                    if (maximumValue != null && !"".equals(maximumValue)) {
                        spinner.setMax(Double.parseDouble(maximumValue));
                    } else if (Byte.TYPE.equals(clazz)) {
                        spinner.setMax(127.0);
                    } else if (Short.TYPE.equals(clazz)) {
                        spinner.setMax(32767.0);
                    } else if (Integer.TYPE.equals(clazz)) {
                        spinner.setMax(2.147483647E9);
                    } else if (Long.TYPE.equals(clazz)) {
                        spinner.setMax(9.223372036854776E18);
                    } else if (Float.TYPE.equals(clazz)) {
                        spinner.setMax(3.4028234663852886E38);
                    } else if (Double.TYPE.equals(clazz)) {
                        spinner.setMax(Double.MAX_VALUE);
                    }
                    if (Float.TYPE.equals(clazz) || Double.TYPE.equals(clazz)) {
                        spinner.setStepFactor(0.1);
                    }
                    return spinner;
                }
                if (Date.class.isAssignableFrom(clazz)) {
                    Calendar calendar = (Calendar)FacesUtils.createComponent("org.primefaces.component.Calendar", "org.primefaces.component.CalendarRenderer");
                    if (attributes.containsKey("datetime-pattern")) {
                        calendar.setPattern(attributes.get("datetime-pattern"));
                    }
                    if (attributes.containsKey("locale")) {
                        calendar.setLocale((Object)new Locale(attributes.get("locale")));
                    }
                    if (attributes.containsKey("time-zone")) {
                        calendar.setTimeZone((Object)TimeZone.getTimeZone(attributes.get("time-zone")));
                    }
                    return calendar;
                }
                if (Number.class.isAssignableFrom(clazz) && (ranged = this.createRanged(attributes)) != null) {
                    return ranged;
                }
                if (String.class.equals(clazz) && (facesSuggest = attributes.get("faces-suggest")) != null) {
                    AutoComplete autoComplete = (AutoComplete)FacesUtils.createComponent("org.primefaces.component.AutoComplete", "org.primefaces.component.autocomplete.AutoCompleteRenderer");
                    autoComplete.setCompleteMethod(application.getExpressionFactory().createMethodExpression(context.getELContext(), facesSuggest, Object.class, new Class[]{String.class}));
                    return autoComplete;
                }
            }
        }
        return null;
    }

    private UIComponent createRanged(Map<String, String> attributes) {
        String minimumValue = attributes.get("minimum-value");
        String maximumValue = attributes.get("maximum-value");
        if (minimumValue != null && !"".equals(minimumValue) && maximumValue != null && !"".equals(maximumValue)) {
            FacesContext context = FacesContext.getCurrentInstance();
            Application application = context.getApplication();
            UIStub stub = (UIStub)application.createComponent("org.metawidget.Stub");
            HtmlInputText inputText = (HtmlInputText)application.createComponent("javax.faces.HtmlInputText");
            inputText.setId(FacesUtils.createUniqueId());
            stub.getChildren().add(inputText);
            Slider slider = (Slider)FacesUtils.createComponent("org.primefaces.component.Slider", "org.primefaces.component.SliderRenderer");
            slider.setMinValue(Integer.parseInt(minimumValue));
            slider.setMaxValue(Integer.parseInt(maximumValue));
            slider.setFor(inputText.getId());
            stub.getChildren().add(slider);
            return stub;
        }
        return null;
    }
}

