/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.android.widget.widgetprocessor.binding.simple;

import android.view.View;
import android.widget.CheckBox;
import android.widget.DatePicker;
import android.widget.Spinner;
import android.widget.TextView;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.metawidget.android.widget.AndroidMetawidget;
import org.metawidget.android.widget.widgetprocessor.binding.BindingConverter;
import org.metawidget.android.widget.widgetprocessor.binding.simple.Converter;
import org.metawidget.android.widget.widgetprocessor.binding.simple.SimpleBindingProcessorConfig;
import org.metawidget.android.widget.widgetprocessor.binding.simple.SimpleConverter;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.WidgetBuilderUtils;
import org.metawidget.util.simple.PathUtils;
import org.metawidget.widgetprocessor.iface.AdvancedWidgetProcessor;
import org.metawidget.widgetprocessor.iface.WidgetProcessorException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleBindingProcessor
implements AdvancedWidgetProcessor<View, AndroidMetawidget>,
BindingConverter {
    private final Map<Class<?>, Converter<?>> mConverters = CollectionUtils.newWeakHashMap();

    public SimpleBindingProcessor() {
        this(new SimpleBindingProcessorConfig());
    }

    public SimpleBindingProcessor(SimpleBindingProcessorConfig config) {
        SimpleConverter simpleConverter = new SimpleConverter();
        this.mConverters.put(Boolean.class, simpleConverter);
        this.mConverters.put(Character.class, simpleConverter);
        this.mConverters.put(Number.class, simpleConverter);
        this.mConverters.put(Byte.TYPE, simpleConverter);
        this.mConverters.put(Short.TYPE, simpleConverter);
        this.mConverters.put(Integer.TYPE, simpleConverter);
        this.mConverters.put(Long.TYPE, simpleConverter);
        this.mConverters.put(Float.TYPE, simpleConverter);
        this.mConverters.put(Double.TYPE, simpleConverter);
        this.mConverters.put(Boolean.TYPE, simpleConverter);
        this.mConverters.put(Character.TYPE, simpleConverter);
        if (config.getConverters() != null) {
            this.mConverters.putAll(config.getConverters());
        }
    }

    @Override
    public void onStartBuild(AndroidMetawidget metawidget) {
        metawidget.putClientProperty(SimpleBindingProcessor.class, null);
    }

    @Override
    public View processWidget(View view, String elementName, Map<String, String> attributes, AndroidMetawidget metawidget) {
        String[] names;
        if (view instanceof AndroidMetawidget) {
            State state = this.getState(metawidget);
            if (state.nestedMetawidgets == null) {
                state.nestedMetawidgets = CollectionUtils.newHashSet();
            }
            state.nestedMetawidgets.add((AndroidMetawidget)view);
            return view;
        }
        if ("true".equals(attributes.get("no-getter"))) {
            return view;
        }
        String type = attributes.get("type");
        if (type == null) {
            return view;
        }
        if (!(view instanceof CheckBox || view instanceof TextView || view instanceof DatePicker || view instanceof Spinner)) {
            return view;
        }
        Object value = metawidget.getToInspect();
        if (value == null) {
            return view;
        }
        String path = metawidget.getPath();
        if ("property".equals(elementName) || "action".equals(elementName)) {
            path = path + '/' + attributes.get("name");
        }
        for (String name : names = PathUtils.parsePath(path).getNamesAsArray()) {
            value = ClassUtils.getProperty(value, name);
        }
        Class<?> propertyType = ClassUtils.niceForName(type);
        Object converter = this.getConverter(propertyType);
        if (converter != null) {
            value = converter.convertForView(view, value);
        }
        try {
            metawidget.setValue(value, view);
            if (WidgetBuilderUtils.isReadOnly(attributes)) {
                return view;
            }
            State state = this.getState(metawidget);
            if (state.bindings == null) {
                state.bindings = new HashSet<Object[]>();
            }
            state.bindings.add(new Object[]{view, names, converter, propertyType});
        }
        catch (Exception e) {
            throw WidgetProcessorException.newException(e);
        }
        return view;
    }

    public void save(AndroidMetawidget metawidget) {
        State state = this.getState(metawidget);
        if (state.bindings != null) {
            Object toSave = metawidget.getToInspect();
            if (toSave == null) {
                return;
            }
            for (Object[] binding : state.bindings) {
                View view = (View)binding[0];
                String[] names = (String[])binding[1];
                Converter converter = (Converter)binding[2];
                Class propertyType = (Class)binding[3];
                Object value = metawidget.getValue(view);
                if (converter != null) {
                    value = converter.convertFromView(view, value, propertyType);
                }
                Object parent = toSave;
                int length = names.length;
                for (int loop = 0; loop < length - 1; ++loop) {
                    if ((parent = ClassUtils.getProperty(parent, names[loop])) != null) continue;
                    return;
                }
                ClassUtils.setProperty(parent, names[length - 1], value);
            }
        }
        if (state.nestedMetawidgets != null) {
            for (AndroidMetawidget nestedMetawidget : state.nestedMetawidgets) {
                this.save(nestedMetawidget);
            }
        }
    }

    @Override
    public void onEndBuild(AndroidMetawidget metawidget) {
    }

    @Override
    public Object convertFromString(String value, Class<?> expectedType) {
        Object converterFromString = this.getConverter(expectedType);
        if (converterFromString != null) {
            return converterFromString.convertFromView(null, value, expectedType);
        }
        return value;
    }

    private <T extends Converter<?>> T getConverter(Class<?> classToConvert) {
        for (Class<?> classTraversal = classToConvert; classTraversal != null; classTraversal = classTraversal.getSuperclass()) {
            Converter<?> converter = this.mConverters.get(classTraversal);
            if (converter == null) continue;
            return (T)converter;
        }
        return null;
    }

    State getState(AndroidMetawidget metawidget) {
        State state = (State)metawidget.getClientProperty(SimpleBindingProcessor.class);
        if (state == null) {
            state = new State();
            metawidget.putClientProperty(SimpleBindingProcessor.class, state);
        }
        return state;
    }

    static class State {
        Set<Object[]> bindings;
        Set<AndroidMetawidget> nestedMetawidgets;

        State() {
        }
    }
}

