/*
 * Decompiled with CFR 0.152.
 */
package org.messaginghub.pooled.jms.util;

import jakarta.jms.JMSException;
import jakarta.jms.MessageFormatException;
import org.messaginghub.pooled.jms.util.TypeConversionSupport;

public class JMSMessagePropertySupport {
    public static <T> T convertPropertyTo(String name, Object value, Class<T> target) throws JMSException {
        if (value == null) {
            if (Boolean.class.equals(target)) {
                return (T)Boolean.FALSE;
            }
            if (Float.class.equals(target) || Double.class.equals(target)) {
                throw new NullPointerException("property " + name + " was null");
            }
            if (Number.class.isAssignableFrom(target)) {
                throw new NumberFormatException("property " + name + " was null");
            }
            return null;
        }
        Object rc = TypeConversionSupport.convert(value, target);
        if (rc == null) {
            throw new MessageFormatException("Property " + name + " was a " + value.getClass().getName() + " and cannot be read as a " + target.getName());
        }
        return (T)rc;
    }

    public static void checkPropertyNameIsValid(String propertyName, boolean validateNames) throws IllegalArgumentException {
        if (propertyName == null) {
            throw new IllegalArgumentException("Property name must not be null");
        }
        if (propertyName.length() == 0) {
            throw new IllegalArgumentException("Property name must not be the empty string");
        }
        if (validateNames) {
            JMSMessagePropertySupport.checkIdentifierLetterAndDigitRequirements(propertyName);
            JMSMessagePropertySupport.checkIdentifierIsntNullTrueFalse(propertyName);
            JMSMessagePropertySupport.checkIdentifierIsntLogicOperator(propertyName);
        }
    }

    public static void checkIdentifierIsntLogicOperator(String identifier) {
        if ("NOT".equals(identifier) || "AND".equals(identifier) || "OR".equals(identifier) || "BETWEEN".equals(identifier) || "LIKE".equals(identifier) || "IN".equals(identifier) || "IS".equals(identifier) || "ESCAPE".equals(identifier)) {
            throw new IllegalArgumentException("Identifier not allowed in JMS: '" + identifier + "'");
        }
    }

    public static void checkIdentifierIsntNullTrueFalse(String identifier) {
        if ("NULL".equals(identifier) || "TRUE".equals(identifier) || "FALSE".equals(identifier)) {
            throw new IllegalArgumentException("Identifier not allowed in JMS: '" + identifier + "'");
        }
    }

    public static void checkIdentifierLetterAndDigitRequirements(String identifier) {
        char startChar = identifier.charAt(0);
        if (!Character.isJavaIdentifierStart(startChar)) {
            throw new IllegalArgumentException("Identifier does not begin with a valid JMS identifier start character: '" + identifier + "' ");
        }
        int length = identifier.length();
        for (int i = 1; i < length; ++i) {
            char ch = identifier.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) continue;
            throw new IllegalArgumentException("Identifier contains invalid JMS identifier character '" + ch + "': '" + identifier + "' ");
        }
    }

    public static void checkValidObject(Object value) throws MessageFormatException {
        boolean valid;
        boolean bl = valid = value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof Character || value instanceof String || value == null;
        if (!valid) {
            throw new MessageFormatException("Only objectified primitive objects and String types are allowed but was: " + value + " type: " + value.getClass());
        }
    }
}

