/*
 * Decompiled with CFR 0.152.
 */
package org.messaginghub.pooled.jms.pool;

public final class PooledConnectionKey {
    private final String userName;
    private final String password;
    private int hash;

    public PooledConnectionKey(String userName, String password) {
        this.password = password;
        this.userName = userName;
        this.hash = 31;
        if (userName != null) {
            this.hash += userName.hashCode();
        }
        this.hash *= 31;
        if (password != null) {
            this.hash += password.hashCode();
        }
    }

    public String getPassword() {
        return this.password;
    }

    public String getUserName() {
        return this.userName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.hash;
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PooledConnectionKey other = (PooledConnectionKey)obj;
        if (this.hash != other.hash) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        return !(this.userName == null ? other.userName != null : !this.userName.equals(other.userName));
    }
}

