/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.predic8.membrane.core.http.Response;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.Socket;
import java.util.HashMap;
import javax.mail.internet.ParseException;
import javax.net.ssl.SSLSocket;

public class Util {
    public static void shutdownOutput(Socket socket) throws IOException {
        if (!(socket instanceof SSLSocket || socket.isClosed() || socket.isOutputShutdown())) {
            socket.shutdownOutput();
        }
    }

    public static void shutdownInput(Socket socket) throws IOException {
        if (!(socket instanceof SSLSocket || socket.isClosed() || socket.isInputShutdown())) {
            socket.shutdownInput();
        }
    }

    public static HashMap<String, String> parseSimpleJSONResponse(Response g) throws IOException, JsonParseException, ParseException {
        HashMap<String, String> values = new HashMap<String, String>();
        String contentType = g.getHeader().getFirstValue("Content-Type");
        if (contentType != null && g.getHeader().getContentTypeObject().match("application/json")) {
            JsonFactory jsonFactory = new JsonFactory();
            JsonParser jp = jsonFactory.createParser((Reader)new InputStreamReader(g.getBodyAsStreamDecoded()));
            String name = null;
            while (jp.nextToken() != null) {
                switch (jp.getCurrentToken()) {
                    case FIELD_NAME: {
                        name = jp.getCurrentName();
                        break;
                    }
                    case VALUE_STRING: {
                        values.put(name, jp.getText());
                        break;
                    }
                    case VALUE_NUMBER_INT: {
                        values.put(name, "" + jp.getLongValue());
                    }
                }
            }
        }
        return values;
    }
}

