/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.util;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.util.URI;
import com.predic8.membrane.core.util.URIFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URLParamUtil {
    private static Pattern paramsPat = Pattern.compile("([^=]*)=?(.*)");

    public static Map<String, String> getParams(URIFactory uriFactory, Exchange exc) throws Exception {
        URI jUri = uriFactory.create(exc.getRequest().getUri());
        String q = jUri.getRawQuery();
        if (q == null) {
            if (URLParamUtil.hasNoFormParams(exc)) {
                return new HashMap<String, String>();
            }
            q = new String(exc.getRequest().getBody().getContent(), exc.getRequest().getCharset());
        }
        return URLParamUtil.parseQueryString(q);
    }

    public static String getStringParam(URIFactory uriFactory, Exchange exc, String name) throws Exception {
        return URLParamUtil.getParams(uriFactory, exc).get(name);
    }

    public static int getIntParam(URIFactory uriFactory, Exchange exc, String name) throws Exception {
        return Integer.parseInt(URLParamUtil.getParams(uriFactory, exc).get(name));
    }

    private static boolean hasNoFormParams(Exchange exc) throws IOException {
        return !"application/x-www-form-urlencoded".equals(exc.getRequest().getHeader().getContentType()) || exc.getRequest().isBodyEmpty();
    }

    public static String createQueryString(String ... params) {
        try {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < params.length; i += 2) {
                if (i != 0) {
                    buf.append('&');
                }
                buf.append(URLEncoder.encode(params[i], "UTF-8"));
                buf.append('=');
                buf.append(URLEncoder.encode(params[i + 1], "UTF-8"));
            }
            return buf.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> parseQueryString(String query) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            for (String p : query.split("&")) {
                Matcher m = paramsPat.matcher(p);
                m.matches();
                params.put(URLDecoder.decode(m.group(1), "UTF-8"), URLDecoder.decode(m.group(2), "UTF-8"));
            }
            return params;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String encode(Map<String, String> params) {
        try {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Map.Entry<String, String> p : params.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    sb.append("&");
                }
                sb.append(URLEncoder.encode(p.getKey(), "UTF-8"));
                sb.append("=");
                sb.append(URLEncoder.encode(p.getValue(), "UTF-8"));
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static class ParamBuilder {
        HashMap<String, String> params = new HashMap();

        public ParamBuilder add(String key, String value) {
            this.params.put(key, value);
            return this;
        }

        public String build() {
            return URLParamUtil.encode(this.params);
        }
    }
}

