/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.util;

import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.multipart.XOPReconstitutor;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOAPUtil {
    private static final Logger log = LoggerFactory.getLogger((String)SOAPUtil.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSOAP(XMLInputFactory xmlInputFactory, XOPReconstitutor xopr, Message msg) {
        try {
            XMLEventReader parser;
            XMLInputFactory xMLInputFactory = xmlInputFactory;
            synchronized (xMLInputFactory) {
                parser = xmlInputFactory.createXMLEventReader(xopr.reconstituteIfNecessary(msg));
            }
            while (parser.hasNext()) {
                XMLEvent event = parser.nextEvent();
                if (!event.isStartElement()) continue;
                QName name = ((StartElement)event).getName();
                return ("http://schemas.xmlsoap.org/soap/envelope/".equals(name.getNamespaceURI()) || "http://www.w3.org/2003/05/soap-envelope".equals(name.getNamespaceURI())) && "Envelope".equals(name.getLocalPart());
            }
        }
        catch (Exception e) {
            log.warn("Ignoring exception: ", (Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isFault(XMLInputFactory xmlInputFactory, XOPReconstitutor xopr, Message msg) {
        int state = 0;
        try {
            XMLEventReader parser;
            XMLInputFactory xMLInputFactory = xmlInputFactory;
            synchronized (xMLInputFactory) {
                parser = xmlInputFactory.createXMLEventReader(xopr.reconstituteIfNecessary(msg));
            }
            block10: while (parser.hasNext()) {
                XMLEvent event = parser.nextEvent();
                if (event.isStartElement()) {
                    String expected;
                    QName name = ((StartElement)event).getName();
                    if (!"http://schemas.xmlsoap.org/soap/envelope/".equals(name.getNamespaceURI()) && !"http://www.w3.org/2003/05/soap-envelope".equals(name.getNamespaceURI())) {
                        return false;
                    }
                    if ("Header".equals(name.getLocalPart())) {
                        int stack = 0;
                        while (parser.hasNext()) {
                            event = parser.nextEvent();
                            if (event.isStartElement()) {
                                ++stack;
                            }
                            if (!event.isEndElement()) continue;
                            if (stack == 0) continue block10;
                            --stack;
                        }
                        continue;
                    }
                    switch (state) {
                        case 0: {
                            expected = "Envelope";
                            break;
                        }
                        case 1: {
                            expected = "Body";
                            break;
                        }
                        case 2: {
                            expected = "Fault";
                            break;
                        }
                        default: {
                            return false;
                        }
                    }
                    if (expected.equals(name.getLocalPart())) {
                        if (state == 2) {
                            return true;
                        }
                        ++state;
                    } else {
                        return false;
                    }
                }
                if (!event.isEndElement()) continue;
                return false;
            }
        }
        catch (Exception e) {
            log.warn("Ignoring exception: ", (Throwable)e);
        }
        return false;
    }
}

