/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.util;

import com.predic8.membrane.core.Constants;
import com.predic8.membrane.core.http.Chunk;
import com.predic8.membrane.core.http.Header;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.transport.http.EOFWhileReadingLineException;
import com.predic8.membrane.core.util.ByteUtil;
import com.predic8.membrane.core.util.EndOfStreamException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang.StringEscapeUtils;

public class HttpUtil {
    private static DateFormat GMT_DATE_FORMAT = HttpUtil.createGMTDateFormat();

    public static DateFormat createGMTDateFormat() {
        SimpleDateFormat GMT_DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        GMT_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        return GMT_DATE_FORMAT;
    }

    public static String readLine(InputStream in) throws IOException, EndOfStreamException {
        int b;
        StringBuilder line = new StringBuilder(128);
        while ((b = in.read()) != -1) {
            if (b == 13) {
                in.read();
                return line.toString();
            }
            if (b == 10) {
                in.mark(2);
                if (in.read() != 13) {
                    in.reset();
                }
                return line.toString();
            }
            line.append((char)b);
        }
        throw new EOFWhileReadingLineException(line.toString());
    }

    public static int readChunkSize(InputStream in) throws IOException {
        StringBuilder buffer = new StringBuilder();
        int c = 0;
        while ((c = in.read()) != -1) {
            if (c == 13) {
                c = in.read();
                break;
            }
            if (c == 59) {
                while ((c = in.read()) != 10) {
                }
            }
            buffer.append((char)c);
        }
        return Integer.parseInt(buffer.toString().trim(), 16);
    }

    public static Response setHTMLErrorResponse(Response.ResponseBuilder responseBuilder, String message, String comment) {
        Response response = responseBuilder.build();
        response.setHeader(HttpUtil.createHeaders("text/html;charset=UTF-8", new String[0]));
        response.setBodyContent(HttpUtil.getHTMLErrorBody(message, comment).getBytes(Constants.UTF_8_CHARSET));
        return response;
    }

    private static String getHTMLErrorBody(String text, String comment) {
        StringBuilder buf = new StringBuilder(256);
        buf.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \r\n  \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\r\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\r\n<head>\r\n<title>Internal Server Error</title>\r\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\r\n<style><!--\r\nbody { font-family:sans-serif; } \r\n.footer { margin-top:20pt; color:#AAAAAA; padding:1em 0em; font-size:10pt; }\r\n.footer a { color:#AAAAAA; }\r\n.footer a:hover { color:#000000; }\r\n--></style></head>\r\n<body><h1>Internal Server Error</h1>");
        buf.append("<hr/>");
        buf.append("<p>While processing your request, the following error was detected. ");
        buf.append(comment);
        buf.append("</p>\r\n");
        buf.append("<pre id=\"msg\">");
        buf.append(StringEscapeUtils.escapeHtml((String)text));
        buf.append("</pre>");
        buf.append("<p class=\"footer\">");
        buf.append("Copyright \u00a92009-2016 <a href=\"http://predic8.com/\">predic8 GmbH</a>. All Rights Reserved. See <a href=\"http://www.membrane-soa.org/service-proxy/\">http://www.membrane-soa.org/service-proxy/</a> for documentation and updates.");
        buf.append("</p>");
        buf.append("</body>");
        return buf.toString();
    }

    public static Response createSOAPValidationErrorResponse(String message) {
        Response response = new Response();
        response.setStatusCode(400);
        response.setStatusMessage("Bad request");
        response.setHeader(HttpUtil.createHeaders("text/xml;charset=UTF-8", new String[0]));
        response.setBodyContent(HttpUtil.getFaultSOAPBody(message).getBytes(Constants.UTF_8_CHARSET));
        return response;
    }

    private static String getFaultSOAPBody(String text) {
        return HttpUtil.getFaultSOAPBody("Message validation failed!", text);
    }

    public static String getFaultSOAPBody(String title, String text) {
        StringBuilder buf = new StringBuilder(256);
        buf.append("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\">");
        buf.append("\r\n");
        buf.append("<soapenv:Body>");
        buf.append("\r\n");
        buf.append("<soapenv:Fault>");
        buf.append("\r\n");
        buf.append("<faultcode>soapenv:Server</faultcode>");
        buf.append("\r\n");
        buf.append("<faultstring>");
        buf.append(StringEscapeUtils.escapeXml((String)title));
        buf.append("</faultstring>");
        buf.append("\r\n");
        buf.append("<detail>" + StringEscapeUtils.escapeXml((String)text) + "</detail>");
        buf.append("\r\n");
        buf.append("</soapenv:Fault>");
        buf.append("\r\n");
        buf.append("</soapenv:Body>");
        buf.append("\r\n");
        buf.append("</soapenv:Envelope>");
        return buf.toString();
    }

    public static String getFaultSOAP12Body(String title, String text) {
        StringBuilder buf = new StringBuilder(256);
        buf.append("<soapenv:Envelope xmlns:soapenv=\"http://www.w3.org/2003/05/soap-envelope\">");
        buf.append("\r\n");
        buf.append("<soapenv:Body>");
        buf.append("\r\n");
        buf.append("<soapenv:Fault>");
        buf.append("\r\n");
        buf.append("<soapenv:Code>");
        buf.append("\r\n");
        buf.append("<soapenv:Value>soapenv:Receiver</soapenv:Value>");
        buf.append("\r\n");
        buf.append("</soapenv:Code>");
        buf.append("\r\n");
        buf.append("<soapenv:Reason><soapenv:Text xml:lang=\"en-US\">");
        buf.append(StringEscapeUtils.escapeXml((String)title));
        buf.append("</soapenv:Text></soapenv:Reason>");
        buf.append("\r\n");
        buf.append("<soapenv:Detail><Text>" + StringEscapeUtils.escapeXml((String)text) + "</Text></soapenv:Detail>");
        buf.append("\r\n");
        buf.append("</soapenv:Fault>");
        buf.append("\r\n");
        buf.append("</soapenv:Body>");
        buf.append("\r\n");
        buf.append("</soapenv:Envelope>");
        return buf.toString();
    }

    public static Response createResponse(int code, String msg, byte[] body, String contentType, String ... headers) {
        Response res = new Response();
        res.setStatusCode(code);
        res.setStatusMessage(msg);
        res.setHeader(HttpUtil.createHeaders(contentType, headers));
        if (body != null) {
            res.setBodyContent(body);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Header createHeaders(String contentType, String ... headers) {
        Header header = new Header();
        if (contentType != null) {
            header.setContentType(contentType);
        }
        DateFormat dateFormat = GMT_DATE_FORMAT;
        synchronized (dateFormat) {
            header.add("Date", GMT_DATE_FORMAT.format(new Date()));
        }
        header.add("Server", "Membrane Service Proxy " + Constants.VERSION + ". See http://membrane-soa.org");
        header.add("Connection", "close");
        for (int i = 0; i < headers.length; i += 2) {
            header.add(headers[i], headers[i + 1]);
        }
        return header;
    }

    public static List<Chunk> readChunks(InputStream in) throws IOException {
        int chunkSize;
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        while ((chunkSize = HttpUtil.readChunkSize(in)) > 0) {
            chunks.add(new Chunk(ByteUtil.readByteArray(in, chunkSize)));
            in.read();
            in.read();
        }
        in.read();
        in.read();
        return chunks;
    }

    public static String getHostName(String destination) throws MalformedURLException {
        return new URL(destination).getHost();
    }

    public static String getPathAndQueryString(String dest) throws MalformedURLException {
        URL url = new URL(dest);
        String uri = url.getPath();
        if (url.getQuery() != null) {
            return uri + "?" + url.getQuery();
        }
        return uri;
    }

    public static int getPort(String hostAndPort) {
        return Integer.parseInt(hostAndPort.split(":")[1]);
    }

    public static int getPort(URL url) throws MalformedURLException {
        int port = url.getPort();
        if (port == -1 && (port = url.getDefaultPort()) == -1) {
            port = 80;
        }
        return port;
    }

    public static boolean isAbsoluteURI(String uri) {
        return (uri = uri.toLowerCase()).startsWith("http://") || uri.startsWith("https://");
    }
}

