/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.util;

import com.google.common.collect.ImmutableSet;
import com.predic8.membrane.core.http.Message;
import com.predic8.membrane.core.multipart.XOPReconstitutor;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class ContentTypeDetector {
    private static final Set<String> contentTypesXML = ImmutableSet.of((Object)"text/xml", (Object)"application/xml", (Object)"multipart/related");
    private static final Set<String> contentTypesJSON = ImmutableSet.of((Object)"application/json", (Object)"application/x-javascript", (Object)"text/javascript", (Object)"text/x-javascript", (Object)"text/x-json");
    private static final XOPReconstitutor xopr = new XOPReconstitutor();
    private static final XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContentDescriptor detect(Message m) {
        block9: {
            try {
                XMLStreamReader reader;
                javax.mail.internet.ContentType t = m.getHeader().getContentTypeObject();
                if (t == null) {
                    return new ContentDescriptor(ContentType.UNKNOWN);
                }
                String type = t.getPrimaryType() + "/" + t.getSubType();
                if (contentTypesJSON.contains(type)) {
                    return new ContentDescriptor(ContentType.JSON);
                }
                if (!contentTypesXML.contains(type)) break block9;
                XMLInputFactory xMLInputFactory = xmlInputFactory;
                synchronized (xMLInputFactory) {
                    reader = xmlInputFactory.createXMLStreamReader(xopr.reconstituteIfNecessary(m));
                }
                if (reader.nextTag() == 1) {
                    boolean isSOAP;
                    boolean bl = isSOAP = "http://schemas.xmlsoap.org/soap/envelope/".equals(reader.getNamespaceURI()) || "http://www.w3.org/2003/05/soap-envelope".equals(reader.getNamespaceURI());
                    if (isSOAP) {
                        return new ContentDescriptor(ContentType.SOAP);
                    }
                    return new ContentDescriptor(ContentType.XML);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ContentDescriptor(ContentType.UNKNOWN);
    }

    static {
        xmlInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
        xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
    }

    public static class ContentDescriptor {
        private final ContentType effectiveContentType;

        public ContentDescriptor(ContentType effectiveContentType) {
            this.effectiveContentType = effectiveContentType;
        }

        public ContentType getEffectiveContentType() {
            return this.effectiveContentType;
        }
    }

    public static enum ContentType {
        SOAP,
        XML,
        JSON,
        UNKNOWN;

    }
}

