/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.ssl;

import com.google.common.base.Objects;
import com.predic8.membrane.core.config.security.SSLParser;
import com.predic8.membrane.core.config.security.Store;
import com.predic8.membrane.core.resolver.ResolverMap;
import com.predic8.membrane.core.transport.TrustManagerWrapper;
import com.predic8.membrane.core.transport.ssl.PEMSupport;
import com.predic8.membrane.core.transport.ssl.SSLContext;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticSSLContext
extends SSLContext {
    private static final String DEFAULT_CERTIFICATE_SHA256 = "c7:e3:fd:97:2f:d3:b9:4f:38:87:9c:45:32:70:b3:d8:c1:9f:d1:64:39:fc:48:5f:f4:a1:6a:95:b5:ca:08:f7";
    private static boolean default_certificate_warned = false;
    private static boolean limitedStrength;
    private static final Logger log;
    private final SSLParser sslParser;
    private List<String> dnsNames;
    private javax.net.ssl.SSLContext sslc;

    public StaticSSLContext(SSLParser sslParser, ResolverMap resourceResolver, String baseLocation) {
        this.sslParser = sslParser;
        try {
            TrustManager[] tms;
            KeyStore ks;
            String algorihm = KeyManagerFactory.getDefaultAlgorithm();
            if (sslParser.getAlgorithm() != null) {
                algorihm = sslParser.getAlgorithm();
            }
            KeyManagerFactory kmf = null;
            String keyStoreType = "JKS";
            if (sslParser.getKeyStore() != null) {
                if (sslParser.getKeyStore().getKeyAlias() != null) {
                    throw new InvalidParameterException("keyAlias is not yet supported.");
                }
                char[] keyPass = "changeit".toCharArray();
                if (sslParser.getKeyStore().getKeyPassword() != null) {
                    keyPass = sslParser.getKeyStore().getKeyPassword().toCharArray();
                }
                if (sslParser.getKeyStore().getType() != null) {
                    keyStoreType = sslParser.getKeyStore().getType();
                }
                ks = this.openKeyStore(sslParser.getKeyStore(), "JKS", keyPass, resourceResolver, baseLocation);
                kmf = KeyManagerFactory.getInstance(algorihm);
                kmf.init(ks, keyPass);
                Enumeration<String> aliases = ks.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = (String)aliases.nextElement();
                    if (!ks.isKeyEntry(alias)) continue;
                    this.dnsNames = this.getDNSNames(ks.getCertificate(alias));
                    break;
                }
            }
            if (sslParser.getKey() != null) {
                Key k;
                if (kmf != null) {
                    throw new InvalidParameterException("<key> may not be used together with <keystore>.");
                }
                KeyStore ks2 = KeyStore.getInstance(keyStoreType);
                ks2.load(null, "".toCharArray());
                ArrayList<Certificate> certs = new ArrayList<Certificate>();
                for (com.predic8.membrane.core.config.security.Certificate cert : sslParser.getKey().getCertificates()) {
                    certs.add(PEMSupport.getInstance().parseCertificate(cert.get(resourceResolver, baseLocation)));
                }
                if (certs.size() == 0) {
                    throw new RuntimeException("At least one //ssl/key/certificate is required.");
                }
                this.dnsNames = this.getDNSNames((Certificate)certs.get(0));
                this.checkChainValidity(certs);
                Object key = PEMSupport.getInstance().parseKey(sslParser.getKey().getPrivate().get(resourceResolver, baseLocation));
                Key key2 = k = key instanceof Key ? (Key)key : ((KeyPair)key).getPrivate();
                if (k instanceof RSAPrivateCrtKey && ((Certificate)certs.get(0)).getPublicKey() instanceof RSAPublicKey) {
                    RSAPrivateCrtKey privkey = (RSAPrivateCrtKey)k;
                    RSAPublicKey pubkey = (RSAPublicKey)((Certificate)certs.get(0)).getPublicKey();
                    if (!privkey.getModulus().equals(pubkey.getModulus()) || !privkey.getPublicExponent().equals(pubkey.getPublicExponent())) {
                        log.warn("Certificate does not fit to key.");
                    }
                }
                ks2.setKeyEntry("inlinePemKeyAndCertificate", k, "".toCharArray(), certs.toArray(new Certificate[certs.size()]));
                kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                String keyPassword = "";
                if (sslParser.getKey().getPassword() != null) {
                    keyPassword = sslParser.getKey().getPassword();
                }
                kmf.init(ks2, keyPassword.toCharArray());
            }
            TrustManagerFactory tmf = null;
            if (sslParser.getTrustStore() != null) {
                String trustAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
                if (sslParser.getTrustStore().getAlgorithm() != null) {
                    trustAlgorithm = sslParser.getTrustStore().getAlgorithm();
                }
                KeyStore ks3 = this.openKeyStore(sslParser.getTrustStore(), keyStoreType, null, resourceResolver, baseLocation);
                tmf = TrustManagerFactory.getInstance(trustAlgorithm);
                tmf.init(ks3);
            }
            if (sslParser.getTrust() != null) {
                if (tmf != null) {
                    throw new InvalidParameterException("<trust> may not be used together with <truststore>.");
                }
                ks = KeyStore.getInstance(keyStoreType);
                ks.load(null, "".toCharArray());
                for (int j = 0; j < sslParser.getTrust().getCertificateList().size(); ++j) {
                    ks.setCertificateEntry("inlinePemCertificate" + j, PEMSupport.getInstance().parseCertificate(sslParser.getTrust().getCertificateList().get(j).get(resourceResolver, baseLocation)));
                }
                tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(ks);
            }
            TrustManager[] trustManagerArray = tms = tmf != null ? tmf.getTrustManagers() : null;
            if (sslParser.isIgnoreTimestampCheckFailure()) {
                tms = new TrustManager[]{new TrustManagerWrapper(tms, true)};
            }
            this.sslc = sslParser.getProtocol() != null ? javax.net.ssl.SSLContext.getInstance(sslParser.getProtocol()) : javax.net.ssl.SSLContext.getInstance("TLS");
            this.sslc.init(kmf != null ? kmf.getKeyManagers() : null, tms, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.init(sslParser, this.sslc);
    }

    public StaticSSLContext(SSLParser sslParser, javax.net.ssl.SSLContext sslc) {
        this.sslParser = sslParser;
        this.sslc = sslc;
        this.init(sslParser, sslc);
    }

    private List<String> getDNSNames(Certificate certificate) throws CertificateParsingException {
        X509Certificate x;
        Collection<List<?>> subjectAlternativeNames;
        ArrayList<String> dnsNames = new ArrayList<String>();
        if (certificate instanceof X509Certificate && (subjectAlternativeNames = (x = (X509Certificate)certificate).getSubjectAlternativeNames()) != null) {
            for (List<?> l : subjectAlternativeNames) {
                if (!(l.get(0) instanceof Integer) || (Integer)l.get(0) != 2) continue;
                dnsNames.add(l.get(1).toString());
            }
        }
        return dnsNames;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SSLContext)) {
            return false;
        }
        StaticSSLContext other = (StaticSSLContext)obj;
        return Objects.equal((Object)this.sslParser, (Object)other.sslParser);
    }

    private KeyStore openKeyStore(Store store, String defaultType, char[] keyPass, ResolverMap resourceResolver, String baseLocation) throws NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, KeyStoreException, NoSuchProviderException {
        String type = store.getType();
        if (type == null) {
            type = defaultType;
        }
        char[] password = keyPass;
        if (store.getPassword() != null) {
            password = store.getPassword().toCharArray();
        }
        if (password == null) {
            throw new InvalidParameterException("Password for key store is not set.");
        }
        KeyStore ks = store.getProvider() != null ? KeyStore.getInstance(type, store.getProvider()) : KeyStore.getInstance(type);
        ks.load(resourceResolver.resolve(ResolverMap.combine(baseLocation, store.getLocation())), password);
        if (!default_certificate_warned && ks.getCertificate("membrane") != null) {
            byte[] pkeEnc = ks.getCertificate("membrane").getEncoded();
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(pkeEnc);
            byte[] mdbytes = md.digest();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < mdbytes.length; ++i) {
                if (i > 0) {
                    sb.append(':');
                }
                sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
            }
            if (sb.toString().equals(DEFAULT_CERTIFICATE_SHA256)) {
                log.warn("Using Membrane with the default certificate. This is highly discouraged! Please run the generate-ssl-keys script in the conf directory.");
                default_certificate_warned = true;
            }
        }
        return ks;
    }

    public void applyCiphers(SSLServerSocket sslServerSocket) {
        if (this.ciphers != null) {
            SSLParameters sslParameters = sslServerSocket.getSSLParameters();
            this.applyCipherOrdering(sslParameters);
            sslParameters.setCipherSuites(this.ciphers);
            sslServerSocket.setSSLParameters(sslParameters);
        }
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress bindAddress) throws IOException {
        SSLServerSocketFactory sslssf = this.sslc.getServerSocketFactory();
        SSLServerSocket sslss = (SSLServerSocket)sslssf.createServerSocket(port, backlog, bindAddress);
        this.applyCiphers(sslss);
        if (this.protocols != null) {
            sslss.setEnabledProtocols(this.protocols);
        } else {
            String[] protocols = sslss.getEnabledProtocols();
            HashSet<String> set = new HashSet<String>();
            for (String protocol : protocols) {
                if (protocol.equals("SSLv3") || protocol.equals("SSLv2Hello")) continue;
                set.add(protocol);
            }
            sslss.setEnabledProtocols(set.toArray(new String[0]));
        }
        sslss.setWantClientAuth(this.wantClientAuth);
        sslss.setNeedClientAuth(this.needClientAuth);
        return sslss;
    }

    @Override
    public Socket wrapAcceptedSocket(Socket socket) throws IOException {
        return socket;
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, int connectTimeout, @Nullable String sniServerName) throws IOException {
        SSLSocketFactory sslsf = this.sslc.getSocketFactory();
        SSLSocket ssls = (SSLSocket)sslsf.createSocket(socket, host, port, true);
        this.applySNI(ssls, sniServerName, host);
        if (this.protocols != null) {
            ssls.setEnabledProtocols(this.protocols);
        } else {
            String[] protocols = ssls.getEnabledProtocols();
            HashSet<String> set = new HashSet<String>();
            for (String protocol : protocols) {
                if (protocol.equals("SSLv3") || protocol.equals("SSLv2Hello")) continue;
                set.add(protocol);
            }
            ssls.setEnabledProtocols(set.toArray(new String[0]));
        }
        this.applyCiphers(ssls);
        return ssls;
    }

    @Override
    public Socket createSocket(String host, int port, int connectTimeout, @Nullable String sniServerName) throws IOException {
        Socket s = new Socket();
        s.connect(new InetSocketAddress(host, port), connectTimeout);
        return this.createSocket(s, host, port, connectTimeout, sniServerName);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress addr, int localPort, int connectTimeout, @Nullable String sniServerName) throws IOException {
        Socket s = new Socket();
        s.bind(new InetSocketAddress(addr, localPort));
        s.connect(new InetSocketAddress(host, port), connectTimeout);
        return this.createSocket(s, host, port, connectTimeout, sniServerName);
    }

    private void applySNI(@NotNull SSLSocket ssls, @Nullable String sniServerName, @NotNull String defaultHost) {
        if (sniServerName != null && sniServerName.isEmpty()) {
            return;
        }
        if (sniServerName == null) {
            sniServerName = defaultHost;
        }
        SNIHostName name = new SNIHostName(sniServerName.getBytes());
        ArrayList<SNIServerName> serverNames = new ArrayList<SNIServerName>(1);
        serverNames.add(name);
        SSLParameters params = ssls.getSSLParameters();
        params.setServerNames(serverNames);
        ssls.setSSLParameters(params);
    }

    @Override
    SSLSocketFactory getSocketFactory() {
        return this.sslc.getSocketFactory();
    }

    @Override
    List<String> getDnsNames() {
        return this.dnsNames;
    }

    @Override
    String getLocation() {
        return this.sslParser.getKeyStore() != null ? this.sslParser.getKeyStore().getLocation() : "null";
    }

    static {
        log = LoggerFactory.getLogger((String)StaticSSLContext.class.getName());
        String dhKeySize = System.getProperty("jdk.tls.ephemeralDHKeySize");
        if (dhKeySize == null || "legacy".equals(dhKeySize)) {
            System.setProperty("jdk.tls.ephemeralDHKeySize", "matched");
        }
        try {
            boolean bl = limitedStrength = Cipher.getMaxAllowedKeyLength("AES") <= 128;
            if (limitedStrength) {
                log.warn("Your Java Virtual Machine does not have unlimited strength cryptography. If it is legal in your country, we strongly advise installing the Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files.");
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }
}

