/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.ssl;

import com.oracle.util.ssl.SSLCapabilities;
import com.oracle.util.ssl.SSLExplorer;
import com.predic8.membrane.core.config.ConfigurationException;
import com.predic8.membrane.core.rules.ServiceProxyKey;
import com.predic8.membrane.core.transport.ssl.SSLContext;
import com.predic8.membrane.core.transport.ssl.SSLProvider;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.net.ssl.SNIServerName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLContextCollection
implements SSLProvider {
    private static final Logger log = LoggerFactory.getLogger((String)SSLContextCollection.class.getName());
    private final List<SSLContext> sslContexts;
    private final List<Pattern> dnsNames = new ArrayList<Pattern>();

    private SSLContextCollection(List<SSLContext> sslContexts, List<String> dnsNames) {
        for (String dnsName : dnsNames) {
            this.dnsNames.add(Pattern.compile(ServiceProxyKey.createHostPattern(dnsName), 2));
        }
        this.sslContexts = sslContexts;
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress bindAddress) throws IOException {
        return new ServerSocket(port, 50, bindAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Socket wrapAcceptedSocket(Socket socket) throws IOException {
        List<SNIServerName> serverNames;
        int position;
        int n;
        InputStream ins = socket.getInputStream();
        byte[] buffer = new byte[255];
        SSLCapabilities capabilities = null;
        socket.setSoTimeout(30000);
        for (position = 0; position < 5; position += n) {
            int count = 5 - position;
            n = ins.read(buffer, position, count);
            if (n >= 0) continue;
            throw new IOException("unexpected end of stream!");
        }
        int recordLength = SSLExplorer.getRequiredSize(buffer, 0, position);
        if (buffer.length < recordLength) {
            buffer = Arrays.copyOf(buffer, recordLength);
        }
        while (position < recordLength) {
            int count = recordLength - position;
            int n2 = ins.read(buffer, position, count);
            if (n2 < 0) {
                throw new IOException("unexpected end of stream!");
            }
            position += n2;
        }
        capabilities = SSLExplorer.explore(buffer, 0, recordLength);
        SSLContext sslContext = null;
        if (capabilities != null && (serverNames = capabilities.getServerNames()) != null && serverNames.size() > 0) {
            block5: for (SNIServerName snisn : serverNames) {
                String hostname = new String(snisn.getEncoded(), "UTF-8");
                for (int i = 0; i < this.dnsNames.size(); ++i) {
                    if (!this.dnsNames.get(i).matcher(hostname).matches()) continue;
                    sslContext = this.sslContexts.get(i);
                    break block5;
                }
            }
            if (sslContext == null) {
                byte[] alert_unrecognized_name = new byte[]{21, 3, 1, 0, 2, 2, 112};
                try {
                    socket.getOutputStream().write(alert_unrecognized_name);
                }
                finally {
                    socket.close();
                }
                StringBuilder hostname = null;
                for (SNIServerName snisn : serverNames) {
                    if (hostname == null) {
                        hostname = new StringBuilder();
                    } else {
                        hostname.append(", ");
                    }
                    hostname.append(new String(snisn.getEncoded(), "UTF-8"));
                }
                throw new RuntimeException("no certificate configured (sending unrecognized_name alert) for hostname \"" + hostname + "\"");
            }
        }
        if (sslContext == null) {
            sslContext = this.sslContexts.get(0);
        }
        return sslContext.wrap(socket, buffer, position);
    }

    private SSLContext getSSLContextForHostname(String hostname) {
        SSLContext sslContext = null;
        for (int i = 0; i < this.dnsNames.size(); ++i) {
            if (!this.dnsNames.get(i).matcher(hostname).matches()) continue;
            sslContext = this.sslContexts.get(i);
            break;
        }
        if (sslContext == null) {
            sslContext = this.sslContexts.get(0);
        }
        return sslContext;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress addr, int localPort, int connectTimeout, @Nullable String sniServerName) throws IOException {
        return this.getSSLContextForHostname(host).createSocket(host, port, addr, localPort, connectTimeout, sniServerName);
    }

    @Override
    public boolean showSSLExceptions() {
        for (SSLContext ctx : this.sslContexts) {
            if (ctx.showSSLExceptions()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Socket createSocket(String host, int port, int connectTimeout, @Nullable String sniServerName) throws IOException {
        return this.getSSLContextForHostname(host).createSocket(host, port, connectTimeout, sniServerName);
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, int connectTimeout, @Nullable String sniServerName) throws IOException {
        return this.getSSLContextForHostname(host).createSocket(s, host, port, connectTimeout, sniServerName);
    }

    public static class Builder {
        private List<String> dnsNames = new ArrayList<String>();
        private List<SSLContext> sslContexts = new ArrayList<SSLContext>();

        public SSLProvider build() throws ConfigurationException {
            if (this.sslContexts.isEmpty()) {
                throw new IllegalStateException("No SSLContext's were added to this Builder before invoking build().");
            }
            if (this.sslContexts.size() > 1) {
                return new SSLContextCollection(this.sslContexts, this.dnsNames);
            }
            return this.sslContexts.get(0);
        }

        public void add(SSLContext sslContext) {
            if (!this.sslContexts.contains(sslContext)) {
                this.sslContexts.add(sslContext);
                this.dnsNames.add(sslContext.constructHostNamePattern());
            }
        }
    }
}

