/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.ssl;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import com.predic8.membrane.core.config.security.SSLParser;
import com.predic8.membrane.core.transport.ssl.SSLProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.InvalidParameterException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SSLContext
implements SSLProvider {
    private static final Logger log = LoggerFactory.getLogger((String)SSLContext.class.getName());
    protected String[] ciphers;
    protected String[] protocols;
    protected boolean wantClientAuth;
    protected boolean needClientAuth;
    protected String endpointIdentificationAlgorithm;
    private boolean showSSLExceptions = true;

    public void init(SSLParser sslParser, javax.net.ssl.SSLContext sslc) {
        this.showSSLExceptions = sslParser.isShowSSLExceptions();
        if (sslParser.getCiphers() != null) {
            this.ciphers = sslParser.getCiphers().split(",");
            HashSet supportedCiphers = Sets.newHashSet((Object[])sslc.getSocketFactory().getSupportedCipherSuites());
            for (String cipher : this.ciphers) {
                if (!supportedCiphers.contains(cipher)) {
                    throw new InvalidParameterException("Unknown cipher " + cipher);
                }
                if (cipher.contains("_RC4_")) {
                    log.warn("Cipher " + cipher + " uses RC4, which is deprecated.");
                }
                if (!cipher.contains("_3DES_")) continue;
                log.warn("Cipher " + cipher + " uses 3DES, which is deprecated.");
            }
        } else {
            String[] supportedCiphers = sslc.getSocketFactory().getDefaultCipherSuites();
            ArrayList<String> ciphers = new ArrayList<String>(supportedCiphers.length);
            for (String cipher : supportedCiphers) {
                if (cipher.contains("_RC4_") || cipher.contains("_3DES_")) continue;
                ciphers.add(cipher);
            }
            this.sortCiphers(ciphers);
            this.ciphers = ciphers.toArray(new String[ciphers.size()]);
        }
        this.protocols = sslParser.getProtocols() != null ? sslParser.getProtocols().split(",") : null;
        if (sslParser.getClientAuth() == null) {
            this.needClientAuth = false;
            this.wantClientAuth = false;
        } else if (sslParser.getClientAuth().equals("need")) {
            this.needClientAuth = true;
            this.wantClientAuth = true;
        } else if (sslParser.getClientAuth().equals("want")) {
            this.needClientAuth = false;
            this.wantClientAuth = true;
        } else {
            throw new RuntimeException("Invalid value '" + sslParser.getClientAuth() + "' in clientAuth: expected 'want', 'need' or not set.");
        }
        this.endpointIdentificationAlgorithm = sslParser.getEndpointIdentificationAlgorithm();
    }

    abstract String getLocation();

    abstract List<String> getDnsNames();

    public Socket wrap(Socket socket, byte[] buffer, int position) throws IOException {
        SSLSocketFactory serviceSocketFac = this.getSocketFactory();
        ByteArrayInputStream bais = new ByteArrayInputStream(buffer, 0, position);
        SSLSocket serviceSocket = (SSLSocket)serviceSocketFac.createSocket(socket, bais, true);
        this.applyCiphers(serviceSocket);
        if (this.getProtocols() != null) {
            serviceSocket.setEnabledProtocols(this.getProtocols());
        } else {
            String[] protocols = serviceSocket.getEnabledProtocols();
            HashSet<String> set = new HashSet<String>();
            for (String protocol : protocols) {
                if (protocol.equals("SSLv3") || protocol.equals("SSLv2Hello")) continue;
                set.add(protocol);
            }
            serviceSocket.setEnabledProtocols(set.toArray(new String[0]));
        }
        serviceSocket.setWantClientAuth(this.isWantClientAuth());
        serviceSocket.setNeedClientAuth(this.isNeedClientAuth());
        return serviceSocket;
    }

    public void applyCiphers(SSLSocket sslSocket) {
        if (this.ciphers != null) {
            SSLParameters sslParameters = sslSocket.getSSLParameters();
            this.applyCipherOrdering(sslParameters);
            sslParameters.setCipherSuites(this.ciphers);
            sslParameters.setEndpointIdentificationAlgorithm(this.endpointIdentificationAlgorithm);
            sslSocket.setSSLParameters(sslParameters);
        }
    }

    protected void applyCipherOrdering(SSLParameters sslParameters) {
        sslParameters.setUseCipherSuitesOrder(true);
    }

    String[] getCiphers() {
        return this.ciphers;
    }

    String[] getProtocols() {
        return this.protocols;
    }

    boolean isNeedClientAuth() {
        return this.needClientAuth;
    }

    boolean isWantClientAuth() {
        return this.wantClientAuth;
    }

    private void sortCiphers(ArrayList<String> ciphers) {
        ArrayList<CipherInfo> cipherInfos = new ArrayList<CipherInfo>(ciphers.size());
        for (String cipher : ciphers) {
            cipherInfos.add(new CipherInfo(cipher));
        }
        Collections.sort(cipherInfos, new Comparator<CipherInfo>(){

            @Override
            public int compare(CipherInfo cipher1, CipherInfo cipher2) {
                return cipher2.points - cipher1.points;
            }
        });
        for (int i = 0; i < ciphers.size(); ++i) {
            ciphers.set(i, ((CipherInfo)cipherInfos.get((int)i)).cipher);
        }
    }

    public String constructHostNamePattern() {
        StringBuilder sb = null;
        List<String> dnsNames = this.getDnsNames();
        if (dnsNames == null) {
            throw new RuntimeException("Could not extract DNS names from the first key's certificate in " + this.getLocation());
        }
        for (String dnsName : dnsNames) {
            if (sb == null) {
                sb = new StringBuilder();
            } else {
                sb.append(" ");
            }
            sb.append(dnsName);
        }
        if (sb == null) {
            log.warn("Could not retrieve DNS hostname for certificate, using '*': " + this.getLocation());
            return "*";
        }
        return sb.toString();
    }

    abstract SSLSocketFactory getSocketFactory();

    protected void checkChainValidity(List<Certificate> certs) {
        boolean valid = true;
        for (int i = 0; i < certs.size() - 1; ++i) {
            String currentIssuer = ((X509Certificate)certs.get(i)).getIssuerX500Principal().toString();
            String nextSubject = ((X509Certificate)certs.get(i + 1)).getSubjectX500Principal().toString();
            valid = valid && Objects.equal((Object)currentIssuer, (Object)nextSubject);
        }
        if (!valid) {
            StringBuilder sb = new StringBuilder();
            sb.append("Certificate chain is not valid:\n");
            for (int i = 0; i < certs.size(); ++i) {
                sb.append("Cert " + String.format("%2d", i) + ": Subject: " + ((X509Certificate)certs.get(i)).getSubjectX500Principal().toString() + "\n");
                sb.append("         Issuer: " + ((X509Certificate)certs.get(i)).getIssuerX500Principal().toString() + "\n");
            }
            log.warn(sb.toString());
        }
    }

    @Override
    public boolean showSSLExceptions() {
        return this.showSSLExceptions;
    }

    private static class CipherInfo {
        public final String cipher;
        public final int points;

        public CipherInfo(String cipher) {
            this.cipher = cipher;
            int points = 0;
            if (this.supportsPFS(cipher)) {
                points = 1;
            }
            this.points = points;
        }

        private boolean supportsPFS(String cipher2) {
            return this.cipher.contains("_DHE_RSA_") || this.cipher.contains("_DHE_DSS_") || this.cipher.contains("_ECDHE_RSA_") || this.cipher.contains("_ECDHE_ECDSA_");
        }
    }
}

