/*
 * Decompiled with CFR 0.152.
 */
package com.predic8.membrane.core.transport.http;

import com.predic8.membrane.core.exchange.Exchange;
import com.predic8.membrane.core.http.AbstractBody;
import com.predic8.membrane.core.http.MessageObserver;
import com.predic8.membrane.core.http.Request;
import com.predic8.membrane.core.http.Response;
import com.predic8.membrane.core.transport.http.AbortException;
import com.predic8.membrane.core.transport.http.AbstractHttpHandler;
import com.predic8.membrane.core.transport.http.Connection;
import com.predic8.membrane.core.transport.http.EOFWhileReadingFirstLineException;
import com.predic8.membrane.core.transport.http.HttpEndpointListener;
import com.predic8.membrane.core.transport.http.HttpTransport;
import com.predic8.membrane.core.transport.http.NoMoreRequestsException;
import com.predic8.membrane.core.transport.http.NoResponseException;
import com.predic8.membrane.core.transport.ssl.SSLProvider;
import com.predic8.membrane.core.util.DNSCache;
import com.predic8.membrane.core.util.EndOfStreamException;
import com.predic8.membrane.core.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServerHandler
extends AbstractHttpHandler
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(HttpServerHandler.class);
    private static final AtomicInteger counter = new AtomicInteger();
    private final HttpEndpointListener endpointListener;
    private Socket sourceSocket;
    private InputStream srcIn;
    private OutputStream srcOut;
    private boolean showSSLExceptions = true;

    public HttpServerHandler(Socket socket, HttpEndpointListener endpointListener) throws IOException {
        super(endpointListener.getTransport());
        this.endpointListener = endpointListener;
        this.sourceSocket = socket;
    }

    @Override
    public HttpTransport getTransport() {
        return (HttpTransport)super.getTransport();
    }

    private void setup() throws IOException {
        this.exchange = new Exchange(this);
        SSLProvider sslProvider = this.endpointListener.getSslProvider();
        if (sslProvider != null) {
            this.showSSLExceptions = sslProvider.showSSLExceptions();
            this.sourceSocket = sslProvider.wrapAcceptedSocket(this.sourceSocket);
        } else {
            this.showSSLExceptions = false;
        }
        log.debug("New ServerThread created. " + counter.incrementAndGet());
        this.srcIn = new BufferedInputStream(this.sourceSocket.getInputStream(), 2048);
        this.srcOut = new BufferedOutputStream(this.sourceSocket.getOutputStream(), 2048);
        this.sourceSocket.setSoTimeout(this.endpointListener.getTransport().getSocketTimeout());
        this.sourceSocket.setTcpNoDelay(this.endpointListener.getTransport().isTcpNoDelay());
    }

    @Override
    public void run() {
        Connection boundConnection = null;
        try {
            this.updateThreadName(true);
            this.setup();
            while (true) {
                this.srcReq = new Request();
                this.endpointListener.setIdleStatus(this.sourceSocket, true);
                try {
                    this.srcIn.mark(2);
                    if (this.srcIn.read() == -1) break;
                    this.srcIn.reset();
                }
                finally {
                    this.endpointListener.setIdleStatus(this.sourceSocket, false);
                }
                if (boundConnection != null) {
                    this.exchange.setTargetConnection(boundConnection);
                    boundConnection = null;
                }
                this.srcReq.read(this.srcIn, true);
                this.exchange.received();
                if (this.srcReq.getHeader().getProxyConnection() != null) {
                    this.srcReq.getHeader().add("Connection", this.srcReq.getHeader().getProxyConnection());
                    this.srcReq.getHeader().removeFields("Proxy-Connection");
                }
                this.process();
                if (this.srcReq.isCONNECTRequest()) {
                    log.debug("stopping HTTP Server Thread after establishing an HTTP connect");
                    return;
                }
                boundConnection = this.exchange.getTargetConnection();
                this.exchange.setTargetConnection(null);
                if (!this.exchange.canKeepConnectionAlive()) {
                    break;
                }
                if (this.exchange.getResponse().isRedirect()) {
                    break;
                }
                this.exchange.detach();
                this.exchange = new Exchange(this);
            }
        }
        catch (SocketTimeoutException e) {
            log.debug("Socket of thread " + counter + " timed out");
        }
        catch (SocketException se) {
            log.debug("client socket closed");
        }
        catch (SSLException s) {
            if (this.showSSLExceptions) {
                if (s.getCause() instanceof SSLException) {
                    s = (SSLException)s.getCause();
                }
                if (s.getCause() instanceof SocketException) {
                    log.debug("ssl socket closed");
                } else {
                    log.error("", (Throwable)s);
                }
            }
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
        catch (EndOfStreamException e) {
            log.debug("stream closed");
        }
        catch (AbortException e) {
            log.debug("exchange aborted.");
        }
        catch (NoMoreRequestsException e) {
        }
        catch (NoResponseException e) {
            log.debug("No response received. Maybe increase the keep-alive timeout on the server.");
        }
        catch (EOFWhileReadingFirstLineException e) {
            log.debug("Client connection terminated before line was read. Line so far: (" + e.getLineSoFar() + ")");
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        finally {
            this.endpointListener.setOpenStatus(this.sourceSocket, false);
            if (boundConnection != null) {
                try {
                    boundConnection.close();
                }
                catch (IOException e) {
                    log.debug("Closing bound connection.", (Throwable)e);
                }
            }
            this.closeConnections();
            this.exchange.detach();
            this.updateThreadName(false);
        }
    }

    private void closeConnections() {
        try {
            if (!this.sourceSocket.isClosed()) {
                if (!(this.sourceSocket instanceof SSLSocket)) {
                    this.sourceSocket.shutdownOutput();
                }
                this.sourceSocket.close();
            }
        }
        catch (Exception e2) {
            if (e2.getMessage().contains("Socket closed")) {
                return;
            }
            log.error("problems closing socket on remote port: " + this.sourceSocket.getPort() + " on remote host: " + this.sourceSocket.getInetAddress(), (Throwable)e2);
        }
    }

    private void process() throws Exception {
        try {
            DNSCache dnsCache = this.getTransport().getRouter().getDnsCache();
            InetAddress remoteAddr = this.sourceSocket.getInetAddress();
            String ip = dnsCache.getHostAddress(remoteAddr);
            this.exchange.setRemoteAddrIp(ip);
            this.exchange.setRemoteAddr(this.getTransport().isReverseDNS() ? dnsCache.getHostName(remoteAddr) : ip);
            this.exchange.setRequest(this.srcReq);
            this.exchange.setOriginalRequestUri(this.srcReq.getUri());
            if (this.exchange.getRequest().getHeader().is100ContinueExpected()) {
                final Request request = this.exchange.getRequest();
                request.addObserver(new MessageObserver(){

                    @Override
                    public void bodyRequested(AbstractBody body) {
                        try {
                            if (request.getHeader().is100ContinueExpected()) {
                                Response.continue100().build().write(HttpServerHandler.this.srcOut);
                                request.getHeader().removeFields("Expect");
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }

                    @Override
                    public void bodyComplete(AbstractBody body) {
                    }
                });
            }
            this.invokeHandlers();
            this.exchange.blockResponseIfNeeded();
        }
        catch (AbortException e) {
            log.debug("Aborted");
            this.exchange.finishExchange(true, e.getMessage());
            this.removeBodyFromBuffer();
            this.writeResponse(this.exchange.getResponse());
            log.debug("exchange set aborted");
            return;
        }
        try {
            this.removeBodyFromBuffer();
            this.writeResponse(this.exchange.getResponse());
            this.exchange.setCompleted();
            log.debug("exchange set completed");
        }
        catch (Exception e) {
            this.exchange.finishExchange(true, e.getMessage());
            throw e;
        }
    }

    private void removeBodyFromBuffer() throws IOException {
        if (!this.exchange.getRequest().getHeader().is100ContinueExpected() || this.srcIn.available() > 0) {
            this.exchange.getRequest().readBody();
        }
    }

    private void updateThreadName(boolean fromConnection) {
        if (fromConnection) {
            StringBuilder sb = new StringBuilder();
            sb.append("RouterThread");
            sb.append(" ");
            InetAddress ia = this.sourceSocket.getInetAddress();
            if (ia != null) {
                sb.append(ia.toString());
            }
            sb.append(":");
            sb.append(this.sourceSocket.getPort());
            Thread.currentThread().setName(sb.toString());
        } else {
            Thread.currentThread().setName("RouterThread");
        }
    }

    protected void writeResponse(Response res) throws Exception {
        if (res.isRedirect()) {
            res.getHeader().setConnection("close");
        }
        res.write(this.srcOut);
        this.srcOut.flush();
        this.exchange.setTimeResSent(System.currentTimeMillis());
        this.exchange.collectStatistics();
    }

    @Override
    public void shutdownInput() throws IOException {
        Util.shutdownInput(this.sourceSocket);
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.sourceSocket.getLocalAddress();
    }

    @Override
    public int getLocalPort() {
        return this.sourceSocket.getLocalPort();
    }

    public InputStream getSrcIn() {
        return this.srcIn;
    }

    public OutputStream getSrcOut() {
        return this.srcOut;
    }

    public Socket getSourceSocket() {
        return this.sourceSocket;
    }
}

